/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.framework.internal.tooling.type.propagation.utils.AggregatorsUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class CoreUtils {
    public static final String MULE_NAMESPACE = "mule";
    public static final String EE_NAMESPACE = "ee";
    public static final String BATCH_NAMESPACE = "batch";
    public static final String PAYLOAD_BINDING = "payload";
    public static final String ATTRIBUTES_BINDING = "attributes";
    public static final String VARIABLES_PRE_BINDING = "vars.";
    public static final ComponentIdentifier SET_PAYLOAD_IDENTIFIER = ComponentIdentifier.builder().name("set-payload").namespace("mule").build();
    public static final ComponentIdentifier SET_VARIABLE_IDENTIFIER = ComponentIdentifier.builder().name("set-variable").namespace("mule").build();
    public static final ComponentIdentifier REMOVE_VARIABLE_IDENTIFIER = ComponentIdentifier.builder().name("remove-variable").namespace("mule").build();
    public static final ComponentIdentifier EE_TRANSFORM_IDENTIFIER = ComponentIdentifier.builder().name("transform").namespace("ee").build();
    public static final ComponentIdentifier CACHE_IDENTIFIER = ComponentIdentifier.builder().name("cache").namespace("ee").build();
    public static final ComponentIdentifier TRY_IDENTIFIER = ComponentIdentifier.builder().name("try").namespace("mule").build();
    public static final ComponentIdentifier UNTIL_SUCCESSFUL_IDENTIFIER = ComponentIdentifier.builder().name("until-successful").namespace("mule").build();
    public static final ComponentIdentifier LOGGER_IDENTIFIER = ComponentIdentifier.builder().name("logger").namespace("mule").build();
    public static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().name("flow-ref").namespace("mule").build();
    public static final ComponentIdentifier FOREACH_IDENTIFIER = ComponentIdentifier.builder().name("foreach").namespace("mule").build();
    public static final ComponentIdentifier PARALLEL_FOREACH_IDENTIFIER = ComponentIdentifier.builder().name("parallel-foreach").namespace("mule").build();
    public static final ComponentIdentifier SCATTER_GATHER_IDENTIFIER = ComponentIdentifier.builder().name("scatter-gather").namespace("mule").build();
    public static final ComponentIdentifier CHOICE_IDENTIFIER = ComponentIdentifier.builder().name("choice").namespace("mule").build();
    public static final ComponentIdentifier FIRST_SUCCESSFUL_IDENTIFIER = ComponentIdentifier.builder().name("first-successful").namespace("mule").build();
    public static final ComponentIdentifier ROUND_ROBIN_IDENTIFIER = ComponentIdentifier.builder().name("round-robin").namespace("mule").build();
    public static final ComponentIdentifier ASYNC_IDENTIFIER = ComponentIdentifier.builder().name("async").namespace("mule").build();
    public static final ComponentIdentifier BATCH_JOB_IDENTIFIER = ComponentIdentifier.builder().name("job").namespace("batch").build();
    public static final ComponentIdentifier BATCH_ON_COMPLETE_IDENTIFIER = ComponentIdentifier.builder().name("on-complete").namespace("batch").build();
    public static final ComponentIdentifier MUNIT_SET_EVENT_IDENTIFIER = ComponentIdentifier.builder().name("set-event").namespace("munit").build();
    private static final Set<ComponentIdentifier> SPECIAL_HANDLING = new HashSet<ComponentIdentifier>();

    private CoreUtils() {
    }

    public static boolean requiresSpecialHandling(ComponentIdentifier identifier) {
        return SPECIAL_HANDLING.contains(identifier);
    }

    public static boolean belongsToMule(ComponentIdentifier identifier) {
        String namespace = identifier.getNamespace();
        return MULE_NAMESPACE.equals(namespace) || EE_NAMESPACE.equals(namespace) || BATCH_NAMESPACE.equals(namespace);
    }

    public static MetadataType batchResultInput() {
        ObjectTypeBuilder builder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
        NumberType numberType = new BaseTypeBuilder(MetadataFormat.JAVA).numberType().build();
        DefaultStringType stringType = new BaseTypeBuilder(MetadataFormat.JAVA).stringType().build();
        BooleanType booleanType = new BaseTypeBuilder(MetadataFormat.JAVA).booleanType().build();
        AnyType exceptionType = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
        builder.addField().key("elapsedTimeInMillis").value((MetadataType)numberType).required();
        builder.addField().key("successfulRecords").value((MetadataType)numberType).required();
        builder.addField().key("failedRecords").value((MetadataType)numberType).required();
        builder.addField().key("totalRecords").value((MetadataType)numberType).required();
        builder.addField().key("loadedRecords").value((MetadataType)numberType).required();
        builder.addField().key("processedRecords").value((MetadataType)numberType).required();
        builder.addField().key("getBatchJobInstanceId").value((MetadataType)stringType).required();
        builder.addField().key("failedOnInputPhase").value((MetadataType)booleanType).required();
        builder.addField().key("failedOnLoadingPhase").value((MetadataType)booleanType).required();
        builder.addField().key("failedOnCompletePhase").value((MetadataType)booleanType).required();
        builder.addField().key("inputPhaseException").value((MetadataType)exceptionType);
        builder.addField().key("loadingPhaseException").value((MetadataType)exceptionType);
        builder.addField().key("onCompletePhaseException").value((MetadataType)exceptionType);
        return builder.build();
    }

    public static boolean skipConditionsFor(ComponentAst componentAst, ParameterModel paramModel) {
        ComponentIdentifier identifier = componentAst.getIdentifier();
        if (identifier.equals(LOGGER_IDENTIFIER) || identifier.equals(SET_PAYLOAD_IDENTIFIER) || identifier.equals(SET_VARIABLE_IDENTIFIER)) {
            return true;
        }
        return paramModel.getName().equals("target") || paramModel.getName().equals("targetValue");
    }

    public static boolean isCoreCollectionBasedScopeOrRouter(ComponentAst componentAst) {
        ComponentIdentifier identifier = componentAst.getIdentifier();
        return identifier.equals(FOREACH_IDENTIFIER) || identifier.equals(PARALLEL_FOREACH_IDENTIFIER);
    }

    public static boolean isCollectionParameter(ParameterModel parameter) {
        return parameter.getName().equals("collection");
    }

    public static boolean isFlowRef(ComponentAst ast) {
        return ast.getIdentifier().equals(FLOW_REF_IDENTIFIER);
    }

    public static boolean isErrorHandler(ComponentAst ast) {
        return TypedComponentIdentifier.ComponentType.ERROR_HANDLER.equals((Object)ast.getComponentType());
    }

    public static Optional<String> retrieveFlowRefName(ComponentAst flowRef) {
        return CoreUtils.getReferencedTopLevelComponentName(flowRef, "General", "name");
    }

    public static Optional<String> retrieveReferencedErrorHandlerName(ComponentAst referentErrorHandler) {
        return CoreUtils.getReferencedTopLevelComponentName(referentErrorHandler, "General", "ref");
    }

    private static Optional<String> getReferencedTopLevelComponentName(ComponentAst referentComponent, String paramGroupName, String paramName) {
        ComponentParameterAst refParameter = referentComponent.getParameter(paramGroupName, paramName);
        if (refParameter != null && refParameter.getValue().getRight() instanceof String) {
            return Optional.of((String)refParameter.getValue().getRight());
        }
        return Optional.empty();
    }

    public static boolean isVoidOutput(ComponentAst componentAst) {
        if (CoreUtils.requiresVoidOverride(componentAst.getIdentifier())) {
            return true;
        }
        if (componentAst.getIdentifier().equals(SET_PAYLOAD_IDENTIFIER)) {
            return false;
        }
        return componentAst.getModel(HasOutputModel.class).map(m -> m.getOutput().getType()).filter(MetadataTypeUtils::isVoid).isPresent();
    }

    public static Optional<String> getTargetParameterValue(ComponentAst componentAst) {
        ComponentParameterAst parameter = componentAst.getParameter("Output", "target");
        if (parameter == null) {
            return Optional.empty();
        }
        Object value = parameter.getValue().getRight();
        return value instanceof String ? Optional.of((String)value) : Optional.empty();
    }

    public static Optional<String> getTargetValueParameterValue(ComponentAst componentAst) {
        ComponentParameterAst parameter = componentAst.getParameter("Output", "targetValue");
        return parameter == null || parameter.isDefaultValue() ? Optional.empty() : Optional.ofNullable((String)parameter.getValue().getLeft());
    }

    public static boolean requiresVoidOverride(ComponentIdentifier componentIdentifier) {
        return AggregatorsUtils.requiresVoidOverride(componentIdentifier);
    }

    public static boolean isOrBehavesLikeVoidOperationForBinding(ComponentAst componentAst, String binding) {
        if (binding.equals(PAYLOAD_BINDING) || binding.equals(ATTRIBUTES_BINDING)) {
            return CoreUtils.isVoidOutput(componentAst) || CoreUtils.getTargetParameterValue(componentAst).isPresent();
        }
        return componentAst.getIdentifier().equals(PARALLEL_FOREACH_IDENTIFIER);
    }

    private static boolean isResponseParameterOfSource(ComponentParameterAst parameterAst, ComponentAst componentAst, Function<SourceModel, Optional<SourceCallbackModel>> responseType) {
        return componentAst.getModel(SourceModel.class).flatMap(responseType).map(ParameterizedModel::getParameterGroupModels).map(groups -> groups.stream().anyMatch(gr -> gr.getName().equals(parameterAst.getGroupModel().getName()))).orElse(false);
    }

    public static boolean isErrorResponseParameterOfSource(ComponentParameterAst parameterAst, ComponentAst componentAst) {
        return CoreUtils.isResponseParameterOfSource(parameterAst, componentAst, SourceModel::getErrorCallback);
    }

    public static boolean isSuccessResponseParameterOfSource(ComponentParameterAst parameterAst, ComponentAst componentAst) {
        return CoreUtils.isResponseParameterOfSource(parameterAst, componentAst, SourceModel::getSuccessCallback);
    }

    private static List<LocationPart> errorHandlingParts(ComponentLocation componentLocation) {
        return componentLocation.getParts().stream().filter(part -> part.getPartIdentifier().map(TypedComponentIdentifier::getType).map(type -> type.equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER)).orElse(false)).collect(Collectors.toList());
    }

    public static boolean sameLevelOfErrorHandling(ComponentLocation c1, ComponentLocation c2) {
        List<LocationPart> err1 = CoreUtils.errorHandlingParts(c1);
        List<LocationPart> err2 = CoreUtils.errorHandlingParts(c2);
        return err1.equals(err2);
    }

    public static boolean isOperationWithinErrorHandler(ComponentLocation componentLocation) {
        return componentLocation.getParts().stream().anyMatch(part -> part.getPartIdentifier().map(identifier -> identifier.getType().equals((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER)).orElse(false));
    }

    public static boolean isCorePassThroughScope(ComponentLocation componentLocation) {
        ComponentIdentifier identifier = componentLocation.getComponentIdentifier().getIdentifier();
        return identifier.equals(CACHE_IDENTIFIER) || identifier.equals(TRY_IDENTIFIER) || identifier.equals(UNTIL_SUCCESSFUL_IDENTIFIER);
    }

    public static boolean isCorePassThroughRouter(ComponentLocation componentLocation) {
        ComponentIdentifier identifier = componentLocation.getComponentIdentifier().getIdentifier();
        return identifier.equals(CHOICE_IDENTIFIER) || identifier.equals(FIRST_SUCCESSFUL_IDENTIFIER) || identifier.equals(ROUND_ROBIN_IDENTIFIER);
    }

    static {
        SPECIAL_HANDLING.add(SET_VARIABLE_IDENTIFIER);
        SPECIAL_HANDLING.add(REMOVE_VARIABLE_IDENTIFIER);
        SPECIAL_HANDLING.add(SET_PAYLOAD_IDENTIFIER);
        SPECIAL_HANDLING.add(EE_TRANSFORM_IDENTIFIER);
        SPECIAL_HANDLING.add(LOGGER_IDENTIFIER);
        SPECIAL_HANDLING.add(FOREACH_IDENTIFIER);
        SPECIAL_HANDLING.add(MUNIT_SET_EVENT_IDENTIFIER);
    }
}

