/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import com.mulesoft.mule.framework.api.extension.config.ConfigurationHandler;
import com.mulesoft.mule.framework.api.tooling.MuleToolingFramework;
import com.mulesoft.mule.framework.api.tooling.type.override.TypeOverrideKey;
import com.mulesoft.mule.framework.api.tooling.type.resolution.TypeResolutionSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGPropagatedParameterTypeResolver;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGRouterMetadataContext;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGScopeMetadataContext;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGTypeResolutionPropagationContext;
import org.mule.framework.internal.tooling.type.propagation.cfg.CoreTransformersHandler;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationStatus;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.ExpressionUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.ExpressionsTypeResolver;
import org.mule.framework.internal.tooling.type.propagation.utils.ModelsUtils;
import org.mule.framework.internal.tooling.type.resolution.InternalTypeResolutionSession;
import org.mule.framework.internal.tooling.type.resolution.NullTypeResolutionPropagationContext;
import org.mule.framework.internal.tooling.type.resolution.TypeResolutionPropagationContext;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.cfg.api.BaseChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.module.extension.api.metadata.PropagatedParameterTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypePropagationCFGVisitor
extends BaseChainExecutionPathTreeVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypePropagationCFGVisitor.class);
    private static final String CONFIG_ATTRIBUTE_NAME = "config-ref";
    private static final MetadataType ANY_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).anyType().build();
    public static final MetadataType VOID_TYPE = new BaseTypeBuilder(MetadataFormat.JAVA).voidType().build();
    private final InternalMuleFramework framework;
    private final MuleToolingFramework toolingFramework;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final CoreTransformersHandler coreTransformersHandler;
    private final ComponentLocation propagationTarget;
    private final TypePropagationStatus status;
    private boolean skipSource = false;

    public TypePropagationCFGVisitor(InternalMuleFramework framework, ExpressionLanguageMetadataService expressionLanguageMetadataService, ComponentLocation propagationTarget, TypeOverridesRepository typeOverridesRepository) {
        this.framework = framework;
        this.toolingFramework = framework.getToolingFramework();
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.coreTransformersHandler = new CoreTransformersHandler(expressionLanguageMetadataService);
        this.propagationTarget = propagationTarget;
        this.status = new TypePropagationStatus(typeOverridesRepository, expressionLanguageMetadataService);
    }

    public void initialMessage(MessageMetadataType message, boolean forced) {
        this.skipSource = forced;
        this.status.setInitialMessage(message);
    }

    public void initialMessage(MessageMetadataType message) {
        this.initialMessage(message, true);
    }

    public void initialPayload(MetadataType payload, boolean forced) {
        this.skipSource = forced;
        this.status.setInitialPayload(payload);
    }

    public void initialAttributes(MetadataType attributesType, boolean forced) {
        this.skipSource = forced;
        this.status.setInitialAttributes(attributesType);
    }

    public void visitSource(ChainExecutionPathTree source) {
        if (this.skipSource) {
            return;
        }
        ComponentAst sourceAst = source.getComponentAst();
        Optional model = sourceAst.getModel(SourceModel.class);
        ComponentLocation sourceLocation = sourceAst.getLocation();
        if (!model.isPresent()) {
            this.status.saveOutputsFailure(sourceAst, MetadataFailure.Builder.newFailure().withMessage(String.format("Component at location %s has no SourceModel", sourceAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent());
            return;
        }
        MetadataResult<ComponentMetadataTypesDescriptor> result = this.resolveComponentTypes(sourceAst, NullTypeResolutionPropagationContext.getInstance());
        if (!result.isSuccess()) {
            this.status.saveOutputsFailure(sourceAst, result.getFailures());
            return;
        }
        SourceModel updatedModel = this.getAndUpdateTypedSourceModel(sourceLocation, (SourceModel)model.get(), (ComponentMetadataTypesDescriptor)result.get());
        this.status.saveOutputsMetadata(sourceAst, (HasOutputModel)updatedModel);
        this.status.setInitialMessage(updatedModel.getOutput().getType(), updatedModel.getOutputAttributes().getType());
        this.setModifiesMessage(sourceLocation);
        this.status.saveInputVariables(sourceAst);
        this.status.saveOutputVariables(sourceAst);
    }

    public void visitSimpleOperation(ChainExecutionPathTree operation) {
        ComponentAst componentAst = operation.getComponentAst();
        this.status.saveInputVariables(componentAst);
        if (CoreUtils.requiresSpecialHandling(componentAst.getIdentifier())) {
            this.resolveSpecialCases(operation);
        } else {
            this.visitAllOperations(operation, NullTypeResolutionPropagationContext.getInstance());
        }
        this.status.saveOutputVariables(componentAst);
    }

    public void visitReferencedOperation(ChainExecutionPathTree operation) {
        ComponentAst componentAst = operation.getComponentAst();
        this.status.saveInputsMetadata(componentAst);
        this.status.saveInputVariables(componentAst);
        this.status.getErrorBindingType().ifPresent(et -> this.status.saveErrorType(componentAst, (MetadataType)et));
    }

    public void finishReferencedOperation(ChainExecutionPathTree operation) {
        MetadataType output = this.targetValue(operation, this.status.getCurrentPayload(), this.status.getCurrentAttributes());
        Optional<String> targetVariable = CoreUtils.getTargetParameterValue(operation.getComponentAst());
        if (targetVariable.isPresent()) {
            ComponentLocation location = operation.getComponentAst().getLocation();
            this.status.setMessageTypes(this.status.getInputMetadata(location));
            this.status.setCurrentVariables(this.status.getInputVariables(location));
            this.status.addVariable(targetVariable.get(), output);
        }
        this.setOutputFromCurrentState(operation.getComponentAst());
        this.status.saveOutputVariables(operation.getComponentAst());
    }

    private boolean requiresPropagation(ComponentLocation container) {
        if (this.status.containsOutputMetadata(container)) {
            return false;
        }
        if (this.status.containsOutputMetadata(this.propagationTarget)) {
            return false;
        }
        if (this.isMinimizedPropagation()) {
            return this.propagationTarget.getLocation().startsWith(container.getLocation());
        }
        return true;
    }

    private boolean shouldPropagateThroughInnerChain(ChainExecutionPathTree chainTree) {
        if (this.requiresPropagation(chainTree.getComponentAst().getLocation())) {
            return true;
        }
        return chainTree.children().stream().anyMatch(this::shouldPropagateThroughInnerChain);
    }

    private PropagatedParameterTypeResolver getPropagatedParameterTypeResolver(ComponentAst componentAst) {
        return new CFGPropagatedParameterTypeResolver(this.expressionLanguageMetadataService, this.getCurrentBindings(), componentAst);
    }

    public boolean visitScope(ChainExecutionPathTree scope) {
        MetadataType defaultOutput = this.status.getCurrentPayload();
        MetadataType defaultOutputAttr = this.status.getCurrentAttributes();
        this.variablesPreComposable(scope);
        LOGGER.debug("Progagating through scope chain '{}'...", (Object)scope.getComponentAst());
        this.status.enterChain();
        if (this.messagePreVisitChain(scope)) {
            CFGScopeMetadataContext scopeMetadataContext = new CFGScopeMetadataContext(this.getPropagatorForScope(scope), this.status.getCurrentPayload(), this.status.getCurrentAttributes());
            this.visitAllOperations(scope, new CFGTypeResolutionPropagationContext(this.getPropagatedParameterTypeResolver(scope.getComponentAst()), scopeMetadataContext), () -> defaultOutput, () -> defaultOutputAttr);
        }
        if (this.shouldPropagateThroughInnerChain(scope)) {
            this.status.markAsManuallyTraversed(scope.getComponentAst().getLocation());
            this.status.revertCurrentState();
            return true;
        }
        return false;
    }

    private Function<MessageMetadataType, MessageMetadataType> getPropagatorForScope(ChainExecutionPathTree scope) {
        return chainInputMetadataType -> {
            ChainExecutionPathTree scopeChain = (ChainExecutionPathTree)scope.children().get(0);
            this.status.saveCurrentState();
            try {
                chainInputMetadataType.getPayloadType().ifPresent(this.status::setPayload);
                chainInputMetadataType.getAttributesType().ifPresent(this.status::setAttributes);
                scopeChain.accept((ChainExecutionPathTreeVisitor)this);
                MessageMetadataType messageMetadataType = MessageMetadataType.builder().payload(this.getLastMetadataType()).attributes(this.getLastAttributesType()).build();
                return messageMetadataType;
            }
            finally {
                this.innerChainFinished(scopeChain);
            }
        };
    }

    public void scopeFinished(ChainExecutionPathTree scope) {
        ComponentLocation scopeLocation = scope.getComponentAst().getLocation();
        if (this.status.isManuallyTraversed(scopeLocation)) {
            this.status.saveCurrentState();
            this.innerChainFinished((ChainExecutionPathTree)scope.children().get(0));
        }
        this.variablesPostComposable(scope);
    }

    public boolean visitRouter(ChainExecutionPathTree router) {
        CFGRouterMetadataContext routerMetadataContext = new CFGRouterMetadataContext(this.getPropagatorsForRouter(router), this.status.getCurrentPayload(), this.status.getCurrentAttributes());
        this.variablesPreComposable(router);
        this.visitAllOperations(router, new CFGTypeResolutionPropagationContext(this.getPropagatedParameterTypeResolver(router.getComponentAst()), routerMetadataContext));
        return this.shouldPropagateThroughInnerChain(router);
    }

    private List<CFGRouterMetadataContext.RoutePropagator> getPropagatorsForRouter(ChainExecutionPathTree router) {
        ArrayList<CFGRouterMetadataContext.RoutePropagator> propagators = new ArrayList<CFGRouterMetadataContext.RoutePropagator>();
        for (ChainExecutionPathTree route : router.children()) {
            this.getRoutePropagator(route).ifPresent(propagators::add);
        }
        return propagators;
    }

    private Optional<CFGRouterMetadataContext.RoutePropagator> getRoutePropagator(ChainExecutionPathTree route) {
        return TypePropagationCFGVisitor.getRouteName(route).map(routeName -> new CFGRouterMetadataContext.RoutePropagator(TypePropagationCFGVisitor.getRouteId(route), (String)routeName, this.getRoutePropagationFunction(route)));
    }

    private static String getRouteId(ChainExecutionPathTree route) {
        LocationPart part;
        boolean routesOnlyByIndex = route.getOwnerModel().map(ownerModel -> ownerModel.getNestedComponents().stream()).orElse(Stream.empty()).filter(routeModel -> route.getComponentAst().getModel(NestedRouteModel.class).map(routeModel::equals).orElse(false)).flatMap(routeModel -> routeModel.getNestedComponents().stream()).anyMatch(chainModel -> chainModel.getModelProperty(NoWrapperModelProperty.class).isPresent());
        List parts = route.getComponentAst().getLocation().getParts();
        LinkedList<LocationPart> routeParts = new LinkedList<LocationPart>();
        for (int i = parts.size() - 1; i >= 0 && !"route".equals((part = (LocationPart)parts.get(i)).getPartPath()); --i) {
            routeParts.addFirst(part);
        }
        String routeName = ((LocationPart)routeParts.getLast()).getPartIdentifier().map(pId -> pId.getIdentifier().getName()).orElse(((LocationPart)routeParts.getLast()).getPartPath());
        if (routeParts.size() > 1) {
            return routeName + "[" + ((LocationPart)routeParts.getLast()).getPartPath() + "]";
        }
        return routesOnlyByIndex ? ((LocationPart)routeParts.getLast()).getPartPath() : routeName;
    }

    private static Optional<String> getRouteName(ChainExecutionPathTree route) {
        return route.getComponentAst().getModel(NestedRouteModel.class).map(NamedObject::getName);
    }

    private Function<MessageMetadataType, MessageMetadataType> getRoutePropagationFunction(ChainExecutionPathTree route) {
        return routeInputMetadataType -> {
            this.status.saveChainInputsMetadata(route.getComponentAst(), (MessageMetadataType)routeInputMetadataType);
            this.status.saveCurrentState();
            try {
                Pair<MetadataType, MetadataType> routeResult;
                if (this.innerRouteStarted(route)) {
                    route.accept((ChainExecutionPathTreeVisitor)this);
                    this.innerRouteFinished(route);
                }
                if ((routeResult = this.getChainResult(route)) == null) {
                    MessageMetadataType messageMetadataType = null;
                    return messageMetadataType;
                }
                MessageMetadataType messageMetadataType = MessageMetadataType.builder().payload((MetadataType)routeResult.getFirst()).attributes((MetadataType)routeResult.getSecond()).build();
                return messageMetadataType;
            }
            finally {
                this.status.revertCurrentState();
            }
        };
    }

    public boolean innerRouteStarted(ChainExecutionPathTree innerChain) {
        if (this.shouldPropagateThroughInnerChain(innerChain)) {
            this.status.saveCurrentState();
            ComponentAst routeAst = innerChain.getComponentAst();
            this.status.saveChainInputVariables(routeAst);
            LOGGER.debug("Progagating through router chain '{}'...", (Object)innerChain.getComponentAst());
            this.status.enterChain();
            MessageMetadataType routeInputMetadataType = this.status.getChainInputs(routeAst.getLocation());
            if (routeInputMetadataType != null) {
                routeInputMetadataType.getPayloadType().ifPresent(this.status::setPayload);
                routeInputMetadataType.getAttributesType().ifPresent(this.status::setAttributes);
            }
            return true;
        }
        return false;
    }

    public void innerRouteFinished(ChainExecutionPathTree innerChain) {
        this.status.clearOutputsFor(innerChain.getComponentAst());
        this.innerChainFinished(innerChain);
    }

    public Pair<MetadataType, MetadataType> getChainResult(ChainExecutionPathTree chain) {
        return this.status.getChainOutputs(chain.getComponentAst().getLocation());
    }

    public void routerFinished(ChainExecutionPathTree router) {
        this.variablesPostComposable(router);
    }

    public void errorHandlerCouldBeInvoked(ChainExecutionPathTree errorHandler, ErrorType errorType) {
        this.status.errorHandlerMayBeInvokedWith(errorHandler.getComponentAst().getLocation(), this.status.getFullMessageType(), this.status.getCurrentVariables());
    }

    public boolean errorHandlerStarted(ChainExecutionPathTree handler) {
        ComponentLocation location = handler.getComponentAst().getLocation();
        this.status.setModifiesBinding(location, "error");
        this.status.saveCurrentState();
        this.status.setMessageTypes(this.status.getInputMessageTypeForErrorHandler(location));
        this.status.saveCurrentVariables();
        this.status.setCurrentVariables(this.status.getVariableTypesForErrorHandler(location));
        this.status.enableErrorBinding();
        return true;
    }

    public void errorHandlerPropagationComplete(ChainExecutionPathTree handler) {
        this.status.goBackToPreviousVariables();
        this.status.revertCurrentState();
        this.status.removeErrorBinding();
    }

    public void chainInterruptedWithError(ChainExecutionPathTree chain) {
        this.status.addInterruptedChain(chain.getComponentAst());
    }

    private Optional<ConfigurationHandler> getConfigurationHandler(ComponentParameterization<?> params) {
        Object configRefValue = params.getParameter("General", CONFIG_ATTRIBUTE_NAME);
        try {
            return configRefValue instanceof String ? this.framework.getConfigurationHandler((String)configRefValue) : Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public MetadataResult<MessageMetadataType> getResult(ComponentLocation location) {
        Pair<MetadataType, MetadataType> chainOutput;
        MetadataResult<HasOutputModel> result = this.status.getOutputMetadata(location);
        if (result == null && (chainOutput = this.status.getChainOutputs(location)) != null) {
            return MetadataResult.success((Object)MessageMetadataType.builder().payload((MetadataType)chainOutput.getFirst()).attributes((MetadataType)chainOutput.getSecond()).build());
        }
        return result != null ? this.mapMetadataResult(result, this::toMessageMetadataType) : null;
    }

    private <I, O> MetadataResult<O> mapMetadataResult(MetadataResult<I> metadataResult, Function<I, O> mapFunction) {
        return metadataResult.isSuccess() ? MetadataResult.success(mapFunction.apply(metadataResult.get())) : MetadataResult.failure(mapFunction.apply(metadataResult.get()), (List)metadataResult.getFailures());
    }

    private MessageMetadataType toMessageMetadataType(HasOutputModel model) {
        return model == null ? null : MessageMetadataType.builder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build();
    }

    public MetadataType getLastMetadataType() {
        return this.status.getCurrentPayload();
    }

    public MetadataType getLastAttributesType() {
        return this.status.getCurrentAttributes();
    }

    public Map<String, MetadataType> getLastVariables() {
        return this.status.getCurrentVariables();
    }

    public Optional<MessageMetadataType> getInput(ComponentLocation location) {
        MessageMetadataType input = this.status.getInputMetadata(location);
        return input != null ? Optional.of(input) : Optional.ofNullable(this.status.getChainInputs(location));
    }

    public Map<String, MetadataType> getInputVariables(ComponentLocation location) {
        return Optional.ofNullable(this.status.getInputVariablesNoDefault(location)).orElseGet(() -> Optional.ofNullable(this.status.getChainInputVariables(location)).orElseGet(Collections::emptyMap));
    }

    public Map<String, MetadataType> getOutputVariables(ComponentLocation location) {
        return Optional.ofNullable(this.status.getOutputVariables(location)).orElseGet(() -> Optional.ofNullable(this.status.getChainOutputVariables(location)).orElseGet(Collections::emptyMap));
    }

    public Optional<MetadataType> getErrorType(ComponentLocation location) {
        return this.status.getErrorType(location);
    }

    private void visitAllOperations(ChainExecutionPathTree operation, TypeResolutionPropagationContext resolutionContext) {
        this.visitAllOperations(operation, resolutionContext, this.status::getCurrentPayload, this.status::getCurrentAttributes);
    }

    private void visitAllOperations(ChainExecutionPathTree operation, TypeResolutionPropagationContext resolutionContext, Supplier<MetadataType> defaultOutput, Supplier<MetadataType> defaultOutputAttributes) {
        ComponentAst operationAst = operation.getComponentAst();
        ComponentLocation location = operationAst.getLocation();
        Optional model = operationAst.getModel(OperationModel.class);
        this.status.saveInputsMetadata(operationAst);
        this.status.getErrorBindingType().ifPresent(et -> this.status.saveErrorType(operationAst, (MetadataType)et));
        if (!model.isPresent()) {
            if (operationAst.getComponentType() == TypedComponentIdentifier.ComponentType.SCOPE || operationAst.getComponentType() == TypedComponentIdentifier.ComponentType.ROUTER) {
                this.setSpecialCasesOutputs(operationAst, ANY_TYPE, null);
            } else {
                this.status.saveOutputsFailure(operationAst, MetadataFailure.Builder.newFailure().withMessage(String.format("Component in %s has no OperationModel", location.getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent());
            }
            return;
        }
        MetadataResult<ComponentMetadataTypesDescriptor> resolutionResult = this.resolveComponentTypes(operationAst, resolutionContext);
        if (!resolutionResult.isSuccess()) {
            this.status.saveOutputsFailure(operationAst, resolutionResult.getFailures());
            return;
        }
        OperationModel updatedModel = this.getAndUpdateTypedOperationModel(location, (OperationModel)model.get(), (ComponentMetadataTypesDescriptor)resolutionResult.get());
        Predicate<MetadataType> isNonVoid = this.getNonVoidFilter(operationAst.getIdentifier());
        MetadataType output = ((ComponentMetadataTypesDescriptor)resolutionResult.get()).getOutputMetadata().filter(isNonVoid).orElseGet(defaultOutput);
        MetadataType outputAttr = ((ComponentMetadataTypesDescriptor)resolutionResult.get()).getOutputAttributesMetadata().filter(isNonVoid).orElseGet(defaultOutputAttributes);
        output = this.targetValue(operation, output, outputAttr);
        resolutionContext.getScopeChainInputMessageType().ifPresent(chainMetadata -> this.handleScopeInputChainMetadata(operation, (MessageMetadataType)chainMetadata));
        resolutionContext.getRouteInputMessageTypes().ifPresent(routesMetadata -> this.handleRouteInputChainMetadata(operation, (Map<String, MessageMetadataType>)routesMetadata));
        if (output != null) {
            MetadataType actualOutput = CoreUtils.getTargetParameterValue(operation.getComponentAst()).isPresent() ? defaultOutput.get() : output;
            this.status.saveOutputsMetadata(operationAst, ModelsUtils.getOverriddenHasOutputModel((HasOutputModel)updatedModel, Optional.of(actualOutput), Optional.of(outputAttr)));
        }
        this.setOutputToCorrectVariable(operation, output);
        this.status.setAttributes(outputAttr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentTypes(ComponentAst componentAst, TypeResolutionPropagationContext resolutionContext) {
        Optional model = componentAst.getModel(ComponentModel.class);
        if (!model.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("ComponentModel not available").onComponent()});
        }
        ComponentParameterization parameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)componentAst);
        try (TypeResolutionSession resolutionSession = this.toolingFramework.createTypeResolutionSession(componentAst.getExtensionModel(), (ComponentModel)model.get());){
            MetadataResult<ComponentMetadataTypesDescriptor> resultWithoutConfigHandler;
            InternalTypeResolutionSession internalResolutionSession = (InternalTypeResolutionSession)resolutionSession;
            Optional<ConfigurationHandler> handler = this.getConfigurationHandler(parameterization);
            TypeOverrideKey typeOverrideKey = resolutionSession.createTypeOverrideKey(componentAst);
            MetadataResult<ComponentMetadataTypesDescriptor> result = internalResolutionSession.resolveComponentTypes(parameterization, handler, resolutionContext, typeOverrideKey);
            if (!result.isSuccess() && handler.isPresent() && (resultWithoutConfigHandler = internalResolutionSession.resolveComponentTypes(parameterization, Optional.empty(), resolutionContext, typeOverrideKey)).isSuccess()) {
                MetadataResult<ComponentMetadataTypesDescriptor> metadataResult2 = resultWithoutConfigHandler;
                return metadataResult2;
            }
            MetadataResult<ComponentMetadataTypesDescriptor> metadataResult = result;
            return metadataResult;
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    private OperationModel getAndUpdateTypedOperationModel(ComponentLocation location, OperationModel operationModel, ComponentMetadataTypesDescriptor componentMetadataTypesDescriptor) {
        OperationModel typedOperationModel = ModelsUtils.getTypedOperationModel(operationModel, componentMetadataTypesDescriptor.getInputMetadata(), componentMetadataTypesDescriptor.getOutputMetadata(), componentMetadataTypesDescriptor.getOutputAttributesMetadata());
        this.status.saveUpdatedModel(location, (ConnectableComponentModel)typedOperationModel);
        return typedOperationModel;
    }

    private SourceModel getAndUpdateTypedSourceModel(ComponentLocation location, SourceModel sourceModel, ComponentMetadataTypesDescriptor componentMetadataTypesDescriptor) {
        SourceModel typedSourceModel = ModelsUtils.getTypedSourceModel(sourceModel, componentMetadataTypesDescriptor.getInputMetadata(), componentMetadataTypesDescriptor.getOutputMetadata(), componentMetadataTypesDescriptor.getOutputAttributesMetadata());
        this.status.saveUpdatedModel(location, (ConnectableComponentModel)typedSourceModel);
        return typedSourceModel;
    }

    private void handleScopeInputChainMetadata(ChainExecutionPathTree scope, MessageMetadataType inputChainMetadata) {
        inputChainMetadata.getPayloadType().ifPresent(this.status::setPayload);
        inputChainMetadata.getAttributesType().ifPresent(this.status::setAttributes);
        this.status.saveCurrentState();
        scope.children().stream().findFirst().ifPresent(innerChain -> this.status.saveChainInputsMetadata(innerChain.getComponentAst(), inputChainMetadata));
    }

    private void handleRouteInputChainMetadata(ChainExecutionPathTree router, Map<String, MessageMetadataType> inputChainMetadata) {
        for (ChainExecutionPathTree route : router.children()) {
            TypePropagationCFGVisitor.getRouteName(route).map(inputChainMetadata::get).ifPresent(routeInput -> this.status.saveChainInputsMetadata(route.getComponentAst(), (MessageMetadataType)routeInput));
        }
    }

    private MetadataType targetValue(ChainExecutionPathTree operation, MetadataType originalOutput, MetadataType attributes) {
        Optional<String> targetValueExpression = CoreUtils.getTargetValueParameterValue(operation.getComponentAst());
        if (!targetValueExpression.isPresent()) {
            return originalOutput;
        }
        TypeBindings bindings = ExpressionUtils.getBindings(originalOutput, attributes, this.status.getCurrentVariables(), this.status.getErrorBindingType());
        ExpressionsTypeResolver expressionsTypeResolver = new ExpressionsTypeResolver(this.expressionLanguageMetadataService, bindings);
        MetadataType output = expressionsTypeResolver.getOutputType(targetValueExpression.get());
        Optional<MetadataFailure> failure = expressionsTypeResolver.getFailure();
        if (failure.isPresent()) {
            this.onFailure(operation.getComponentAst()).accept(failure.get());
            return null;
        }
        return output;
    }

    private void setOutputToCorrectVariable(ChainExecutionPathTree operation, MetadataType output) {
        if (output == null) {
            return;
        }
        Optional<String> targetVariable = CoreUtils.getTargetParameterValue(operation.getComponentAst());
        ComponentLocation operationLocation = operation.getComponentAst().getLocation();
        if (targetVariable.isPresent()) {
            this.status.addVariable(targetVariable.get(), output);
            this.status.setModifiesBinding(operationLocation, targetVariable.get());
            if (!operation.getComponentAst().directChildren().isEmpty()) {
                this.setModifiesPayload(operationLocation);
            }
        } else {
            this.status.setPayload(output);
            this.setModifiesPayload(operationLocation);
        }
    }

    private void resolveSpecialCases(ChainExecutionPathTree operation) {
        this.status.saveInputsMetadata(operation.getComponentAst());
        this.status.getErrorBindingType().ifPresent(et -> this.status.saveErrorType(operation.getComponentAst(), (MetadataType)et));
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        ComponentLocation location = operation.getComponentAst().getLocation();
        if (identifier.equals(CoreUtils.LOGGER_IDENTIFIER)) {
            this.setOutputFromCurrentState(operation.getComponentAst());
        } else {
            this.coreTransformersHandler.handle(operation.getComponentAst(), this.getCurrentBindings(), this.onPayloadTypeSet(location), this.onAttributesTypeSet(location), this.onVariableTypeSet(location), this.status::removeVariable, () -> this.setOutputFromCurrentState(operation.getComponentAst()), this.onFailure(operation.getComponentAst()));
        }
    }

    private Consumer<MetadataType> onPayloadTypeSet(ComponentLocation location) {
        return type -> {
            this.status.setPayload((MetadataType)type);
            this.setModifiesPayload(location);
        };
    }

    private Consumer<MetadataType> onAttributesTypeSet(ComponentLocation location) {
        return type -> {
            this.status.setAttributes((MetadataType)type);
            this.setModifiesAttributes(location);
        };
    }

    private BiConsumer<String, MetadataType> onVariableTypeSet(ComponentLocation location) {
        return (varName, varType) -> {
            this.status.addVariable((String)varName, (MetadataType)varType);
            this.status.setModifiesBinding(location, (String)varName);
        };
    }

    private void setOutputFromCurrentState(ComponentAst componentAst) {
        this.setSpecialCasesOutputs(componentAst, this.status.getCurrentPayload(), this.status.getCurrentAttributes());
    }

    private Consumer<MetadataFailure> onFailure(ComponentAst component) {
        return failure -> this.status.saveOutputsFailure(component, (MetadataFailure)failure);
    }

    private void setSpecialCasesOutputs(ComponentAst operationAst, MetadataType payloadType, MetadataType attributesType) {
        OperationModel specialCaseModel = (OperationModel)operationAst.getModel(OperationModel.class).get();
        ComponentLocation location = operationAst.getLocation();
        MetadataResult<ComponentMetadataTypesDescriptor> result = this.resolveComponentTypes(operationAst, NullTypeResolutionPropagationContext.getInstance());
        if (!result.isSuccess()) {
            this.status.saveOutputsFailure(operationAst, result.getFailures());
            return;
        }
        OperationModel updatedModel = this.getAndUpdateTypedOperationModel(location, specialCaseModel, (ComponentMetadataTypesDescriptor)result.get());
        this.status.saveOutputsMetadata(operationAst, ModelsUtils.getOverriddenHasOutputModel((HasOutputModel)updatedModel, Optional.ofNullable(payloadType), Optional.ofNullable(attributesType)));
    }

    private TypeBindings getCurrentBindings() {
        return ExpressionUtils.getBindings(this.status.getCurrentPayload(), this.status.getCurrentAttributes(), this.status.getCurrentVariables(), this.status.getErrorBindingType());
    }

    private void variablesPreComposable(ChainExecutionPathTree operation) {
        ComponentAst componentAst = operation.getComponentAst();
        ComponentIdentifier identifier = componentAst.getIdentifier();
        this.status.saveInputVariables(componentAst);
        if (identifier.equals(CoreUtils.FOREACH_IDENTIFIER)) {
            HashMap<String, MetadataType> addedVariables = new HashMap<String, MetadataType>();
            addedVariables.put(componentAst.getParameter("General", "counterVariableName").getValue().getRight().toString(), (MetadataType)new BaseTypeBuilder(MetadataFormat.JAVA).numberType().build());
            addedVariables.put(componentAst.getParameter("General", "rootMessageVariableName").getValue().getRight().toString(), (MetadataType)this.status.getFullMessageType());
            this.status.addVariablesPreComposable(addedVariables);
        }
    }

    private void variablesPostComposable(ChainExecutionPathTree operation) {
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (this.isVariablesPassThrough(operation) && !CoreUtils.getTargetParameterValue(operation.getComponentAst()).isPresent()) {
            this.combineVariablesFromChains(identifier, this.getChainVariables(operation));
        }
        if (identifier.equals(CoreUtils.FOREACH_IDENTIFIER)) {
            this.status.removeVariable(operation.getComponentAst().getParameter("General", "counterVariableName").getValue().getRight().toString());
            this.status.removeVariable(operation.getComponentAst().getParameter("General", "rootMessageVariableName").getValue().getRight().toString());
        }
        this.status.saveOutputVariables(operation.getComponentAst());
    }

    private void combineVariablesFromChains(ComponentIdentifier identifier, List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables) {
        if (CoreUtils.SCATTER_GATHER_IDENTIFIER.equals(identifier)) {
            this.status.combineVariables(chainsVariables, this::combineScatterGather);
        } else if (CoreUtils.CACHE_IDENTIFIER.equals(identifier)) {
            this.status.combineVariables(this.withOverriddenExecutionOccurrence(chainsVariables, ChainExecutionOccurrence.ONCE));
        } else {
            this.status.combineVariables(chainsVariables);
        }
    }

    private List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> withOverriddenExecutionOccurrence(List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainsVariables, ChainExecutionOccurrence executionOccurrenceOverride) {
        return chainsVariables.stream().map(pair -> new Pair((Object)((Map)pair.getFirst()), (Object)executionOccurrenceOverride)).collect(Collectors.toList());
    }

    private MetadataType combineScatterGather(MetadataType prevType, MetadataType curType) {
        if (prevType.equals(curType)) {
            return new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(curType).build();
        }
        if (prevType instanceof ArrayType) {
            ArrayType arrType = (ArrayType)prevType;
            if (!arrType.getType().equals(curType)) {
                return new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(ANY_TYPE).build();
            }
        } else {
            return new BaseTypeBuilder(MetadataFormat.JAVA).arrayType().of(ANY_TYPE).build();
        }
        return null;
    }

    private List<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> getChainVariables(ChainExecutionPathTree composable) {
        ArrayList<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>> chainVariables = new ArrayList<Pair<Map<String, MetadataType>, ChainExecutionOccurrence>>();
        List children = composable.children();
        for (ChainExecutionPathTree child : children) {
            ComponentAst chainComponent = child.getComponentAst();
            ChainExecutionOccurrence chainExecutionOccurrence = chainComponent.getModel(ComposableModel.class).map(cm -> ((NestedChainModel)cm.getNestedComponents().get(0)).getChainExecutionOccurrence()).orElse(ChainExecutionOccurrence.UNKNOWN);
            Map<String, MetadataType> vars = this.status.getChainOutputVariables(chainComponent.getLocation());
            if (vars == null) continue;
            chainVariables.add((Pair<Map<String, MetadataType>, ChainExecutionOccurrence>)new Pair(vars, (Object)chainExecutionOccurrence));
        }
        return chainVariables;
    }

    private boolean isVariablesPassThrough(ChainExecutionPathTree operation) {
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (CoreUtils.belongsToMule(identifier)) {
            return !CoreUtils.ASYNC_IDENTIFIER.equals(identifier) && !CoreUtils.PARALLEL_FOREACH_IDENTIFIER.equals(identifier) && !"batch".equals(identifier.getNamespace());
        }
        return !CoreUtils.isVoidOutput(operation.getComponentAst());
    }

    private Predicate<MetadataType> getNonVoidFilter(ComponentIdentifier componentIdentifier) {
        return CoreUtils.requiresVoidOverride(componentIdentifier) ? type -> false : type -> !MetadataTypeUtils.isVoid((MetadataType)type);
    }

    private boolean messagePreVisitChain(ChainExecutionPathTree operation) {
        this.status.saveCurrentState();
        return this.batchSpecialHandling(operation);
    }

    private boolean batchSpecialHandling(ChainExecutionPathTree operation) {
        ComponentIdentifier identifier = operation.getComponentAst().getIdentifier();
        if (identifier.equals(CoreUtils.BATCH_JOB_IDENTIFIER)) {
            MetadataType innerType = this.resolveCollectionType("payload", operation.getComponentAst());
            if (innerType == null) {
                return false;
            }
            this.status.setPayload(innerType);
            this.status.setAttributes(VOID_TYPE);
            this.status.saveCurrentState();
        } else if (identifier.equals(CoreUtils.BATCH_ON_COMPLETE_IDENTIFIER)) {
            this.status.setPayload(CoreUtils.batchResultInput());
            this.status.saveCurrentState();
            return false;
        }
        return true;
    }

    private MetadataType resolveCollectionType(String expression, ComponentAst operationAst) {
        ExpressionsTypeResolver expressionsTypeResolver = new ExpressionsTypeResolver(this.expressionLanguageMetadataService, this.getCurrentBindings());
        MetadataType arrayType = expressionsTypeResolver.getOutputType(expression);
        if (!expressionsTypeResolver.getFailure().isPresent() && arrayType instanceof ArrayType) {
            return ((ArrayType)arrayType).getType();
        }
        this.status.saveOutputsFailure(operationAst, MetadataFailure.Builder.newFailure().withMessage(String.format("Collection Expression (%s) at location %s does not resolve to a collection", expression, operationAst.getLocation().getLocation())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent());
        return null;
    }

    private void innerChainFinished(ChainExecutionPathTree innerChain) {
        MetadataResult<HasOutputModel> output;
        ComponentAst chainAst = innerChain.getComponentAst();
        ComponentLocation chainLocation = chainAst.getLocation();
        if (!this.status.isInterruptedChain(chainLocation)) {
            this.status.saveChainOutputsMetadata(chainAst);
            this.status.saveChainOutputVariables(chainAst);
        }
        if ((output = this.status.getOutputMetadata(chainLocation)) != null && output.isSuccess()) {
            this.status.setPayload(((HasOutputModel)output.get()).getOutput().getType());
            this.status.setAttributes(((HasOutputModel)output.get()).getOutputAttributes().getType());
        } else {
            this.status.revertCurrentState();
        }
        LOGGER.debug("Progagation through router chain '{}' complete", (Object)innerChain.getComponentAst());
        this.status.exitChain();
    }

    private void setModifiesMessage(ComponentLocation location) {
        this.setModifiesPayload(location);
        this.setModifiesAttributes(location);
    }

    private void setModifiesPayload(ComponentLocation location) {
        this.status.setModifiesBinding(location, "payload");
    }

    private void setModifiesAttributes(ComponentLocation location) {
        this.status.setModifiesBinding(location, "attributes");
    }

    public boolean modifiesBinding(ComponentLocation location, String binding) {
        return this.status.modifiesBinding(location, binding);
    }

    Map<ComponentLocation, ConnectableComponentModel> getUpdatedModels() {
        return this.status.getUpdatedModels();
    }

    public boolean wasSuccessfulPropagation() {
        return this.status.wasSuccessfulPropagation();
    }

    private boolean isMinimizedPropagation() {
        return false;
    }

    public Set<ComponentLocation> getInterruptedChains() {
        return this.status.getInterruptedChains();
    }
}

