/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.util.LazyValue;

public class CFGRouterMetadataContext
implements RouterOutputMetadataContext {
    private final List<RoutePropagator> propagators;
    private final MetadataType input;
    private final MetadataType inputAttributes;
    private Map<String, MessageMetadataType> innerChainInputs;

    public CFGRouterMetadataContext(List<RoutePropagator> propagators, MetadataType input, MetadataType inputAttributes) {
        this.propagators = propagators;
        this.input = input;
        this.inputAttributes = inputAttributes;
    }

    public Map<String, Supplier<MessageMetadataType>> getRouteOutputMessageTypes() {
        LinkedHashMap<String, Supplier<MessageMetadataType>> routeOutputMessageTypes = new LinkedHashMap<String, Supplier<MessageMetadataType>>();
        for (RoutePropagator routePropagator : this.propagators) {
            MessageMetadataType messageMetadataType = this.getRouteChainOutputMessageType(routePropagator);
            if (messageMetadataType == null) continue;
            routeOutputMessageTypes.put(routePropagator.getRouteId(), (Supplier<MessageMetadataType>)new LazyValue(() -> messageMetadataType));
        }
        return routeOutputMessageTypes;
    }

    public Supplier<MessageMetadataType> getRouterInputMessageType() {
        return () -> MessageMetadataType.builder().payload(this.input).attributes(this.inputAttributes).build();
    }

    public void setInnerChainInputs(Map<String, MessageMetadataType> innerChainInputs) {
        this.innerChainInputs = innerChainInputs;
    }

    public Map<String, MessageMetadataType> getInnerChainInputs() {
        return this.innerChainInputs;
    }

    private MessageMetadataType getRouteChainOutputMessageType(RoutePropagator routePropagator) {
        return routePropagator.getPropagator().apply(this.getRouteChainInputOrPassThrough(routePropagator.getRouteName()));
    }

    private MessageMetadataType getRouteChainInputOrPassThrough(String routeName) {
        if (this.innerChainInputs == null || !this.innerChainInputs.containsKey(routeName)) {
            throw new IllegalStateException(String.format("Chain input metadata not available for propagation through route `%s`", routeName));
        }
        return this.innerChainInputs.get(routeName);
    }

    public static class RoutePropagator {
        private final String routeId;
        private final String routeName;
        private final Function<MessageMetadataType, MessageMetadataType> propagator;

        public RoutePropagator(String routeId, String routeName, Function<MessageMetadataType, MessageMetadataType> propagator) {
            this.routeId = routeId;
            this.routeName = routeName;
            this.propagator = propagator;
        }

        public String getRouteId() {
            return this.routeId;
        }

        public String getRouteName() {
            return this.routeName;
        }

        public Function<MessageMetadataType, MessageMetadataType> getPropagator() {
            return this.propagator;
        }
    }
}

