/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation;

import com.mulesoft.mule.framework.api.tooling.type.propagation.TypedEventField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.util.Preconditions;

public class TypedEventFieldBuilder {
    private ComponentLocation declaration;
    private ComponentLocation lastSet;
    private final List<ComponentLocation> usages = new ArrayList<ComponentLocation>();
    private MetadataType metadataType;

    public TypedEventFieldBuilder withDeclarationIn(ComponentLocation location) {
        this.declaration = location;
        if (this.lastSet == null) {
            this.lastSet = location;
        }
        this.usages.add(location);
        return this;
    }

    public TypedEventFieldBuilder withUsage(ComponentLocation location) {
        this.usages.add(location);
        return this;
    }

    public TypedEventFieldBuilder withValueSetIn(ComponentLocation location) {
        this.lastSet = location;
        return this;
    }

    public TypedEventFieldBuilder withMetadataType(MetadataType type) {
        this.metadataType = type;
        return this;
    }

    public ComponentLocation getLastSet() {
        return this.lastSet;
    }

    public boolean isType(MetadataType type) {
        return this.metadataType.equals(type);
    }

    public TypedEventField build() {
        Preconditions.checkState((this.metadataType != null ? 1 : 0) != 0, (String)"There must be a metadata type defined");
        return new DefaultTypedEventField(this.declaration, this.lastSet, this.usages, this.metadataType);
    }

    private static class DefaultTypedEventField
    implements TypedEventField {
        private final Optional<ComponentLocation> declaration;
        private final Optional<ComponentLocation> lastSet;
        private final List<ComponentLocation> usages;
        private final MetadataType metadataType;

        public DefaultTypedEventField(ComponentLocation declaration, ComponentLocation lastSet, List<ComponentLocation> usages, MetadataType type) {
            this.declaration = Optional.ofNullable(declaration);
            this.lastSet = Optional.ofNullable(lastSet);
            this.usages = usages;
            this.metadataType = type;
        }

        public Optional<ComponentLocation> getDeclarationLocation() {
            return this.declaration;
        }

        public Optional<ComponentLocation> getLastValueDefinitionLocation() {
            return this.lastSet;
        }

        public List<ComponentLocation> getUsages() {
            return this.usages;
        }

        public MetadataType getType() {
            return this.metadataType;
        }
    }
}

