/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.framework.internal.tooling.type.override.enrichment.loader.TypeOverrideLoadingException;
import org.mule.framework.internal.tooling.type.override.enrichment.loader.TypeOverridesRepositoryLoaderContext;
import org.mule.framework.internal.tooling.type.override.enrichment.loader.xml.TypeOverridesRepositoryXmlLoader;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeOverridesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeOverridesHelper.class);

    private TypeOverridesHelper() {
    }

    public static TypeOverridesRepository loadTypeOverrides(String fileName, InternalMuleFramework internalMuleFramework, TypesCatalog typesCatalog) {
        try {
            return TypeOverridesHelper.loadTypeOverrides(fileName, internalMuleFramework.getExecutionClassLoader(), typesCatalog);
        }
        catch (Exception e) {
            LOGGER.error("Error while loading the type overrides", (Throwable)e);
            return new TypeOverridesRepository();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypeOverridesRepository loadTypeOverrides(String fileName, ClassLoader classLoader, TypesCatalog typesCatalog) throws TypeOverrideLoadingException {
        if (classLoader == null) {
            LOGGER.warn("Execution classloader is null while trying to load the type overrides");
            return new TypeOverridesRepository();
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(fileName);){
            if (inputStream == null) {
                TypeOverridesRepository typeOverridesRepository2 = new TypeOverridesRepository();
                return typeOverridesRepository2;
            }
            TypeOverridesRepositoryLoaderContext context = new TypeOverridesRepositoryLoaderContext(typesCatalog);
            TypeOverridesRepository typeOverridesRepository = new TypeOverridesRepositoryXmlLoader().loadFiles(Collections.singletonList(inputStream), context);
            return typeOverridesRepository;
        }
        catch (IOException e) {
            throw new TypeOverrideLoadingException("Error loading the type overrides repository", e);
        }
    }
}

