/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.model.resolver;

import java.util.Objects;
import java.util.Optional;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;
import org.mule.metadata.api.model.MetadataType;

public class SingleTypeResolver
implements TypeResolver {
    private final String typeIdentifier;
    private final TypeResolver delegate;

    public SingleTypeResolver(String typeIdentifier, TypeResolver delegate) {
        Objects.requireNonNull(typeIdentifier, "typeIdentifier");
        this.typeIdentifier = typeIdentifier;
        this.delegate = delegate;
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
        if (!this.typeIdentifier.equals(typeIdentifier)) {
            return Optional.empty();
        }
        return Optional.of(this.delegate.resolveType(typeIdentifier).orElseThrow(() -> new TypeResolverException("Failed to resolve type " + typeIdentifier)));
    }
}

