/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.mule.framework.internal.tooling.type.catalog.builder.TypesCatalogBuilderContext;
import org.mule.framework.internal.tooling.type.catalog.builder.TypesResolverBuilder;
import org.mule.framework.internal.tooling.type.catalog.loader.TypesCatalogLoadingException;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;

public class TypesCatalogBuilder {
    private final List<TypesResolverBuilder> typesResolverBuilders;
    private final TypesCatalogBuilderContext typesCatalogBuilderContext;
    private URI baseUri;

    public TypesCatalogBuilder(TypesCatalogBuilderContext typesCatalogBuilderContext) {
        this.typesCatalogBuilderContext = typesCatalogBuilderContext;
        this.typesResolverBuilders = new ArrayList<TypesResolverBuilder>();
    }

    public TypesCatalogBuilder baseUri(URI baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public TypesCatalogBuilder addTypesResolver(Consumer<TypesResolverBuilder> typesResolverBuilderConsumer) {
        TypesResolverBuilder typesResolverBuilder = new TypesResolverBuilder(this.baseUri);
        typesResolverBuilderConsumer.accept(typesResolverBuilder);
        this.typesResolverBuilders.add(typesResolverBuilder);
        return this;
    }

    public TypesCatalog build() throws TypesCatalogLoadingException {
        try {
            ArrayList<TypeResolver> resolvers = new ArrayList<TypeResolver>(this.typesResolverBuilders.size());
            for (TypesResolverBuilder resolverBuilder : this.typesResolverBuilders) {
                TypeResolver resolver = resolverBuilder.build(this.typesCatalogBuilderContext);
                if (resolver == null) continue;
                resolvers.add(resolver);
            }
            return new TypesCatalog(resolvers);
        }
        catch (TypeResolverException exception) {
            throw new TypesCatalogLoadingException(exception);
        }
    }
}

