/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling;

import com.mulesoft.mule.framework.api.tooling.MuleToolingFramework;
import com.mulesoft.mule.framework.api.tooling.icon.IconsResult;
import com.mulesoft.mule.framework.api.tooling.sample.data.SampleDataSession;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationSession;
import com.mulesoft.mule.framework.api.tooling.type.resolution.TypeResolutionSession;
import com.mulesoft.mule.framework.api.tooling.value.ValueProviderSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.framework.internal.tooling.connectivity.ConnectivityTestCommand;
import org.mule.framework.internal.tooling.icon.IconSession;
import org.mule.framework.internal.tooling.sample.data.DietSampleDataSession;
import org.mule.framework.internal.tooling.type.bindings.BindingsResolver;
import org.mule.framework.internal.tooling.type.catalog.TypesCatalogHelper;
import org.mule.framework.internal.tooling.type.catalog.model.TypesCatalog;
import org.mule.framework.internal.tooling.type.override.TypeOverridesHelper;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGTypePropagationSession;
import org.mule.framework.internal.tooling.type.resolution.DietTypeResolutionSession;
import org.mule.framework.internal.tooling.value.DietValueProviderSession;
import org.mule.framework.internal.util.CloseChecker;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;

public class DietToolingFramework
implements MuleToolingFramework {
    private final CloseChecker closer;
    private final InternalMuleFramework mule;
    private final ConnectivityTestCommand connectivityTestCommand = new ConnectivityTestCommand();
    private final Supplier<IconSession> iconSession;
    private final BindingsResolver bindingsResolver;
    private final TypesCatalog typesCatalog;
    private final TypeOverridesRepository typeOverridesRepository;

    public DietToolingFramework(InternalMuleFramework mule) {
        this.mule = mule;
        this.iconSession = new LazyValue(() -> new IconSession(((RegionClassLoader)mule.getExecutionClassLoader()).getArtifactDescriptor().getClassLoaderConfiguration().getDependencies()));
        this.bindingsResolver = new BindingsResolver(mule.getExtensionModels());
        this.closer = new CloseChecker("DietToolingFramework", mule);
        this.typesCatalog = TypesCatalogHelper.loadTypesCatalog("application-types.xml", mule);
        this.typeOverridesRepository = TypeOverridesHelper.loadTypeOverrides("application-types.xml", mule, this.typesCatalog);
    }

    public ConnectionValidationResult testConnectivity(ExtensionModel extensionModel, ComponentParameterization<ConnectionProviderModel> parameterization) {
        return this.closer.withLifecycleCheck(() -> (ConnectionValidationResult)ClassUtils.withContextClassLoader((ClassLoader)MuleFrameworkUtils.getClassLoader(extensionModel), () -> {
            try {
                return this.connectivityTestCommand.execute(extensionModel, parameterization, this.mule.getMuleContext(), this.mule.getExtensionDesignTimeResolversFactory());
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }));
    }

    public ConnectionValidationResult testConnectivity(String configName) {
        return this.closer.withLifecycleCheck(() -> {
            InternalConfigurationHandler configurationHandler = (InternalConfigurationHandler)this.mule.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
            if (!this.supportsTestConnectivity(configurationHandler)) {
                throw new UnsupportedOperationException(String.format("Connectivity testing is not supported on config '%s'", configName));
            }
            ConnectionProvider connectionProvider = (ConnectionProvider)configurationHandler.getConfigurationProvider().get((Event)CoreEvent.nullEvent()).getConnectionProvider().orElseThrow(() -> new IllegalArgumentException(String.format("No connection provider has been registered for config '%s'", configName)));
            return (ConnectionValidationResult)ClassUtils.withContextClassLoader((ClassLoader)MuleFrameworkUtils.getClassLoader(configurationHandler.getConfigurationProvider().getExtensionModel()), () -> {
                try {
                    return this.connectivityTestCommand.execute((ConnectionProvider<Object>)connectionProvider, this.mule.getMuleContext().getInjector());
                }
                catch (Exception e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
        });
    }

    private boolean supportsTestConnectivity(InternalConfigurationHandler configurationHandler) {
        return configurationHandler.getConfigurationProvider().getExtensionModel().getConnectionProviders().stream().anyMatch(ConnectionProviderModel::supportsConnectivityTesting) || configurationHandler.getConfigurationProvider().getConfigurationModel().getConnectionProviders().stream().anyMatch(ConnectionProviderModel::supportsConnectivityTesting);
    }

    public TypeResolutionSession createTypeResolutionSession(ExtensionModel extensionModel, ComponentModel componentModel) {
        return this.closer.withLifecycleCheck(() -> new DietTypeResolutionSession(this.mule, extensionModel, componentModel, this.mule.getExtensionDesignTimeResolversFactory(), this.typeOverridesRepository));
    }

    public TypePropagationSession createTypePropagationSession(ArtifactAst application) {
        return this.closer.withLifecycleCheck(() -> {
            List configsComponentAsts = application.topLevelComponentsStream().filter(potentialConfig -> potentialConfig.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).collect(Collectors.toList());
            this.mule.getConfigIdGenerator().addConfigurations(configsComponentAsts);
            return new CFGTypePropagationSession(this.mule, application, this.typeOverridesRepository);
        });
    }

    public TypePropagationSession createTypePropagationSession() {
        return this.closer.withLifecycleCheck(() -> this.createTypePropagationSession(this.getArtifactAst()));
    }

    public Map<String, MetadataType> getModuleBindings() {
        return this.closer.withLifecycleCheck(this.bindingsResolver::getModuleBindings);
    }

    public Map<String, MetadataType> getGlobalBindings() {
        return this.closer.withLifecycleCheck(this.bindingsResolver::getGlobalBindings);
    }

    private ArtifactAst getArtifactAst() {
        return this.closer.withLifecycleCheck(() -> (ArtifactAst)this.mule.getArtifactAst().orElseThrow(() -> new IllegalStateException("There is no artifact AST available")));
    }

    public ValueProviderSession createValueProviderSession(ExtensionModel extensionModel, ParameterizedModel parameterizedModel) {
        return this.closer.withLifecycleCheck(() -> new DietValueProviderSession(this.mule, extensionModel, parameterizedModel, this.mule.getExtensionDesignTimeResolversFactory()));
    }

    public SampleDataSession createSampleDataSession(ExtensionModel extensionModel) {
        return this.closer.withLifecycleCheck(() -> new DietSampleDataSession(this.mule, extensionModel));
    }

    public boolean evictFromMetadataStorage(String configName) {
        return this.closer.withLifecycleCheck(() -> {
            Optional<String> groupId = this.mule.getConfigIdGenerator().getConfigMetadataCacheId(configName, false).map(MetadataCacheId::getValue);
            return groupId.filter(s -> this.mule.getMetadataStorage().evictGroup(s)).isPresent();
        });
    }

    public IconsResult getIconsFor(ExtensionModel extensionModel) {
        return this.closer.withLifecycleCheck(() -> this.iconSession.get().getIconFor(extensionModel));
    }

    public void close() {
        this.closer.close();
    }
}

