/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.dsl.xml;

import com.mulesoft.mule.framework.api.dsl.xml.Schema;
import com.mulesoft.mule.framework.api.dsl.xml.XmlDslInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.mule.framework.internal.AbstractMuleFramework;
import org.mule.framework.internal.dsl.xml.DefaultSchema;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.privileged.spi.ExtensionsApiSpiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXmlDslInfo
implements XmlDslInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXmlDslInfo.class);
    private static final Set<String> MULE_SCHEMAS = new HashSet<String>(Arrays.asList("mule-core.xsd", "mule-core-common.xsd", "mule-operation.xsd", "mule-schemadoc.xsd", "mule-domain.xsd"));
    private static final Set<String> MULE_EE_SCHEMAS = new HashSet<String>(Arrays.asList("mule-ee.xsd", "mule-domain-ee.xsd"));
    private static final Set<String> DOMAIN_SCHEMAS = new HashSet<String>(Arrays.asList("mule-domain.xsd", "mule-domain-ee.xsd"));
    private static final Set<String> MULE_SDK_SCHEMAS = new HashSet<String>(Arrays.asList("mule-operation.xsd", "mule-extension.xsd"));
    public static final String CUSTOM_SCHEMA_MAPPINGS_LOCATION = "META-INF/mule.schemas";
    public static final String CORE_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule.xsd";
    public static final String CORE_CURRENT_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule-core.xsd";
    private static final Optional<ExtensionSchemaGenerator> SCHEMA_GENERATOR = ExtensionsApiSpiUtils.loadExtensionSchemaGenerators().findFirst();
    private static final LazyValue<Map<String, String>> MULE_SCHEMAS_MAPPINGS = new LazyValue(() -> DefaultXmlDslInfo.getSchemaMappings(DefaultXmlDslInfo.class.getClassLoader()));
    private static final LazyValue<Map<String, String>> coreSchemasContent = new LazyValue(DefaultXmlDslInfo::calculateCoreSchemas);
    private final AbstractMuleFramework muleFramework;
    private final DslResolvingContext dslResolvingContext;
    private final LazyValue<Map<String, Schema>> coreSchemas = new LazyValue(() -> ((Map)coreSchemasContent.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new DefaultSchema((String)entry.getKey(), (String)entry.getValue(), this.getSchemaExtension((String)entry.getKey())))));
    private final LazyValue<Map<ExtensionModel, Set<Schema>>> coreSchemasByExtensionModel = new LazyValue(() -> ((Map)this.coreSchemas.get()).values().stream().collect(Collectors.groupingBy(Schema::getExtensionModel, Collectors.toSet())));

    private static Map<String, String> calculateCoreSchemas() {
        HashMap result = new HashMap();
        ((Map)MULE_SCHEMAS_MAPPINGS.get()).forEach((id, path) -> {
            String schemaName = FilenameUtils.getName((String)DefaultXmlDslInfo.class.getClassLoader().getResource((String)path).getPath());
            result.put(schemaName, DefaultXmlDslInfo.loadSchema(path, DefaultXmlDslInfo.class.getClassLoader()));
        });
        if (!MuleFrameworkUtils.isMuleSdkEnabled()) {
            MULE_SDK_SCHEMAS.forEach(result::remove);
        }
        return Collections.unmodifiableMap(result);
    }

    public DefaultXmlDslInfo(AbstractMuleFramework muleFramework, DslResolvingContext dslResolvingContext) {
        this.muleFramework = muleFramework;
        this.dslResolvingContext = dslResolvingContext;
    }

    public Set<Schema> getCoreSchemas() {
        HashMap result = new HashMap((Map)this.coreSchemas.get());
        if (this.muleFramework.getFrameworkDeployableArtifact().getArtifactType().equals((Object)ArtifactType.APP)) {
            DOMAIN_SCHEMAS.forEach(result::remove);
        }
        return new HashSet<Schema>(result.values());
    }

    public Set<Schema> getExtensionSchema(ExtensionModel extensionModel) {
        HashSet<Schema> result = new HashSet<Schema>();
        if (((Map)this.coreSchemasByExtensionModel.get()).containsKey(extensionModel)) {
            result.addAll((Collection)((Map)this.coreSchemasByExtensionModel.get()).get(extensionModel));
        } else {
            result.add(new DefaultSchema(extensionModel.getXmlDslModel().getXsdFileName(), this.loadExtensionSchema(extensionModel), extensionModel));
        }
        result.addAll(this.getReferencedSchemas(extensionModel));
        result.addAll((Collection)((Map)this.coreSchemasByExtensionModel.get()).get(MuleFrameworkUtils.getExtensionModel(this.muleFramework, "mule")));
        return Collections.unmodifiableSet(result.stream().filter(schema -> {
            if (this.muleFramework.getFrameworkDeployableArtifact().getArtifactType().equals((Object)ArtifactType.APP)) {
                return DOMAIN_SCHEMAS.stream().noneMatch(schema.getFileName()::equals);
            }
            return true;
        }).collect(Collectors.toSet()));
    }

    private Set<Schema> getReferencedSchemas(ExtensionModel extensionModel) {
        return extensionModel.getImportedTypes().stream().map(type -> (String)ExtensionMetadataTypeUtils.getId((MetadataType)type.getImportedType()).get()).map(typeId -> this.dslResolvingContext.getExtensionForType(typeId)).filter(Optional::isPresent).map(Optional::get).flatMap(em -> this.getExtensionSchema((ExtensionModel)em).stream()).collect(Collectors.toSet());
    }

    private ExtensionModel getSchemaExtension(String schemaName) {
        if (MULE_SCHEMAS.stream().anyMatch(schemaName::equals)) {
            return MuleFrameworkUtils.getExtensionModel(this.muleFramework, "mule");
        }
        if (MULE_EE_SCHEMAS.stream().anyMatch(schemaName::equals)) {
            return MuleFrameworkUtils.getExtensionModel(this.muleFramework, "ee");
        }
        return this.muleFramework.getExtensionModels().stream().filter(em -> em.getXmlDslModel().getXsdFileName().equals(schemaName)).findFirst().orElseThrow(() -> new RuntimeException("No extension corresponding to schema '" + schemaName + "' found"));
    }

    private String loadExtensionSchema(ExtensionModel extensionModel) {
        String schemaLocation = DefaultXmlDslInfo.resolveSchemaLocation(extensionModel.getXmlDslModel().getSchemaLocation());
        ClassLoader classLoader = MuleFrameworkUtils.getClassLoader(extensionModel);
        String path = DefaultXmlDslInfo.getSchemaMappings(classLoader).get(schemaLocation);
        if (path != null) {
            return DefaultXmlDslInfo.loadSchema(path, classLoader);
        }
        return SCHEMA_GENERATOR.map(sg -> sg.generate(extensionModel, this.dslResolvingContext)).orElseThrow(() -> new RuntimeException("No schema generator found"));
    }

    private static String loadSchema(String path, ClassLoader classLoader) {
        return IOUtils.toString((InputStream)classLoader.getResourceAsStream(path), (Charset)StandardCharsets.UTF_8);
    }

    public static String resolveSchemaLocation(String location) {
        if (location.equals(CORE_XSD)) {
            return CORE_CURRENT_XSD;
        }
        return location;
    }

    public static Map<String, String> getSchemaMappings(ClassLoader classLoader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading schema mappings from [META-INF/mule.schemas]");
        }
        try {
            Properties appPluginsMappings = DefaultXmlDslInfo.loadAllProperties(CUSTOM_SCHEMA_MAPPINGS_LOCATION, classLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded schema mappings: {}", (Object)appPluginsMappings);
            }
            HashMap<String, String> schemaMappings = new HashMap<String, String>();
            appPluginsMappings.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> schemaMappings.put((String)key, (String)value)));
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [META-INF/mule.schemas]", ex);
        }
    }

    private static Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        Enumeration<URL> urls = classLoader != null ? classLoader.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection con = url.openConnection();
            DefaultXmlDslInfo.useCachesIfNecessary(con);
            InputStream is = con.getInputStream();
            try {
                if (resourceName != null && resourceName.endsWith(".xml")) {
                    props.loadFromXML(is);
                    continue;
                }
                props.load(is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return props;
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }
}

