/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.service;

import com.mulesoft.connectivity.mule.api.MuleConnectivityService;
import com.mulesoft.mule.framework.api.ServiceConfigurer;
import com.mulesoft.mule.framework.api.dependency.DependencyResolutionException;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.framework.internal.builder.service.MuleFrameworkServiceDiscoverer;
import org.mule.framework.internal.service.CustomServiceLifecycleProxyInvocationHandler;
import org.mule.framework.internal.service.SharedServiceLifecycleProxyInvocationHandler;
import org.mule.framework.internal.service.noop.NoOpApiKitMetadataService;
import org.mule.framework.internal.service.noop.NoOpExpressionLanguageMetadataService;
import org.mule.framework.internal.service.noop.NoOpOAuthService;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.oauth.api.OAuthService;

public class MuleFrameworkServiceConfigurerBuilder
implements ServiceConfigurer {
    private static final String ARTIFACTID_DW_EE_SERVICE = "mule-service-weave-ee";
    private static final String DATA_WEAVE_SERVICE_NAME = "service/DataWeave service";
    private static final String GROUPID_DW_EE_SERVICE = "com.mulesoft.services";
    private static final String GROUPID_RUNTIME_EE_SERVICES = "com.mulesoft.mule.services";
    public static final String CONNECTIVITY_DATA_WEAVE_SERVICE = "service/Connectivity DataWeave service";
    private static ServiceRegistry defaultServiceRegistry = ServiceRegistry.create();
    private final Map<Class<? extends Service>, Service> customServices = new HashMap<Class<? extends Service>, Service>();
    private final ServiceClassLoaderFactory serviceClassLoaderFactory;
    private final ArtifactClassLoader containerClassLoader;
    private final MuleVersion muleVersion;
    private final List<URL> muleServices;
    private Map<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> explodedFolderServicesFactories;
    private boolean toolingServicesEnabled;
    private boolean oAuthServiceEnabled;

    private static Map<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> defaultServicesFactories() {
        HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> defaultServices = new HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>>();
        defaultServices.put(SchedulerService.class, serviceDiscoverer -> serviceDiscoverer.createService(SchedulerService.class, "com.mulesoft.mule.framework", "mule-framework-service-diet-scheduler", "service/Scheduler service"));
        defaultServices.put(DefaultExpressionLanguageFactoryService.class, serviceDiscoverer -> serviceDiscoverer.createService(DefaultExpressionLanguageFactoryService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME));
        defaultServices.put(HttpService.class, serviceDiscoverer -> serviceDiscoverer.createService(HttpService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-http-ee", "service/HTTP EE service"));
        defaultServices.put(MetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(MetadataService.class, "org.mule.services", "mule-service-apikit-metadata", "service/Apikit Metadata service") : new NoOpApiKitMetadataService());
        defaultServices.put(ExpressionLanguageMetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(ExpressionLanguageMetadataService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME) : new NoOpExpressionLanguageMetadataService());
        defaultServices.put(MuleConnectivityService.class, serviceDiscoverer -> serviceDiscoverer.createService(MuleConnectivityService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, CONNECTIVITY_DATA_WEAVE_SERVICE, MuleVersion.v4_10_0.toString()));
        defaultServices.put(OAuthService.class, serviceDiscoverer -> serviceDiscoverer.isOAuthServiceEnabled() ? serviceDiscoverer.createService(OAuthService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-oauth-ee", "service/OAUTH EE service") : new NoOpOAuthService());
        return defaultServices;
    }

    public static void disposeServices() {
        defaultServiceRegistry.getAllServices().forEach(MuleFrameworkServiceConfigurerBuilder::disposeService);
    }

    private static void disposeService(Service service) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof SharedServiceLifecycleProxyInvocationHandler) {
            try {
                ((SharedServiceLifecycleProxyInvocationHandler)((Object)invocationHandler)).forceStop();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public MuleFrameworkServiceConfigurerBuilder(ServiceClassLoaderFactory serviceClassLoaderFactory, ArtifactClassLoader containerClassLoader, MuleVersion muleVersion, List<URL> muleServices) {
        this.serviceClassLoaderFactory = serviceClassLoaderFactory;
        this.containerClassLoader = containerClassLoader;
        this.muleVersion = muleVersion;
        this.muleServices = muleServices;
    }

    public ServiceConfigurer withExplodedServicesFrom(Path servicesDir) {
        if (this.explodedFolderServicesFactories != null) {
            throw new IllegalStateException("`withExplodedServicesFrom` was already calles for this configurer.");
        }
        if (!servicesDir.toFile().exists()) {
            throw new IllegalArgumentException("servicesBundleDir `" + servicesDir.toFile().getAbsolutePath() + "` does not exist.");
        }
        if (!servicesDir.toFile().isDirectory()) {
            throw new IllegalArgumentException("servicesBundleDir `" + servicesDir.toFile().getAbsolutePath() + "` is NOT a directory.");
        }
        HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> servicesFactories = new HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>>();
        servicesFactories.put(SchedulerService.class, serviceDiscoverer -> serviceDiscoverer.createService(SchedulerService.class, "com.mulesoft.mule.framework", "mule-framework-service-diet-scheduler", "service/Scheduler service", servicesDir));
        if (this.muleServices == null) {
            servicesFactories.put(DefaultExpressionLanguageFactoryService.class, serviceDiscoverer -> serviceDiscoverer.createService(DefaultExpressionLanguageFactoryService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME, servicesDir));
            servicesFactories.put(HttpService.class, serviceDiscoverer -> serviceDiscoverer.createService(HttpService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-http-ee", "service/HTTP EE service", servicesDir));
            servicesFactories.put(ExpressionLanguageMetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(ExpressionLanguageMetadataService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME, servicesDir) : new NoOpExpressionLanguageMetadataService());
            servicesFactories.put(MuleConnectivityService.class, serviceDiscoverer -> serviceDiscoverer.createService(MuleConnectivityService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, CONNECTIVITY_DATA_WEAVE_SERVICE, servicesDir, MuleVersion.v4_10_0.toString()));
            servicesFactories.put(OAuthService.class, serviceDiscoverer -> serviceDiscoverer.isOAuthServiceEnabled() ? serviceDiscoverer.createService(OAuthService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-oauth-ee", "service/OAUTH EE service", servicesDir) : new NoOpOAuthService());
        }
        servicesFactories.put(MetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(MetadataService.class, "org.mule.services", "mule-service-apikit-metadata", "service/Apikit Metadata service", servicesDir) : new NoOpApiKitMetadataService());
        this.explodedFolderServicesFactories = servicesFactories;
        return this;
    }

    public ServiceConfigurer withSchedulerService(SchedulerService service) {
        return this.withService(SchedulerService.class, service);
    }

    public ServiceConfigurer withExpressionLanguageFactoryService(DefaultExpressionLanguageFactoryService service) {
        return this.withService(DefaultExpressionLanguageFactoryService.class, service);
    }

    private <S extends Service> ServiceConfigurer withService(Class<S> serviceInterface, S service) {
        if (service == null) {
            throw new IllegalArgumentException("'service' cannot be null");
        }
        if (this.customServices.containsKey(serviceInterface)) {
            throw new IllegalStateException("Service with interface '" + serviceInterface.getName() + "' is already set");
        }
        this.customServices.put(serviceInterface, (Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{serviceInterface, Startable.class, Stoppable.class}, (InvocationHandler)((Object)new CustomServiceLifecycleProxyInvocationHandler(defaultServiceRegistry, serviceInterface, service))));
        return this;
    }

    public ServiceConfigurer enableToolingServices() {
        this.toolingServicesEnabled = true;
        return this;
    }

    public ServiceConfigurer enableOAuthService() {
        this.oAuthServiceEnabled = true;
        return this;
    }

    public ServiceManager getServiceManager(DependencyResolver baseDependencyResolver) {
        MuleFrameworkServiceDiscoverer muleFrameworkServiceDiscoverer;
        DependencyResolver dependencyResolver = this.muleServices != null ? new ExplodedServicesDependencyResolver(this.muleServices, baseDependencyResolver) : baseDependencyResolver;
        try {
            muleFrameworkServiceDiscoverer = new MuleFrameworkServiceDiscoverer(this.serviceClassLoaderFactory, this.containerClassLoader, dependencyResolver, defaultServiceRegistry, this.muleVersion, this.toolingServicesEnabled, this.oAuthServiceEnabled);
        }
        catch (IOException e2) {
            throw new MuleRuntimeException((Throwable)e2);
        }
        Map<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> servicesFactories = MuleFrameworkServiceConfigurerBuilder.defaultServicesFactories();
        if (this.explodedFolderServicesFactories != null) {
            servicesFactories.putAll(this.explodedFolderServicesFactories);
        }
        List services = servicesFactories.entrySet().stream().map(e -> {
            Class serviceInterface = (Class)e.getKey();
            Service service = this.customServices.containsKey(serviceInterface) ? this.customServices.get(serviceInterface) : (Service)((Function)e.getValue()).apply(muleFrameworkServiceDiscoverer);
            return service;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return ServiceManager.create(() -> new ArrayList(services));
    }

    @Deprecated
    public static void resetServiceRegistry() {
        defaultServiceRegistry = ServiceRegistry.create();
        MuleFrameworkServiceDiscoverer.classLoaderEntryByGroupArtifact.clear();
    }

    private static class ExplodedServicesDependencyResolver
    implements DependencyResolver {
        private static final Collection<String> SERVICES_TO_RESOLVE = Arrays.asList("com.mulesoft.mule.framework:mule-framework-service-diet-scheduler", "org.mule.services:mule-service-apikit-metadata");
        private final List<URL> muleServices;
        private final DependencyResolver delegateDependencyResolver;

        public ExplodedServicesDependencyResolver(List<URL> muleServices, DependencyResolver dependencyResolver) {
            this.muleServices = muleServices;
            this.delegateDependencyResolver = dependencyResolver;
        }

        public BundleDependency resolveFor(BundleDescriptor descriptor) throws DependencyResolutionException {
            BundleDependency serviceDependency = this.resolveFromAvailableServices(descriptor);
            return serviceDependency != null ? serviceDependency : this.delegateDependencyResolver.resolveFor(descriptor);
        }

        public BundleDependency resolveArtifact(BundleDescriptor descriptor) throws DependencyResolutionException {
            BundleDependency serviceDependency = this.resolveFromAvailableServices(descriptor);
            return serviceDependency != null ? serviceDependency : this.delegateDependencyResolver.resolveArtifact(descriptor);
        }

        private BundleDependency resolveFromAvailableServices(BundleDescriptor descriptor) throws DependencyResolutionException {
            String service = descriptor.getGroupId() + ":" + descriptor.getArtifactId();
            String key = service + ":" + descriptor.getVersion();
            if (SERVICES_TO_RESOLVE.contains(service)) {
                return null;
            }
            BundleDependency bundleDependency = this.muleServices.stream().map(FileUtils::toFile).filter(serviceFolder -> serviceFolder.getName().startsWith(descriptor.getArtifactId())).findFirst().map(serviceFolder -> this.getBundleDependency(serviceFolder.toURI(), descriptor)).orElse(null);
            if (bundleDependency == null) {
                throw new DependencyResolutionException(I18nMessageFactory.createStaticMessage((String)String.format("Dependency '%s' not found", key)));
            }
            return bundleDependency;
        }

        private BundleDependency getBundleDependency(URI serviceFolderUri, BundleDescriptor descriptor) {
            return new BundleDependency.Builder().setBundleDescriptor(descriptor).setBundleUri(serviceFolderUri).build();
        }

        public void dispose() {
        }
    }
}

