/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.domain;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.AbstractFrameworkDomainFromProjectConfigurer;
import org.mule.framework.internal.builder.domain.DefaultFrameworkDomain;
import org.mule.framework.internal.builder.domain.PackagedDomainWrapper;
import org.mule.framework.internal.builder.domain.PackagedFrameworkDomain;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;

public class FrameworkDomainFromPackagedProjectConfigurer
extends AbstractFrameworkDomainFromProjectConfigurer {
    private final PackagedDomainWrapper packagedDomainWrapper;
    private final boolean forceConfigsParse;
    private DeployableProjectModel deployableProjectModel;

    public FrameworkDomainFromPackagedProjectConfigurer(Path packagedDomainPath, boolean forceConfigsParse) {
        this.packagedDomainWrapper = new PackagedDomainWrapper(packagedDomainPath.toFile());
        this.forceConfigsParse = forceConfigsParse;
    }

    @Override
    protected DeployableProjectModel createDeployableProjectModel(MavenConfiguration mavenConfiguration) {
        if (this.deployableProjectModel == null) {
            this.deployableProjectModel = DeployableProjectModelBuilder.forMuleProject((File)this.packagedDomainWrapper.getFile(), Optional.empty()).build();
        }
        return this.deployableProjectModel;
    }

    @Override
    protected DefaultFrameworkDomain getFrameworkDomain(MuleDeployableArtifactClassLoader domainClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations, UnaryOperator<String> propertiesResolver, MavenConfiguration mavenConfiguration) {
        return new PackagedFrameworkDomain(domainClassLoader, Optional.of(this.createDeployableProjectModel(mavenConfiguration)), configsCreationConfigurer, this.getWorkingDirectory(), dslValidations, propertiesResolver, this.getDomainConfigResources(), this.getDomainXmlConfigDocuments(), this.packagedDomainWrapper, this.forceConfigsParse);
    }
}

