/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.artifact;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mule.framework.internal.DefaultDeployableProjectModel;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.api.deployable.MuleProjectStructure;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;

public final class RefreshConfigurerUtils {
    private RefreshConfigurerUtils() {
    }

    public static DeployableProjectModel doCreateDeployableProjectModel(FrameworkDeployableArtifact baseFrameworkDeployableArtifact) {
        MuleProjectStructure baseProjectStructure = (MuleProjectStructure)baseFrameworkDeployableArtifact.getDeployableProjectModel().filter(DefaultDeployableProjectModel.class::isInstance).flatMap(model -> ((DefaultDeployableProjectModel)model).getProjectStructure()).orElseThrow(() -> new IllegalStateException("'baseMuleFramework' was not created from a project."));
        MuleDeployableArtifactClassLoader baseApplicationExecutionClassLoader = baseFrameworkDeployableArtifact.getExecutionClassLoader();
        return DeployableProjectModelBuilder.forMavenRefreshProject((MuleProjectStructure)baseProjectStructure, (ArtifactCoordinates)baseApplicationExecutionClassLoader.getArtifactDescriptor().getBundleDescriptor(), (boolean)true, Collections.emptyList(), Collections.emptySet(), Collections.emptyMap(), (MavenConfiguration)baseFrameworkDeployableArtifact.getMavenConfiguration()).build();
    }

    public static Set<URL> populateFolderUrls(DeployableProjectModel model, Path classPathEntry) {
        try {
            File target;
            HashSet<URL> folderUrls = new HashSet<URL>();
            for (Path resource : model.getResourcesPath()) {
                folderUrls.add(resource.toUri().toURL());
            }
            if (!model.getPackages().isEmpty() && classPathEntry != null && (target = classPathEntry.toFile()).exists()) {
                folderUrls.add(target.toURI().toURL());
            }
            return folderUrls;
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static void configureDescriptor(DeployableProjectModel model, DeployableArtifactDescriptor descriptor, DeployableArtifactDescriptor baseDescriptor) {
        descriptor.setArtifactLocation(baseDescriptor.getArtifactLocation());
        descriptor.setBundleDescriptor(baseDescriptor.getBundleDescriptor());
        descriptor.setLogConfigFile(baseDescriptor.getLogConfigFile());
        descriptor.setMinMuleVersion(baseDescriptor.getMinMuleVersion());
        descriptor.setPlugins(baseDescriptor.getPlugins());
        descriptor.setRedeploymentEnabled(baseDescriptor.isRedeploymentEnabled());
        descriptor.setRequiredProduct(baseDescriptor.getRequiredProduct());
        descriptor.setRootFolder(baseDescriptor.getRootFolder());
        descriptor.setSupportedJavaVersions(baseDescriptor.getSupportedJavaVersions());
        descriptor.setClassLoaderConfiguration(new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder(baseDescriptor.getClassLoaderConfiguration()).exportingPackages(new HashSet(model.getPackages())).exportingResources(new HashSet(model.getResources())).build());
        descriptor.setConfigResources(model.getDeployableModel().getConfigs());
    }
}

