/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.artifact;

import com.google.common.collect.Maps;
import com.mulesoft.mule.framework.api.DeployableProjectModel;
import com.mulesoft.mule.framework.api.exception.FrameworkBuildException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.framework.internal.DefaultDeployableProjectModel;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.util.DependenciesUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolverProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.module.artifact.activation.api.ast.ArtifactAstUtils;
import org.mule.runtime.module.artifact.activation.api.ast.AstXmlParserSupplier;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class DefaultFrameworkDeployableArtifact<AD extends DeployableArtifactDescriptor>
implements FrameworkDeployableArtifact {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFrameworkDeployableArtifact.class);
    private static final Function<ConfigurationPropertiesResolver, ParsingPropertyResolver> DEFAULT_PROPERTIES_RESOLVER = configurationPropertiesResolver -> propertyKey -> {
        try {
            return (String)configurationPropertiesResolver.resolveValue(propertyKey);
        }
        catch (PropertyNotFoundException pnfe) {
            return propertyKey;
        }
    };
    private final MuleDeployableArtifactClassLoader deployableArtifactClassLoader;
    private final Optional<DeployableProjectModel> deployableProjectModel;
    private final InternalConfigurationsCreationConfigurer configsCreationConfigurer;
    private final Optional<Path> workingDirectory;
    private final boolean dslValidations;
    private final Function<ConfigurationPropertiesResolver, ParsingPropertyResolver> propertiesResolver;
    private AstXmlParser muleXmlParser;
    private final Collection<ConfigResource> appConfigResources;
    private final Map<String, Document> xmlConfigDocuments;
    private ArtifactAst artifactAst;
    private Collection<ComponentAst> configsAsts;
    private ConfigurationPropertiesResolverProvider configurationProperties;
    private final MavenConfiguration mavenConfiguration;

    protected DefaultFrameworkDeployableArtifact(MuleDeployableArtifactClassLoader deployableArtifactClassLoader, Optional<org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel> deployableProjectModel, InternalConfigurationsCreationConfigurer configsCreationConfigurer, Optional<Path> workingDirectory, boolean dslValidations, UnaryOperator<String> propertiesResolver, Optional<AstXmlParser> astXmlParser, Collection<ConfigResource> configResources, Map<String, Document> xmlConfigDocuments, MavenConfiguration mavenConfiguration) {
        this.deployableArtifactClassLoader = deployableArtifactClassLoader;
        this.deployableProjectModel = this.toFrameworkDeployableProjectModel(deployableProjectModel);
        this.configsCreationConfigurer = configsCreationConfigurer;
        this.workingDirectory = Objects.requireNonNull(workingDirectory);
        this.dslValidations = dslValidations;
        this.propertiesResolver = propertiesResolver != null ? this.getParsingPropertyResolver(propertiesResolver) : DEFAULT_PROPERTIES_RESOLVER;
        this.muleXmlParser = astXmlParser.orElse(null);
        this.appConfigResources = configResources;
        this.xmlConfigDocuments = xmlConfigDocuments;
        this.mavenConfiguration = mavenConfiguration;
    }

    private Function<ConfigurationPropertiesResolver, ParsingPropertyResolver> getParsingPropertyResolver(UnaryOperator<String> propertiesResolver) {
        return configurationPropertiesResolver -> propertiesResolver::apply;
    }

    private Optional<DeployableProjectModel> toFrameworkDeployableProjectModel(Optional<org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel> deployableProjectModel) {
        return deployableProjectModel.map(dpm -> new DefaultDeployableProjectModel(DependenciesUtils.muleToMavenDependencies(dpm.getDependencies()), dpm.getProjectStructure(), this.muleToMavenDependencies(dpm.getAdditionalPluginDependencies())));
    }

    private Map<BundleDescriptor, List<org.mule.maven.pom.parser.api.model.BundleDependency>> muleToMavenDependencies(Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, List<BundleDependency>> muleAdditionalPluginDependencies) {
        return muleAdditionalPluginDependencies.entrySet().stream().collect(Collectors.toMap(entry -> DependenciesUtils.muleToMavenDescriptor((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)entry.getKey()), entry -> DependenciesUtils.muleToMavenDependencies((List)entry.getValue())));
    }

    @Override
    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    @Override
    public void setUp(Set<ExtensionModel> extensionModels) {
        this.artifactAst = this.createAst(extensionModels);
        this.configsAsts = this.getConfigsAsts(this.artifactAst);
    }

    protected final ArtifactAst createAst(Set<ExtensionModel> extensionModels) {
        if (this.configsCreationConfigurer != null && this.configsCreationConfigurer.getArtifactAst() != null) {
            return this.configsCreationConfigurer.getArtifactAst();
        }
        return (ArtifactAst)ClassUtils.withContextClassLoader((ClassLoader)this.deployableArtifactClassLoader, () -> this.loadAst(extensionModels));
    }

    @Override
    public void setUp(MuleContext muleContext, ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, ExpressionLanguageMetadataService expressionLanguageMetadataService, Set<ExtensionModel> extensionModels) throws ConfigurationException, InitialisationException {
        if (this.artifactAst == null) {
            Map<String, String> deploymentProperties = this.getDeploymentPropertiesFromArtifact((DeployableArtifactDescriptor)this.deployableArtifactClassLoader.getArtifactDescriptor());
            ArtifactAst artifactAst = this.artifactAst = this.configsCreationConfigurer != null ? this.configsCreationConfigurer.getArtifactAst() : null;
            if (this.artifactAst == null) {
                this.artifactAst = (ArtifactAst)ClassUtils.withContextClassLoader((ClassLoader)this.deployableArtifactClassLoader, () -> this.createAst((DeployableArtifactDescriptor)this.deployableArtifactClassLoader.getArtifactDescriptor(), muleContext, expressionLanguageMetadataService, extensionModels, deploymentProperties));
            }
            if (this.configsCreationConfigurer != null) {
                this.configsCreationConfigurer.configure(this.artifactAst, muleContext.getExecutionClassLoader(), deploymentProperties);
                this.configurationProperties = this.configsCreationConfigurer.getConfigurationProperties();
            } else {
                this.configurationProperties = this.createSimpleConfigurationProperties(deploymentProperties);
            }
            if (this.artifactAst != null) {
                this.configsAsts = this.getConfigsAsts(this.artifactAst);
                this.loadTopLevelElements(muleContext, extensionDesignTimeResolversFactory, this.artifactAst, this.getClassLoader());
            }
        }
    }

    protected ArtifactAst loadAst(Set<ExtensionModel> extensionModels) {
        if (this.configsCreationConfigurer != null && this.configsCreationConfigurer.getArtifactAst() != null) {
            return this.configsCreationConfigurer.getArtifactAst();
        }
        ConfigurationPropertiesResolver propertyResolver = this.createSimpleConfigurationProperties(Collections.emptyMap()).getConfigurationPropertiesResolver();
        ParsingPropertyResolver parsingPropertyResolver = this.propertiesResolver.apply(propertyResolver);
        if (this.xmlConfigDocuments != null) {
            AstXmlParser astXmlParser = this.doCreateMuleXmlParser(extensionModels, true, parsingPropertyResolver);
            return astXmlParser.parseDocument(this.deployableArtifactClassLoader.getArtifactDescriptor().getBundleDescriptor().getArtifactId(), this.xmlConfigDocuments.entrySet().stream().map(e -> new Pair((Object)((String)e.getKey()), (Object)((Document)e.getValue()))).collect(Collectors.toList()));
        }
        AstXmlParser astXmlParser = this.doCreateMuleXmlParser(extensionModels, !this.dslValidations, parsingPropertyResolver);
        return astXmlParser.parse(this.deployableArtifactClassLoader.getArtifactDescriptor().getBundleDescriptor().getArtifactId(), this.getConfigResources());
    }

    private ConfigResource[] getConfigResources() {
        if (this.appConfigResources != null) {
            return (ConfigResource[])this.appConfigResources.stream().toArray(ConfigResource[]::new);
        }
        Set configResources = ((DeployableArtifactDescriptor)this.deployableArtifactClassLoader.getArtifactDescriptor()).getConfigResources();
        return (ConfigResource[])configResources.stream().map(configResource -> {
            try {
                return new ConfigResource(configResource, this.deployableArtifactClassLoader.getResource(configResource));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Cannot load config file '%s'.", configResource), e);
            }
        }).toArray(ConfigResource[]::new);
    }

    private AstXmlParser createMuleXmlParser(Set<ExtensionModel> extensions, Map<String, String> deploymentProperties, boolean disableXmlValidations) {
        ConfigurationPropertiesResolver propertyResolver = this.createSimpleConfigurationProperties(deploymentProperties).getConfigurationPropertiesResolver();
        return this.doCreateMuleXmlParser(extensions, disableXmlValidations, this.propertiesResolver.apply(propertyResolver));
    }

    protected ArtifactAst createAst(AD artifactDescriptor, MuleContext muleContext, ExpressionLanguageMetadataService expressionLanguageMetadataService, Set<ExtensionModel> extensionModels, Map<String, String> deploymentProperties) throws ConfigurationException {
        if (this.muleXmlParser == null) {
            this.muleXmlParser = this.createMuleXmlParser(extensionModels, deploymentProperties, !this.dslValidations);
        }
        AstXmlParserSupplier parserSupplier = (exts, disableValidations) -> this.muleXmlParser;
        if (this.xmlConfigDocuments != null) {
            return ArtifactAstUtils.parseAndBuildAppExtensionModel((String)artifactDescriptor.getBundleDescriptor().getArtifactId(), this.xmlConfigDocuments, (AstXmlParserSupplier)parserSupplier, extensionModels, (!this.dslValidations ? 1 : 0) != 0, (ClassLoader)muleContext.getExecutionClassLoader(), (MuleConfiguration)muleContext.getConfiguration(), (ExpressionLanguageMetadataService)expressionLanguageMetadataService);
        }
        ArtifactAst artifactAst = ArtifactAstUtils.parseAndBuildAppExtensionModel((String)artifactDescriptor.getBundleDescriptor().getArtifactId(), (ConfigResource[])this.getConfigResources(), (AstXmlParserSupplier)parserSupplier, extensionModels, (!this.dslValidations ? 1 : 0) != 0, (ClassLoader)muleContext.getExecutionClassLoader(), (MuleConfiguration)muleContext.getConfiguration(), (ExpressionLanguageMetadataService)expressionLanguageMetadataService);
        this.validateComponentsExtensionsPresent(artifactAst);
        return artifactAst;
    }

    private void validateComponentsExtensionsPresent(ArtifactAst artifactAst) {
        artifactAst.topLevelComponents().forEach(componentAst -> {
            if (componentAst.getExtensionModel() == null) {
                throw new FrameworkBuildException(String.format("Extension model not present for component '%s', a dependency might be missing", componentAst));
            }
        });
    }

    protected abstract AstXmlParser doCreateMuleXmlParser(Set<ExtensionModel> var1, boolean var2, ParsingPropertyResolver var3);

    private List<ComponentAst> getConfigsAsts(ArtifactAst artifactAst) {
        return artifactAst.topLevelComponentsStream().filter(tlc -> tlc.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).collect(Collectors.toList());
    }

    protected ConfigurationPropertiesResolverProvider createSimpleConfigurationProperties(Map<String, String> deploymentProperties) {
        return ConfigurationPropertiesResolverProvider.fromResolver((ConfigurationPropertiesResolver)new ConfigurationPropertiesHierarchyBuilder().withDeploymentProperties(deploymentProperties).withoutFailuresIfPropertyNotPresent().build());
    }

    protected Map<String, String> getDeploymentPropertiesFromArtifact(AD artifactDescriptor) {
        return artifactDescriptor.getDeploymentProperties().map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap());
    }

    @Override
    public AstXmlParser getMuleXmlParser() {
        return this.muleXmlParser;
    }

    @Override
    public ConfigurationPropertiesResolverProvider getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public boolean isCreateConfigurations() {
        return this.configsCreationConfigurer != null;
    }

    protected InternalConfigurationsCreationConfigurer getConfigsCreationConfigurer() {
        return this.configsCreationConfigurer;
    }

    @Override
    public Optional<DeployableProjectModel> getDeployableProjectModel() {
        return this.deployableProjectModel;
    }

    @Override
    public ArtifactAst getArtifactAst() {
        return this.artifactAst;
    }

    @Override
    public Optional<Collection<ComponentAst>> getConfigurationsAsts() {
        return Optional.ofNullable(this.configsAsts);
    }

    @Override
    public Optional<Path> getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.configurationProperties, (Logger)LOGGER);
        this.deployableArtifactClassLoader.dispose();
    }

    private void loadTopLevelElements(MuleContext muleContext, ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, ArtifactAst ast, MuleDeployableArtifactClassLoader classLoader) {
        ast.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.UNKNOWN)).filter(componentAst -> componentAst.getComponentId().isPresent()).filter(componentAst -> DefaultFrameworkDeployableArtifact.isInstantiableWithDefaultConstructorComponent(componentAst.getType())).forEach(componentAst -> {
            String className = componentAst.getType().getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getClassname).get();
            String id = (String)componentAst.getComponentId().get();
            try {
                ComponentParameterization parameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)componentAst);
                Class componentClass = classLoader.loadClass(className);
                String componentName = componentAst.getComponentId().orElse("unknown");
                Object impl = extensionDesignTimeResolversFactory.createTopLevelComponent(parameterization, componentName, componentClass);
                LegacyRegistryUtils.registerObject((MuleContext)muleContext, (String)id, (Object)impl);
            }
            catch (Exception e) {
                LOGGER.warn("Top Level Element of id '{}' of type '{}' could not be created", (Object)id, (Object)className);
            }
        });
    }

    private static boolean isInstantiableWithDefaultConstructorComponent(MetadataType type) {
        return type != null && type.getAnnotation(ClassInformationAnnotation.class).map(annotation -> annotation.isInstantiable() && annotation.hasDefaultConstructor()).orElse(false) != false;
    }
}

