/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriteException;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import com.mulesoft.flatfile.lexical.formats.exception.InvalidDateException;
import com.mulesoft.flatfile.lexical.formats.utils.DateParser;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;

public class X12DateFormat
extends TypeFormatBase {
    private static final String DATE_8 = "uuuuMMdd";
    private static final String YEAR_2000 = "20";
    private static final String YEAR_1900 = "19";

    public X12DateFormat(String code, int min, int max) {
        super(code, min, max, ' ');
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.DATE;
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        this.verifyDigits(lexer);
        this.checkInputLength(lexer);
        StringBuilder builder = lexer.tokenBuilder();
        try {
            LocalDate date = this.parseDate(builder.toString());
            return DateParser.getDateAsCalendar(date);
        }
        catch (InvalidDateException ex) {
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_DATE, ex.getMessage());
            return null;
        }
    }

    protected LocalDate parseDate(String dateString) throws InvalidDateException {
        if (dateString.length() != 6 && dateString.length() != 8) {
            throw new InvalidDateException("date value must be either 6 or 8 characters");
        }
        String date = dateString;
        if (dateString.length() == 6) {
            date = Integer.parseInt(YEAR_2000 + dateString.substring(0, 2)) > 2070 ? YEAR_1900 + dateString : YEAR_2000 + dateString;
        }
        try {
            return DateParser.getDate(date, DATE_8);
        }
        catch (DateTimeParseException dtpex) {
            throw new InvalidDateException(dtpex.getMessage());
        }
        catch (Exception ex) {
            throw new InvalidDateException(String.format("Invalid date: could not parse \"%s\"", dateString));
        }
    }

    public void writeDate(LocalDate date, WriterBase writer) throws IOException {
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        StringBuilder builder = new StringBuilder();
        builder.append(year);
        if (this.maxLength == 6) {
            if (year > 2070 || year <= 1970) {
                throw new WriteException("year out of range for short form date");
            }
            builder.delete(0, 2);
        } else {
            if (builder.length() > 4) {
                throw new WriteException("year outside of allowed range");
            }
            while (builder.length() < 4) {
                builder.insert(0, '0');
            }
        }
        X12DateFormat.appendTwoDigit(month, builder);
        X12DateFormat.appendTwoDigit(day, builder);
        writer.startToken();
        writer.writeUnchecked(builder.toString());
    }

    @Override
    public void write(Object value, WriterBase writer) throws IOException {
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            LocalDate date = LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalDate();
            this.writeDate(date, writer);
        } else if (value instanceof Date) {
            Date input = (Date)value;
            LocalDate date = input.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            this.writeDate(date, writer);
        } else if (value instanceof Instant) {
            LocalDate date = LocalDateTime.ofInstant((Instant)value, ZoneId.systemDefault()).toLocalDate();
            this.writeDate(date, writer);
        } else if (value instanceof LocalDate) {
            this.writeDate((LocalDate)value, writer);
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime zoned = (ZonedDateTime)value;
            LocalDate date = LocalDateTime.ofInstant(zoned.toInstant(), zoned.getZone()).toLocalDate();
            this.writeDate(date, writer);
        } else {
            this.wrongType(value, writer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof X12DateFormat && super.equals(obj);
    }
}

