/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.metadata.api;

import java.util.Optional;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.soapkit.metadata.api.Notifier;
import org.mule.module.soapkit.metadata.api.ResourceLoader;
import org.mule.module.soapkit.metadata.internal.MetadataHandler;
import org.mule.module.soapkit.metadata.internal.WsdlHandler;
import org.mule.module.soapkit.metadata.internal.model.ApplicationModelWrapper;
import org.mule.runtime.ast.api.ArtifactAst;

public class Metadata {
    private MetadataHandler metadataHandler;

    private Metadata(ArtifactAst applicationModel, ResourceLoader resourceLoader, Notifier notifier) {
        this.init(applicationModel, resourceLoader, notifier);
    }

    private void init(ArtifactAst applicationModel, ResourceLoader resourceLoader, Notifier notifier) {
        WsdlHandler wsdlHandler = new WsdlHandler(resourceLoader, notifier);
        ApplicationModelWrapper wrapper = new ApplicationModelWrapper(applicationModel, wsdlHandler, notifier);
        this.metadataHandler = new MetadataHandler(wrapper, notifier);
    }

    public Optional<FunctionType> getMetadataForFlow(String flowName) {
        return this.metadataHandler.getMetadataForFlow(flowName);
    }

    public static class Builder {
        private ResourceLoader resourceLoader;
        private ArtifactAst applicationModel;
        private Notifier notifier;

        public Builder withResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        public Builder withApplicationModel(ArtifactAst applicationModel) {
            this.applicationModel = applicationModel;
            return this;
        }

        public Builder withNotifier(Notifier notifier) {
            this.notifier = notifier;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.applicationModel, this.resourceLoader, this.notifier);
        }
    }
}

