/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.value;

import com.google.common.base.Throwables;
import com.mulesoft.mule.framework.api.extension.config.ConfigurationHandler;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.framework.internal.tooling.type.resolution.ExpressionNotSupportedException;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.valueprovider.ValueProviderMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueProviderExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueProviderExecutor.class);
    public static final String INVALID_PARAMETER_VALUE = "INVALID_PARAMETER_VALUE";
    private final ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private final ValueProviderMediator valueProviderMediator;
    private final ParameterizedModel parameterizedModel;

    public ValueProviderExecutor(ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, ParameterizedModel parameterizedModel) {
        this.extensionDesignTimeResolversFactory = extensionDesignTimeResolversFactory;
        this.parameterizedModel = parameterizedModel;
        this.valueProviderMediator = this.createValueProviderMediator(parameterizedModel);
    }

    public ValueResult resolveValues(ExtensionModel extensionModel, String providerName, ComponentParameterization actingParameter, Optional<ConfigurationHandler> configurationHandler) {
        try {
            if (this.parameterizedModel != actingParameter.getModel()) {
                ValueResult valueResult = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)new ValueResolvingException("The parameter model from the acting parameters is different from the one provided in the session", INVALID_PARAMETER_VALUE)).withFailureCode(INVALID_PARAMETER_VALUE).build());
                return valueResult;
            }
            LOGGER.debug("Resolve value provider: {} STARTED for component: {}", (Object)providerName, (Object)this.parameterizedModel.getName());
            ClassLoader extensionClassLoader = MuleFrameworkUtils.getClassLoader(extensionModel);
            LOGGER.debug("Invoking value provider: {} for component: {}", (Object)providerName, (Object)this.parameterizedModel.getName());
            ValueResult valueResult = (ValueResult)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
                ParameterValueResolver parameterValueResolver = this.extensionDesignTimeResolversFactory.createParameterValueResolver(actingParameter, this.parameterizedModel, () -> MuleFrameworkUtils.resolveConfiguration(configurationHandler));
                return ValueResult.resultFrom((Set)this.valueProviderMediator.getValues(providerName, parameterValueResolver, MuleFrameworkUtils.connectionSupplier(configurationHandler), MuleFrameworkUtils.configSupplier(configurationHandler), (ConnectionProvider)MuleFrameworkUtils.getConnectionProvider(configurationHandler).orElse(null)));
            }, ValueResolvingException.class, e -> {
                throw new MuleRuntimeException((Throwable)e);
            });
            return valueResult;
        }
        catch (ValueResolvingException e2) {
            LOGGER.warn(String.format("Resolve value provider has FAILED with code: %s for component: %s", e2.getFailureCode(), actingParameter.getModel().getName()), (Throwable)e2);
            ValueResult valueResult = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e2).withFailureCode(e2.getFailureCode()).build());
            return valueResult;
        }
        catch (ExpressionNotSupportedException e3) {
            ValueResult valueResult = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)new ValueResolvingException(e3.getMessage(), INVALID_PARAMETER_VALUE)).withFailureCode(INVALID_PARAMETER_VALUE).build());
            return valueResult;
        }
        catch (MuleRuntimeException e4) {
            Throwable cause = e4.getCause();
            if (cause instanceof ValueResolvingException) {
                ValueResolvingException valueResolvingException = (ValueResolvingException)cause;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("Resolve value provider has FAILED with code: %s for component: %s", valueResolvingException.getFailureCode(), actingParameter.getModel().getName()), cause);
                }
                ResolvingFailure.Builder failureBuilder = ResolvingFailure.Builder.newFailure((Throwable)cause);
                failureBuilder.withFailureCode(valueResolvingException.getFailureCode());
                ValueResult valueResult = ValueResult.resultFrom((ResolvingFailure)failureBuilder.build());
                return valueResult;
            }
            Throwables.propagateIfPossible((Throwable)cause, MuleRuntimeException.class);
            throw new MuleRuntimeException(cause);
        }
        catch (Exception e5) {
            Throwables.propagateIfPossible((Throwable)e5, MuleRuntimeException.class);
            throw new MuleRuntimeException((Throwable)e5);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve value provider: {} FINISHED for component: {}", (Object)providerName, (Object)actingParameter.getModel().getName());
            }
        }
    }

    private ValueProviderMediator createValueProviderMediator(ParameterizedModel parameterizedModel) {
        return this.extensionDesignTimeResolversFactory.createValueProviderMediator(parameterizedModel);
    }

    @FunctionalInterface
    private static interface ValueProviderFunction {
        public Set<Value> apply(ValueProviderMediator var1, ParameterValueResolver var2, Supplier<Object> var3, Supplier<Object> var4, ConnectionProvider var5) throws ValueResolvingException;
    }
}

