/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.resolution;

import com.mulesoft.mule.framework.api.tooling.type.resolution.MetadataStorage;
import com.mulesoft.mule.framework.api.tooling.type.resolution.MetadataStorageId;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.framework.internal.tooling.type.resolution.DefaultMetadataStorageId;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;

public class MetadataStorageToCacheAdapter
implements MetadataCache {
    private final MetadataStorage delegate;
    private final Function<Serializable, MetadataStorageId> idAdapter;

    public MetadataStorageToCacheAdapter(MetadataStorage storage, Optional<MetadataCacheId> configCacheId) {
        this.delegate = storage;
        this.idAdapter = id -> DefaultMetadataStorageId.createFromIdValueAndConfigId(configCacheId, id);
    }

    public void put(Serializable key, Serializable value) {
        this.delegate.put(this.idAdapter.apply(key), value);
    }

    public void putAll(Map<? extends Serializable, ? extends Serializable> values) {
        this.delegate.putAll(values.entrySet().stream().collect(Collectors.toMap(e -> this.idAdapter.apply((Serializable)e.getKey()), Map.Entry::getValue)));
    }

    public <T extends Serializable> Optional<T> get(Serializable key) {
        return this.delegate.get(this.idAdapter.apply(key));
    }

    public <T extends Serializable> T computeIfAbsent(Serializable key, MetadataCache.MetadataCacheValueResolver mappingFunction) throws MetadataResolvingException, ConnectionException {
        return (T)this.delegate.computeIfAbsent(this.idAdapter.apply(key), arg_0 -> ((MetadataCache.MetadataCacheValueResolver)mappingFunction).compute(arg_0));
    }
}

