/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationRequest;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypedChainComponent;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypedEventField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypePropagationResult;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypedChainComponent;
import org.mule.framework.internal.tooling.type.propagation.TypedEventFieldBuilder;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationCFGVisitor;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public class TypePropagationResolverUtils {
    private TypePropagationResolverUtils() {
    }

    public static TypePropagationResult resolve(ArtifactAst app, ComponentAst ast, TypePropagationRequest request, TypePropagationCFGVisitor visitor, Map<ComponentLocation, ConnectableComponentModel> updatedModels, Optional<MuleEventMetadataType> apiKitOutput, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        TypePropagationResolver resolver = new TypePropagationResolver(app, visitor, updatedModels, expressionLanguageMetadataService, request, apiKitOutput);
        return resolver.resolve(ast);
    }

    private static Optional<ComponentMetadataTypesDescriptor> getMetadataDescriptor(ComponentAst componentAst, Optional<ConnectableComponentModel> updatedModel) {
        if (!(updatedModel.isPresent() || componentAst.getModel(HasOutputModel.class).isPresent() || componentAst.getModel(ParameterizedModel.class).isPresent())) {
            return Optional.empty();
        }
        ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder().keepNonDynamicMetadata(true);
        InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder = InputMetadataDescriptor.builder();
        OutputMetadataDescriptor.OutputMetadataDescriptorBuilder outputBuilder = OutputMetadataDescriptor.builder();
        TypePropagationResolverUtils.withFallback(updatedModel, () -> componentAst.getModel(HasOutputModel.class)).ifPresent(outputModel -> {
            TypePropagationResolverUtils.withOutputModel(outputBuilder, outputModel);
            builder.withOutputMetadataDescriptor(outputBuilder.build());
        });
        TypePropagationResolverUtils.withFallback(updatedModel, () -> componentAst.getModel(ParameterizedModel.class)).ifPresent(model -> {
            TypePropagationResolverUtils.withParameterizedModelModel(inputBuilder, model);
            builder.withInputMetadataDescriptor(inputBuilder.build());
        });
        return Optional.of(builder.build());
    }

    private static TypeMetadataDescriptor typeDescriptorFromOutput(OutputModel outputModel) {
        return TypeMetadataDescriptor.builder().withType(outputModel.getType()).dynamic(outputModel.hasDynamicType()).build();
    }

    private static <I extends O, O> Optional<O> withFallback(Optional<I> original, Supplier<Optional<O>> fallback) {
        if (original.isPresent()) {
            return original;
        }
        return fallback.get();
    }

    private static void withOutputModel(OutputMetadataDescriptor.OutputMetadataDescriptorBuilder outputBuilder, HasOutputModel componentWithOutputModel) {
        outputBuilder.withReturnType(TypePropagationResolverUtils.typeDescriptorFromOutput(componentWithOutputModel.getOutput()));
        outputBuilder.withAttributesType(TypePropagationResolverUtils.typeDescriptorFromOutput(componentWithOutputModel.getOutputAttributes()));
    }

    private static void withParameterizedModelModel(InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder, ParameterizedModel componentWithParameters) {
        componentWithParameters.getAllParameterModels().forEach(pm -> TypePropagationResolverUtils.generateParameterDescriptor(pm, inputBuilder));
    }

    private static void generateParameterDescriptor(ParameterModel pm, InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder) {
        ParameterMetadataDescriptor parameterMetadataDescriptor = ParameterMetadataDescriptor.builder((String)pm.getName()).withType(pm.getType()).dynamic(pm.hasDynamicType()).build();
        inputBuilder.withParameter(pm.getName(), parameterMetadataDescriptor);
    }

    private static class TypePropagationResolver {
        private final Map<String, TypedEventFieldBuilder> calculated = new HashMap<String, TypedEventFieldBuilder>();
        private final Map<ComponentLocation, TypedChainComponent> result = new HashMap<ComponentLocation, TypedChainComponent>();
        private final Set<String> analyzedTopLevelComponents = new HashSet<String>();
        private final ArtifactAst app;
        private final TypePropagationCFGVisitor visitor;
        private final Map<ComponentLocation, ConnectableComponentModel> updatedModels;
        private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
        private final TypePropagationRequest request;
        private ComponentLocation previous;
        private final Map<String, ComponentLocation> lastNonErrorHandlerOperationPerFlow = new HashMap<String, ComponentLocation>();
        private final Optional<MuleEventMetadataType> apikitOutput;

        private TypePropagationResolver(ArtifactAst application, TypePropagationCFGVisitor visitor, Map<ComponentLocation, ConnectableComponentModel> updatedModels, ExpressionLanguageMetadataService expressionLanguageMetadataService, TypePropagationRequest request, Optional<MuleEventMetadataType> apikitOutput) {
            this.app = application;
            this.visitor = visitor;
            this.updatedModels = updatedModels;
            this.expressionLanguageMetadataService = expressionLanguageMetadataService;
            this.request = request;
            this.apikitOutput = apikitOutput;
        }

        private TypePropagationResult resolve(ComponentAst ast) {
            ComponentLocation componentLocation = ast.getLocation();
            this.analyzedTopLevelComponents.add(componentLocation.getRootContainerName());
            this.previous = ast.getLocation();
            if (!ast.directChildrenStream().allMatch(this::loadResultFromAst) || !this.visitor.wasSuccessfulPropagation()) {
                return DefaultTypePropagationResult.failure(this.app, componentLocation, this.retrieveErrors(ast), this.result, this.visitor.getInterruptedChains(), this.expressionLanguageMetadataService);
            }
            ComponentLocation lastNonErrorHandlerOperation = this.lastNonErrorHandlerOperationPerFlow.get(componentLocation.getRootContainerName());
            TypedEventField flowsOutput = this.buildTypedEventField("payload", this.visitor.getLastMetadataType(), lastNonErrorHandlerOperation, old -> false);
            TypedEventField flowsOutputAttr = this.buildTypedEventField("attributes", this.visitor.getLastAttributesType(), lastNonErrorHandlerOperation, old -> false);
            this.result.put(componentLocation, new DefaultTypedChainComponent(componentLocation, Optional.empty(), Optional.empty(), flowsOutput, Optional.empty(), flowsOutputAttr, Collections.emptyMap(), this.getOutputVariables(componentLocation, this.visitor.getLastVariables()), Optional.empty()));
            return DefaultTypePropagationResult.success(this.app, componentLocation, this.result, this.visitor.getInterruptedChains(), this.apikitOutput, this.expressionLanguageMetadataService);
        }

        private boolean loadResultFromAst(ComponentAst ast) {
            if (!this.isComponentWithPropagationResult(ast)) {
                if (CoreUtils.isErrorHandler(ast) && !CoreUtils.retrieveReferencedErrorHandlerName(ast).map(this.analyzeTopLevelElement(this::loadResultFromAst)).orElse(true).booleanValue()) {
                    return false;
                }
                return ast.directChildrenStream().allMatch(this::loadResultFromAst);
            }
            ComponentLocation componentLocation = ast.getLocation();
            MetadataResult<MessageMetadataType> componentResult = this.visitor.getResult(ast.getLocation());
            if (ast.getModel(SourceModel.class).isPresent() && componentResult == null) {
                return true;
            }
            Optional<TypedEventField> inputPayload = this.getInputPayloadField(componentLocation, this.previous);
            Optional<TypedEventField> inputAttributes = this.getInputAttributesField(componentLocation, this.previous);
            Map<String, TypedEventField> inputVars = this.getInputVariables(this.previous, this.visitor.getInputVariables(ast.getLocation()));
            this.previous = ast.getLocation();
            if (CoreUtils.isFlowRef(ast)) {
                Optional<String> flowRefName = CoreUtils.retrieveFlowRefName(ast);
                boolean flowRefOk = flowRefName.map(this.analyzeTopLevelElement(this::loadResultFromAst)).orElse(true);
                this.previous = flowRefName.map(this.lastNonErrorHandlerOperationPerFlow::get).orElse(this.previous);
                if (!flowRefOk) {
                    return false;
                }
            }
            if (ast.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ROUTE) || componentResult != null && componentResult.isSuccess()) {
                ast.directChildrenStream().forEach(this::loadResultFromAst);
            }
            this.result.put(componentLocation, new DefaultTypedChainComponent(componentLocation, TypePropagationResolverUtils.getMetadataDescriptor(ast, Optional.ofNullable(this.updatedModels.getOrDefault(componentLocation, null))), inputPayload, this.getPayloadField(componentLocation), inputAttributes, this.getAttributesField(componentLocation), inputVars, this.getOutputVariables(componentLocation, this.visitor.getOutputVariables(componentLocation)), this.getErrorType(componentLocation)));
            if (!CoreUtils.isOperationWithinErrorHandler(componentLocation)) {
                this.lastNonErrorHandlerOperationPerFlow.put(componentLocation.getRootContainerName(), componentLocation);
            }
            if (CoreUtils.isFlowRef(ast) && !CoreUtils.getTargetParameterValue(ast).isPresent()) {
                this.calculated.get("payload").withValueSetIn(this.previous);
            }
            return true;
        }

        private List<I18nMessage> retrieveErrors(ComponentAst ast) {
            return ast.recursiveStream().filter(this::isComponentWithPropagationResult).filter(componentAst -> !this.visitor.getResult(componentAst.getLocation()).isSuccess()).flatMap(componentAst -> this.visitor.getResult(componentAst.getLocation()).getFailures().stream()).map(metadataFailure -> I18nMessageFactory.createStaticMessage((String)metadataFailure.toString())).collect(Collectors.toList());
        }

        private boolean isComponentWithPropagationResult(ComponentAst ast) {
            return ast.getModel(OperationModel.class).isPresent() || ast.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.ROUTE) || ast.getModel(SourceModel.class).isPresent() && !this.request.getInitialMetadataTypeOverride().isPresent();
        }

        private TypedEventField buildTypedEventField(String bindingName, MetadataType type, ComponentLocation location, Predicate<ComponentLocation> setsBindingEvenIfSameType) {
            TypedEventFieldBuilder builder;
            if (this.calculated.containsKey(bindingName) && this.calculated.get(bindingName).isType(type)) {
                builder = this.calculated.get(bindingName);
                if (this.request.traceMetadataDefinitionLocation() && setsBindingEvenIfSameType.test(builder.getLastSet())) {
                    builder.withValueSetIn(location);
                }
            } else {
                builder = new TypedEventFieldBuilder();
                if (this.request.traceMetadataDefinitionLocation()) {
                    builder.withDeclarationIn(location);
                }
                builder.withMetadataType(type);
                this.calculated.put(bindingName, builder);
            }
            return builder.build();
        }

        private boolean wereInErrorHandlingButNotAnymore(ComponentLocation oldLocation, ComponentLocation newLocation) {
            return CoreUtils.isOperationWithinErrorHandler(oldLocation) && !CoreUtils.isOperationWithinErrorHandler(newLocation);
        }

        private Optional<TypedEventField> getInputPayloadField(ComponentLocation componentLocation, ComponentLocation modifier) {
            return this.visitor.getInput(componentLocation).flatMap(MessageMetadataType::getPayloadType).map(inputMetadata -> this.buildTypedEventField("payload", (MetadataType)inputMetadata, modifier, old -> this.wereInErrorHandlingButNotAnymore((ComponentLocation)old, modifier)));
        }

        private Optional<TypedEventField> getInputAttributesField(ComponentLocation componentLocation, ComponentLocation modifier) {
            return this.visitor.getInput(componentLocation).flatMap(MessageMetadataType::getAttributesType).map(inputMetadata -> this.buildTypedEventField("attributes", (MetadataType)inputMetadata, modifier, old -> this.wereInErrorHandlingButNotAnymore((ComponentLocation)old, modifier)));
        }

        private TypedEventField getPayloadField(ComponentLocation componentLocation) {
            MetadataResult<MessageMetadataType> result = this.visitor.getResult(componentLocation);
            if (result == null || result.get() == null) {
                return null;
            }
            Optional outputMetadata = ((MessageMetadataType)result.get()).getPayloadType();
            if (!outputMetadata.isPresent()) {
                return null;
            }
            return this.buildTypedEventField("payload", (MetadataType)outputMetadata.get(), componentLocation, old -> this.visitor.modifiesBinding(componentLocation, "payload"));
        }

        private TypedEventField getAttributesField(ComponentLocation componentLocation) {
            MetadataResult<MessageMetadataType> result = this.visitor.getResult(componentLocation);
            if (result == null || result.get() == null) {
                return null;
            }
            Optional attrMetadata = ((MessageMetadataType)result.get()).getAttributesType();
            if (!attrMetadata.isPresent()) {
                return null;
            }
            return this.buildTypedEventField("attributes", (MetadataType)attrMetadata.get(), componentLocation, old -> this.visitor.modifiesBinding(componentLocation, "attributes"));
        }

        private Map<String, TypedEventField> getInputVariables(ComponentLocation componentLocation, Map<String, MetadataType> varsMetadata) {
            return this.getVariables(componentLocation, false, varsMetadata);
        }

        private Map<String, TypedEventField> getOutputVariables(ComponentLocation componentLocation, Map<String, MetadataType> varsMetadata) {
            return this.getVariables(componentLocation, true, varsMetadata);
        }

        private Map<String, TypedEventField> getVariables(ComponentLocation componentLocation, boolean isOutput, Map<String, MetadataType> varsMetadata) {
            HashMap<String, TypedEventField> vars = new HashMap<String, TypedEventField>();
            boolean forceLastSet = CoreUtils.isCorePassThroughRouter(componentLocation);
            varsMetadata.forEach((name, type) -> vars.put((String)name, this.buildTypedEventField((String)name, (MetadataType)type, componentLocation, old -> isOutput && (this.visitor.modifiesBinding(componentLocation, (String)name) || forceLastSet))));
            return vars;
        }

        private Optional<TypedEventField> getErrorType(ComponentLocation componentLocation) {
            return this.visitor.getErrorType(componentLocation).map(errorType -> this.buildTypedEventField("error", (MetadataType)errorType, componentLocation, old -> this.visitor.modifiesBinding(componentLocation, "error")));
        }

        private Function<String, Boolean> analyzeTopLevelElement(Predicate<ComponentAst> onTopLevelComponentChild) {
            return topLevelElementName -> {
                if (this.analyzedTopLevelComponents.contains(topLevelElementName)) {
                    return true;
                }
                this.analyzedTopLevelComponents.add((String)topLevelElementName);
                return this.app.topLevelComponentsStream().filter(comp -> comp.getLocation().getLocation().equals(topLevelElementName)).findFirst().map(flow -> flow.directChildrenStream().allMatch(onTopLevelComponentChild)).orElse(true);
            };
        }
    }
}

