/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import com.mulesoft.mule.framework.api.tooling.type.bindings.BindingCondition;
import com.mulesoft.mule.framework.api.tooling.type.bindings.ComponentConditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;

public class ConditionsBuilder {
    private final List<BindingCondition> preconditions = new ArrayList<BindingCondition>();
    private BindingCondition collectionCondition = null;
    private final List<BindingCondition> postconditions = new ArrayList<BindingCondition>();

    public ConditionsBuilder withPreCondition(BindingCondition condition) {
        if (condition.getParameterModel() != null && CoreUtils.isCollectionParameter(condition.getParameterModel())) {
            this.collectionCondition = condition;
        }
        this.preconditions.add(condition);
        return this;
    }

    public ConditionsBuilder withPostCondition(BindingCondition condition) {
        this.postconditions.add(condition);
        return this;
    }

    public Optional<BindingCondition> getCoreCollectionPreCondition() {
        return Optional.ofNullable(this.collectionCondition);
    }

    public ComponentConditions build() {
        return new ComponentConditionsImpl(this.preconditions, this.postconditions);
    }

    private static class ComponentConditionsImpl
    implements ComponentConditions {
        private final List<BindingCondition> preconditions;
        private final List<BindingCondition> postconditions;

        private ComponentConditionsImpl(List<BindingCondition> preconditions, List<BindingCondition> postconditions) {
            this.preconditions = Collections.unmodifiableList(preconditions);
            this.postconditions = Collections.unmodifiableList(postconditions);
        }

        public List<BindingCondition> getPreConditions() {
            return this.preconditions;
        }

        public List<BindingCondition> getPostConditions() {
            return this.postconditions;
        }
    }
}

