/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import com.mulesoft.mule.framework.api.tooling.type.propagation.BaseTypePropagationRequest;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationRequest;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationResult;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypePropagationSession;
import com.mulesoft.mule.framework.api.tooling.type.propagation.TypedEventField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.mule.framework.internal.tooling.type.propagation.DefaultTypePropagationResult;
import org.mule.framework.internal.tooling.type.propagation.cfg.TypePropagationCFGVisitor;
import org.mule.framework.internal.tooling.type.propagation.utils.ApiKitUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.CoreUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.TypePropagationResolverUtils;
import org.mule.framework.internal.tooling.type.propagation.utils.TypingUtils;
import org.mule.framework.internal.util.CloseChecker;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.module.soapkit.metadata.api.Metadata;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeFactory;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

public class CFGTypePropagationSession
implements TypePropagationSession {
    private static final String MUNIT_NAMESPACE = "munit";
    private final CloseChecker closer;
    private final ArtifactAst application;
    private final InternalMuleFramework framework;
    private final ChainExecutionPathTreeFactory cfgFactory;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final TypeOverridesRepository typeOverridesRepository;
    private final Optional<org.mule.runtime.apikit.metadata.api.Metadata> apikitMetadataResolver;
    private final Optional<Metadata> soapkitMetadataResolver;
    private final Set<String> ongoingPropagations = new HashSet<String>();
    private final Map<ComponentLocation, TypePropagationResult> results = new HashMap<ComponentLocation, TypePropagationResult>();

    public CFGTypePropagationSession(InternalMuleFramework framework, ArtifactAst application, TypeOverridesRepository typeOverridesRepository) {
        this.framework = framework;
        this.application = application;
        this.cfgFactory = new ChainExecutionPathTreeFactory(application);
        this.expressionLanguageMetadataService = framework.getExpressionLanguageMetadataService();
        this.typeOverridesRepository = typeOverridesRepository;
        this.apikitMetadataResolver = ApiKitUtils.buildApiKitMetadataResolver(application, framework.getApiKitMetadataService(), framework.getExecutionClassLoader());
        this.soapkitMetadataResolver = ApiKitUtils.buildSoapKitMetadataResolver(application, framework.getExecutionClassLoader());
        this.closer = new CloseChecker("CFGTypePropagationSession", framework);
    }

    private Optional<ComponentAst> componentFromLocation(ComponentLocation location) {
        return this.application.recursiveStream().filter(comp -> comp.getLocation().getLocation().equals(location.getRootContainerName())).findFirst();
    }

    public CompletableFuture<TypePropagationResult> resolveAndPropagateTypes(TypePropagationRequest request) {
        return this.closer.withLifecycleCheck(() -> {
            ComponentLocation location = request.propagationTarget();
            Optional<ComponentAst> componentAst = this.componentFromLocation(location);
            if (!componentAst.isPresent()) {
                return CompletableFuture.completedFuture(DefaultTypePropagationResult.failure(this.application, location, Collections.singletonList(I18nMessageFactory.createStaticMessage((String)String.format("Incorrect location: %s", location.getLocation())))));
            }
            ComponentLocation flowLocation = componentAst.get().getLocation();
            if (this.results.containsKey(flowLocation)) {
                return CompletableFuture.completedFuture(this.results.get(flowLocation));
            }
            this.ongoingPropagations.add(location.getRootContainerName());
            ChainExecutionPathTree tree = this.cfgFactory.generateFor(componentAst.get());
            TypePropagationCFGVisitor visitor = new TypePropagationCFGVisitor(this.framework, this.expressionLanguageMetadataService, flowLocation, this.typeOverridesRepository);
            this.setInitialPayload(request, tree, visitor);
            tree.accept((ChainExecutionPathTreeVisitor)visitor);
            this.ongoingPropagations.remove(location.getRootContainerName());
            TypePropagationResult propagation = TypePropagationResolverUtils.resolve(this.application, componentAst.get(), request, visitor, visitor.getUpdatedModels(), this.expectedOutputForFlow(request), this.expressionLanguageMetadataService);
            this.results.put(flowLocation, propagation);
            return CompletableFuture.completedFuture(propagation);
        });
    }

    private void setInitialPayload(TypePropagationRequest request, ChainExecutionPathTree tree, TypePropagationCFGVisitor visitor) {
        if (request.getInitialMetadataTypeOverride().isPresent()) {
            visitor.initialMessage((MessageMetadataType)request.getInitialMetadataTypeOverride().get());
            return;
        }
        if (request.propagationTarget().getComponentIdentifier().getIdentifier().getNamespace().equals(MUNIT_NAMESPACE)) {
            visitor.initialPayload(TypePropagationCFGVisitor.VOID_TYPE, true);
            return;
        }
        this.apikitMetadataResolver.ifPresent(metadataResolver -> ApiKitUtils.setInitialPayloadOfApiKitFlow(metadataResolver, request.propagationTarget().getRootContainerName(), visitor));
        this.soapkitMetadataResolver.ifPresent(metadataResolver -> ApiKitUtils.setInitialPayloadOfSoapKitFlow(metadataResolver, request.propagationTarget().getRootContainerName(), visitor));
        String flowName = request.propagationTarget().getRootContainerName();
        Set<ComponentLocation> flowsRefsToFlowOfInterest = this.application.recursiveStream().filter(CoreUtils::isFlowRef).filter(flowRef -> CoreUtils.retrieveFlowRefName(flowRef).map(referenced -> referenced.equals(flowName)).orElse(false)).map(ComponentAst::getLocation).filter(location -> !this.ongoingPropagations.contains(location.getRootContainerName())).collect(Collectors.toSet());
        if (flowsRefsToFlowOfInterest.isEmpty()) {
            return;
        }
        LinkedHashSet<MetadataType> payloadTypes = new LinkedHashSet<MetadataType>();
        LinkedHashSet<MetadataType> attributesTypes = new LinkedHashSet<MetadataType>();
        flowsRefsToFlowOfInterest.forEach(flowRef -> {
            try {
                Optional flowRefResult = this.resolveAndPropagateTypes((TypePropagationRequest)new BaseTypePropagationRequest(flowRef)).get().getTypedComponent(flowRef);
                flowRefResult.ifPresent(result -> {
                    result.getInputPayloadType().map(TypedEventField::getType).ifPresent(payloadTypes::add);
                    result.getInputAttributesType().map(TypedEventField::getType).ifPresent(attributesTypes::add);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (!payloadTypes.isEmpty()) {
            visitor.initialPayload(TypingUtils.toSingleMetadataType(payloadTypes), false);
        }
        if (!attributesTypes.isEmpty()) {
            visitor.initialAttributes(TypingUtils.toSingleMetadataType(attributesTypes), false);
        }
    }

    private Optional<MuleEventMetadataType> expectedOutputForFlow(TypePropagationRequest request) {
        String flow = request.propagationTarget().getRootContainerName();
        Optional<Object> expectation = this.apikitMetadataResolver.flatMap(resolver -> ApiKitUtils.apiKitFlowReturnType(resolver, flow));
        if (!expectation.isPresent()) {
            expectation = this.soapkitMetadataResolver.flatMap(resolver -> ApiKitUtils.soapKitFlowReturnType(resolver, flow));
        }
        return expectation;
    }

    public void close() {
        this.closer.close();
    }
}

