/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.override.declarations.model;

import java.util.Map;
import java.util.Optional;
import org.mule.framework.internal.tooling.type.override.declarations.model.TypeOverrideDeclarationBuilder;
import org.mule.metadata.api.model.MetadataType;

public class TypeOverrideDeclaration {
    private final Map<String, MetadataType> inputVariableTypes;
    private final MetadataType inputPayloadType;
    private final MetadataType inputAttributesType;
    private final Map<String, MetadataType> outputVariableTypes;
    private final MetadataType outputPayloadType;
    private final MetadataType outputAttributesType;
    private final Map<String, MetadataType> parameterTypes;
    private final MetadataType returnPayloadType;
    private final MetadataType returnAttributesType;

    public static TypeOverrideDeclarationBuilder builder() {
        return new TypeOverrideDeclarationBuilder();
    }

    public TypeOverrideDeclaration(Map<String, MetadataType> inputVariableTypes, MetadataType inputPayloadType, MetadataType inputAttributesType, Map<String, MetadataType> outputVariableTypes, MetadataType outputPayloadType, MetadataType outputAttributesType, Map<String, MetadataType> parameterTypes, MetadataType returnPayloadType, MetadataType returnAttributesType) {
        this.inputVariableTypes = inputVariableTypes;
        this.inputPayloadType = inputPayloadType;
        this.inputAttributesType = inputAttributesType;
        this.outputVariableTypes = outputVariableTypes;
        this.outputPayloadType = outputPayloadType;
        this.outputAttributesType = outputAttributesType;
        this.parameterTypes = parameterTypes;
        this.returnPayloadType = returnPayloadType;
        this.returnAttributesType = returnAttributesType;
    }

    public Optional<MetadataType> getInputVariableType(String variableName) {
        return Optional.ofNullable(this.inputVariableTypes.get(variableName));
    }

    public Optional<MetadataType> getInputPayloadType() {
        return Optional.ofNullable(this.inputPayloadType);
    }

    public Optional<MetadataType> getInputAttributesType() {
        return Optional.ofNullable(this.inputAttributesType);
    }

    public Optional<MetadataType> getOutputVariableType(String variableName) {
        return Optional.ofNullable(this.outputVariableTypes.get(variableName));
    }

    public Optional<MetadataType> getOutputPayloadType() {
        return Optional.ofNullable(this.outputPayloadType);
    }

    public Optional<MetadataType> getOutputAttributesType() {
        return Optional.ofNullable(this.outputAttributesType);
    }

    public Optional<MetadataType> getParameterType(String parameterName) {
        return Optional.ofNullable(this.parameterTypes.get(parameterName));
    }

    public Optional<MetadataType> getReturnPayloadType() {
        return Optional.ofNullable(this.returnPayloadType);
    }

    public Optional<MetadataType> getReturnAttributesType() {
        return Optional.ofNullable(this.returnAttributesType);
    }

    public Map<String, MetadataType> getParameterTypes() {
        return this.parameterTypes;
    }

    public Map<String, MetadataType> getInputVariables() {
        return this.inputVariableTypes;
    }

    public Map<String, MetadataType> getOutputVariables() {
        return this.outputVariableTypes;
    }
}

