/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;
import org.mule.metadata.api.model.MetadataType;

public class TypesCatalog
implements TypeResolver {
    private final List<TypeResolver> typeResolvers;

    public TypesCatalog(List<TypeResolver> typeResolvers) {
        Objects.requireNonNull(typeResolvers, "typeResolvers");
        this.typeResolvers = typeResolvers;
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
        try {
            for (TypeResolver resolver : this.typeResolvers) {
                Optional<MetadataType> metadataType = resolver.resolveType(typeIdentifier);
                if (!metadataType.isPresent()) continue;
                return metadataType;
            }
            return Optional.empty();
        }
        catch (TypeResolverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeResolverException("Exception while resolving a type", e);
        }
    }
}

