/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.catalog.builder;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.mule.framework.internal.tooling.type.catalog.builder.TypesCatalogBuilderContext;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.ExampleTypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.ShapeTypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.SingleTypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolver;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.TypeResolverException;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.TypeLoaderFactory;
import org.mule.framework.internal.tooling.type.catalog.model.resolver.loaders.TypeLoaderRegistry;
import org.mule.metadata.api.TypeLoader;

public class TypesResolverBuilder {
    private final URI baseUri;
    private String name;
    private String shapeFormat;
    private String shapeLocation;
    private String shapeContent;
    private String exampleFormat;
    private String exampleLocation;
    private String exampleContent;
    private String format;
    private String shapeElement;
    private String exampleElement;

    public TypesResolverBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void name(String name) {
        this.name = name;
    }

    public void format(String format) {
        this.format = format;
    }

    public void shapeFormat(String shapeFormat) {
        this.shapeFormat = shapeFormat;
    }

    public void shapeLocation(String shapeLocation) {
        this.shapeLocation = shapeLocation;
    }

    public void shapeContent(String shapeContent) {
        this.shapeContent = shapeContent;
    }

    public void shapeElement(String shapeElement) {
        this.shapeElement = shapeElement;
    }

    public void exampleFormat(String exampleFormat) {
        this.exampleFormat = exampleFormat;
    }

    public void exampleLocation(String exampleLocation) {
        this.exampleLocation = exampleLocation;
    }

    public void exampleElement(String exampleElement) {
        this.exampleElement = exampleElement;
    }

    public void exampleContent(String exampleContent) {
        this.exampleContent = exampleContent;
    }

    private static URI resolveURI(String location, URI baseUri) throws URISyntaxException {
        URI locationURI = new URI(null, null, location, null, null);
        return baseUri != null ? baseUri.resolve(locationURI) : locationURI;
    }

    private String findTypeName(String name, String nativeName) {
        return nativeName != null ? nativeName : name;
    }

    private static TypeLoaderFactory getTypeLoaderFactory(String typeFormat, String loaderFormat, TypeLoaderRegistry typeLoaderRegistry) throws TypeResolverException {
        return typeLoaderRegistry.getFactory(typeFormat, loaderFormat).orElseThrow(() -> new TypeResolverException(String.format("Unsupported typeFormat %s loaderFormat %s", typeFormat, loaderFormat)));
    }

    private static TypeLoader createTypeLoader(String location, String content, TypeLoaderFactory typeLoaderFactory, URI baseUri) throws URISyntaxException, MalformedURLException {
        if (location == null) {
            return typeLoaderFactory.createTypeLoader(content);
        }
        return typeLoaderFactory.createTypeLoader(FileUtils.toFile((URL)TypesResolverBuilder.resolveURI(location, baseUri).toURL()));
    }

    public TypeResolver build(TypesCatalogBuilderContext typesCatalogBuilderContext) throws TypeResolverException {
        try {
            if (this.shapeFormat != null) {
                TypeLoaderFactory typeLoaderFactory = TypesResolverBuilder.getTypeLoaderFactory(this.format, this.shapeFormat, typesCatalogBuilderContext.getTypeLoaderRegistry());
                TypeLoader typeLoader = TypesResolverBuilder.createTypeLoader(this.shapeLocation, this.shapeContent, typeLoaderFactory, this.baseUri);
                return new SingleTypeResolver(this.name, new ShapeTypeResolver(this.findTypeName(this.name, this.shapeElement), typeLoader));
            }
            if (this.exampleFormat != null) {
                TypeLoaderFactory typeLoaderFactory = TypesResolverBuilder.getTypeLoaderFactory(this.format, this.exampleFormat, typesCatalogBuilderContext.getTypeLoaderRegistry());
                TypeLoader typeLoader = TypesResolverBuilder.createTypeLoader(this.exampleLocation, this.exampleContent, typeLoaderFactory, this.baseUri);
                return new SingleTypeResolver(this.name, new ExampleTypeResolver(this.exampleElement, typeLoader));
            }
        }
        catch (Exception exception) {
            throw new TypeResolverException("Exception while building a type resolver", exception);
        }
        throw new TypeResolverException("Resolver for type " + this.name + " can't be created because it doesn't have shape nor example format");
    }
}

