/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.icon;

import com.mulesoft.mule.framework.api.tooling.icon.IconService;
import com.mulesoft.mule.framework.api.tooling.icon.IconsResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.framework.internal.tooling.icon.IconResultBuilder;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;

public class DietIconServiceImpl
implements IconService {
    private static final String SVG = ".svg";

    public IconsResult getIconsFor(BundleDependency bundleDependency) {
        IconsResult iconsResult;
        URI bundleUri = bundleDependency.getBundleUri();
        IconResultBuilder iconResultBuilder = new IconResultBuilder();
        ZipFile file = new ZipFile(new File(bundleUri));
        try {
            file.stream().filter(entry -> entry.getName().startsWith("META-INF/mule-artifact") && entry.getName().toLowerCase().endsWith(SVG)).forEach(icon -> {
                try {
                    String iconName = Paths.get(icon.getName(), new String[0]).getFileName().toString().substring(0, SVG.length());
                    if (iconName.equals("icon")) {
                        iconResultBuilder.withIcon(IOUtils.toByteArray((InputStream)file.getInputStream((ZipEntry)icon)));
                    } else {
                        iconResultBuilder.withAdditionalIcon(iconName, IOUtils.toByteArray((InputStream)file.getInputStream((ZipEntry)icon)));
                    }
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unable to retrieve icons.", (Object[])new Object[]{e}));
                }
            });
            iconsResult = iconResultBuilder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unable to retrieve icons.", (Object[])new Object[]{e}));
            }
        }
        file.close();
        return iconsResult;
    }
}

