/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.connection.fluent;

import com.mulesoft.mule.framework.api.extension.connection.fluent.PoolingProfileConfigurer;
import org.mule.runtime.api.config.PoolingProfile;

class DietPoolingProfile
implements PoolingProfileConfigurer {
    private int maxActive = 5;
    private int maxIdle = 5;
    private long maxWait = 4000L;
    private int minEvictionMillis = 1800000;
    private int evictionCheckIntervalMillis = -1;
    private PoolingProfileConfigurer.InitialisationPolicy initialisationPolicy = PoolingProfileConfigurer.InitialisationPolicy.INITIALISE_ONE;
    private PoolingProfileConfigurer.ExhaustedAction exhaustedAction = PoolingProfileConfigurer.ExhaustedAction.WHEN_EXHAUSTED_GROW;

    DietPoolingProfile() {
    }

    PoolingProfile toPoolingProfile() {
        PoolingProfile pp = new PoolingProfile(this.maxActive, this.maxIdle, this.maxWait, this.exhaustedActionAsInt(), this.initialisationPolicyAsInt());
        pp.setMinEvictionMillis(this.minEvictionMillis);
        pp.setEvictionCheckIntervalMillis(this.evictionCheckIntervalMillis);
        return pp;
    }

    private int exhaustedActionAsInt() {
        switch (this.exhaustedAction) {
            case WHEN_EXHAUSTED_GROW: {
                return 2;
            }
            case WHEN_EXHAUSTED_FAIL: {
                return 0;
            }
            case WHEN_EXHAUSTED_WAIT: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported ExhaustedAction: " + this.exhaustedAction);
    }

    private int initialisationPolicyAsInt() {
        switch (this.initialisationPolicy) {
            case INITIALISE_ONE: {
                return 1;
            }
            case INITIALISE_NONE: {
                return 0;
            }
            case INITIALISE_ALL: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unsupported InitialisationPolicy: " + this.initialisationPolicy);
    }

    public PoolingProfileConfigurer maxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public PoolingProfileConfigurer maxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public PoolingProfileConfigurer initialisationPolicy(PoolingProfileConfigurer.InitialisationPolicy initialisationPolicy) {
        this.initialisationPolicy = initialisationPolicy;
        return this;
    }

    public PoolingProfileConfigurer exhaustedAction(PoolingProfileConfigurer.ExhaustedAction exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
        return this;
    }

    public PoolingProfileConfigurer maxWait(long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public PoolingProfileConfigurer minEvictionMillis(int evictionMillis) {
        this.minEvictionMillis = evictionMillis;
        return this;
    }

    public PoolingProfileConfigurer evictionCheckIntervalMillis(int intervalMillis) {
        this.evictionCheckIntervalMillis = intervalMillis;
        return this;
    }
}

