/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.connection.fluent;

import com.mulesoft.mule.framework.api.extension.connection.fluent.AuthorizationCodeOAuthConfigurer;
import com.mulesoft.mule.framework.api.extension.connection.fluent.ClientCredentialsOAuthConfigurer;
import com.mulesoft.mule.framework.api.extension.connection.fluent.PlatformManagedOAuthConfigurer;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.store.ObjectStore;

abstract class DietOAuthParameterizer {
    DietOAuthParameterizer() {
    }

    public abstract void configure(ComponentParameterization.Builder var1);

    protected void addObjectStore(ComponentParameterization.Builder parameters, ObjectStore objectStore) {
        if (objectStore != null) {
            parameters.withParameter("objectStore", (Object)objectStore);
        }
    }

    protected void addScopes(ComponentParameterization.Builder parameters, String parameterGroup, String[] scopes) {
        if (scopes != null && scopes.length > 0) {
            this.setIfNotNull(parameters, parameterGroup, "scopes", Arrays.stream(scopes).map(String::trim).collect(Collectors.joining(", ")));
        }
    }

    protected void setIfNotNull(ComponentParameterization.Builder parameters, String parameterGroup, String parameterName, Object value) {
        if (value != null) {
            parameters.withParameter(parameterGroup, parameterName, value);
        }
    }

    static class DietPlatformManagerOAuthConfigurer
    extends DietOAuthParameterizer
    implements PlatformManagedOAuthConfigurer {
        private String connectionId;

        DietPlatformManagerOAuthConfigurer() {
        }

        public PlatformManagedOAuthConfigurer connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @Override
        public void configure(ComponentParameterization.Builder parameters) {
            parameters.withParameter("connectionId", (Object)this.connectionId);
        }
    }

    static class DietClientCredentialsOAuthConfigurer
    extends DietOAuthParameterizer
    implements ClientCredentialsOAuthConfigurer {
        private String clientId;
        private String clientSecret;
        private String tokenUrl;
        private String[] scopes;
        private ObjectStore objectStore;

        DietClientCredentialsOAuthConfigurer() {
        }

        @Override
        public void configure(ComponentParameterization.Builder parameters) {
            this.setIfNotNull(parameters, "oauthClientCredentials", "clientId", this.clientId);
            this.setIfNotNull(parameters, "oauthClientCredentials", "clientSecret", this.clientSecret);
            this.setIfNotNull(parameters, "oauthClientCredentials", "tokenUrl", this.tokenUrl);
            this.addScopes(parameters, "oauthClientCredentials", this.scopes);
            this.addObjectStore(parameters, this.objectStore);
        }

        public ClientCredentialsOAuthConfigurer credentials(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        public ClientCredentialsOAuthConfigurer tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public ClientCredentialsOAuthConfigurer scopes(String ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public ClientCredentialsOAuthConfigurer objectStore(ObjectStore objectStore) {
            this.objectStore = objectStore;
            return this;
        }
    }

    static class DietAuthorizationCodeOAuthConfigurer
    extends DietOAuthParameterizer
    implements AuthorizationCodeOAuthConfigurer {
        private String consumerKey;
        private String consumerSecret;
        private String authorizationUrl;
        private String accessTokenUrl;
        private String[] scopes;
        private String resourceOwnerId;
        private String httpListenerConfigRef;
        private String callbackPath;
        private String authorizePath;
        private String externalCallbackPath;
        private ObjectStore objectStore;

        DietAuthorizationCodeOAuthConfigurer() {
        }

        @Override
        public void configure(ComponentParameterization.Builder componentParameterization) {
            this.addAuthorizationCodeParameters(componentParameterization);
            this.addCallbackParameters(componentParameterization);
            this.addObjectStore(componentParameterization, this.objectStore);
        }

        private void addAuthorizationCodeParameters(ComponentParameterization.Builder parameters) {
            this.setIfNotNull(parameters, "oauthAuthorizationCode", "consumerKey", this.consumerKey);
            this.setIfNotNull(parameters, "oauthAuthorizationCode", "consumerSecret", this.consumerSecret);
            this.setIfNotNull(parameters, "oauthAuthorizationCode", "authorizationUrl", this.authorizationUrl);
            this.setIfNotNull(parameters, "oauthAuthorizationCode", "accessTokenUrl", this.accessTokenUrl);
            this.addScopes(parameters, "oauthAuthorizationCode", this.scopes);
            this.setIfNotNull(parameters, "oauthAuthorizationCode", "resourceOwnerId", this.resourceOwnerId);
        }

        private void addCallbackParameters(ComponentParameterization.Builder parameters) {
            this.setIfNotNull(parameters, "oauthCallbackConfig", "listenerConfig", this.httpListenerConfigRef);
            this.setIfNotNull(parameters, "oauthCallbackConfig", "callbackPath", this.callbackPath);
            this.setIfNotNull(parameters, "oauthCallbackConfig", "authorizePath", this.authorizePath);
            this.setIfNotNull(parameters, "oauthCallbackConfig", "externalCallbackUrl", this.externalCallbackPath);
        }

        public AuthorizationCodeOAuthConfigurer credentials(String consumerKey, String consumerSecret) {
            this.consumerKey = consumerKey;
            this.consumerSecret = consumerSecret;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer authorizationUrl(String url) {
            this.authorizationUrl = url;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer accessTokenUrl(String url) {
            this.accessTokenUrl = url;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer scopes(String ... scopes) {
            this.scopes = scopes;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer httpListenerRef(String httpListenerConfigRef) {
            this.httpListenerConfigRef = httpListenerConfigRef;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer callbackPath(String callbackPath) {
            this.callbackPath = callbackPath;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer authorizePath(String authorizePath) {
            this.authorizePath = authorizePath;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer externalCallbackPath(String externalCallbackPath) {
            this.externalCallbackPath = externalCallbackPath;
            return this;
        }

        public AuthorizationCodeOAuthConfigurer objectStore(ObjectStore objectStore) {
            this.objectStore = objectStore;
            return this;
        }
    }
}

