/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.config.fluent;

import com.mulesoft.mule.framework.api.extension.config.fluent.ConfigurationCreationCommand;
import com.mulesoft.mule.framework.api.extension.connection.fluent.ConnectionConfigurer;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.connection.fluent.DietConnectionConfigurer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ConnectionProviderValueResolver;

public class DietConfigurationCreationCommand
implements ConfigurationCreationCommand {
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    private final ComponentParameterization.Builder<ConfigurationModel> delegateBuilder;
    private final LazyValue<ComponentParameterization<ConfigurationModel>> componentParameterization;
    private final InternalMuleFramework muleFramework;
    private String name;
    private DietConnectionConfigurer connection;

    public DietConfigurationCreationCommand(ExtensionModel extensionModel, ConfigurationModel configurationModel, InternalMuleFramework muleFramework) {
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
        this.muleFramework = muleFramework;
        this.delegateBuilder = ComponentParameterization.builder((ParameterizedModel)configurationModel);
        this.componentParameterization = new LazyValue(() -> this.delegateBuilder.build());
    }

    public ConfigurationCreationCommand name(String name) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)name) ? 1 : 0) != 0, (String)"name cannot be blank");
        this.name = name;
        return this;
    }

    public ConfigurationCreationCommand withParameter(String parameter, Object value) {
        this.delegateBuilder.withParameter(parameter, value);
        return this;
    }

    public ConfigurationCreationCommand withParameter(String parameterGroup, String parameter, Object value) {
        this.delegateBuilder.withParameter(parameterGroup, parameter, value);
        return this;
    }

    public ConnectionConfigurer connectingThrough(String connectionProviderName) {
        this.connection = this.getConnectionProvider((HasConnectionProviderModels)this.configurationModel, connectionProviderName).map(cp -> new DietConnectionConfigurer(this.extensionModel, (ConnectionProviderModel)cp, this.muleFramework)).orElseGet(() -> this.getConnectionProvider((HasConnectionProviderModels)this.extensionModel, connectionProviderName).map(extensionConnectionProvider -> new DietConnectionConfigurer(this.extensionModel, (ConnectionProviderModel)extensionConnectionProvider, this.muleFramework)).orElseThrow(() -> new NoSuchElementException(String.format("Configuration does not contain a ConnectionProvider named '%s'", connectionProviderName))));
        return this.connection;
    }

    public ConnectionConfigurer connectingThrough(ConnectionProviderModel connectionProviderModel) {
        this.connection = this.getConnectionProvider((HasConnectionProviderModels)this.configurationModel, connectionProviderModel).map(cp -> new DietConnectionConfigurer(this.extensionModel, (ConnectionProviderModel)cp, this.muleFramework)).orElseGet(() -> this.getConnectionProvider((HasConnectionProviderModels)this.extensionModel, connectionProviderModel).map(extensionConnectionProvider -> new DietConnectionConfigurer(this.extensionModel, (ConnectionProviderModel)extensionConnectionProvider, this.muleFramework)).orElseThrow(() -> new IllegalArgumentException("the supplied ConnectionProviderModel is not a part of this ConfigurationModel")));
        return this.connection;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    public ConfigurationModel getConfigurationModel() {
        return this.configurationModel;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ((ComponentParameterization)this.componentParameterization.get()).forEachParameter((group, param, value) -> params.put(param.getName(), value));
        return params;
    }

    public ComponentParameterization<ConfigurationModel> getConfigurationParameterization() {
        return (ComponentParameterization)this.componentParameterization.get();
    }

    public ComponentParameterization<ConnectionProviderModel> getConnectionParameterization() {
        return this.connection.collectParameters();
    }

    public Optional<ConnectionProviderValueResolver> getConnectionProviderResolver() {
        try {
            return this.connection != null ? Optional.of(this.connection.asValueResolver()) : Optional.empty();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create ConnectionProvider resolver: " + e.getMessage())), (Throwable)e);
        }
    }

    private Optional<ConnectionProviderModel> getConnectionProvider(HasConnectionProviderModels model, String connectionProviderName) {
        return model.getConnectionProviderModel(connectionProviderName);
    }

    private Optional<ConnectionProviderModel> getConnectionProvider(HasConnectionProviderModels model, ConnectionProviderModel connectionProviderModel) {
        return model.getConnectionProviders().stream().filter(extensionConnectionProvider -> extensionConnectionProvider == connectionProviderModel).findFirst();
    }
}

