/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.extension.config;

import java.util.Optional;
import org.mule.framework.internal.extension.config.fluent.DietConfigurationCreationCommand;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;

public class ConfigCreationWorkaroundUtils {
    public static ConfigurationProvider createConfigurationProvider(ExtensionModel extensionModel, DietConfigurationCreationCommand request, ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, MuleContext muleContext, ConfigurationProviderFactory configurationProviderFactory, DslSyntaxResolver dslSyntaxResolver, ClassLoader extensionClassLoader) {
        if (!request.getConnectionProviderResolver().isPresent() && ConfigCreationWorkaroundUtils.hasImplicitConnectionProvider(request.getConfigurationModel())) {
            return extensionDesignTimeResolversFactory.createConfigurationProvider(extensionModel, request.getConfigurationModel(), request.getName(), request.getParameters(), Optional.empty(), request.getConnectionProviderResolver(), configurationProviderFactory, "", dslSyntaxResolver, extensionClassLoader);
        }
        return ConfigCreationWorkaroundUtils.createConfigurationProvider(extensionModel, request.getConfigurationModel(), request.getName(), request.getConfigurationParameterization(), request.getConnectionProviderResolver(), extensionDesignTimeResolversFactory, muleContext, configurationProviderFactory, extensionClassLoader);
    }

    private static boolean hasImplicitConnectionProvider(ConfigurationModel configurationModel) {
        return configurationModel.getConnectionProviders().stream().anyMatch(ExtensionModelUtils::canBeUsedImplicitly);
    }

    private static ConfigurationProvider createConfigurationProvider(ExtensionModel extensionModel, ConfigurationModel configurationModel, String configName, ComponentParameterization<?> componentParameterization, Optional<ConnectionProviderValueResolver> connectionProviderResolver, ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, MuleContext muleContext, ConfigurationProviderFactory configurationProviderFactory, ClassLoader extensionClassLoader) {
        return (ConfigurationProvider)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
            ConfigurationProvider configurationProvider;
            ParameterValueResolver parameterValueResolver = extensionDesignTimeResolversFactory.createParameterValueResolver(componentParameterization, (ParameterizedModel)configurationModel);
            ResolverSet resolverSet = new ResolverSet(muleContext);
            resolverSet.addAll(parameterValueResolver.getParameters());
            ConnectionProviderValueResolver connectionResolver = connectionProviderResolver.orElseGet(() -> {
                if (ExtensionModelUtils.supportsConnectivity((ExtensionModel)extensionModel, (ConfigurationModel)configurationModel)) {
                    throw new IllegalStateException(String.format("Configuration '%s' of extension '%s' does not define a connection provider and none can be created automatically. Please define one.", configurationModel.getName(), extensionModel.getName()));
                }
                return new NullConnectionProviderResolver();
            });
            connectionResolver.getResolverSet().ifPresent(resolver -> LifecycleUtils.initialiseIfNeeded((Object)resolver, (MuleContext)muleContext));
            try {
                configurationProvider = resolverSet.isDynamic() || connectionResolver.isDynamic() ? configurationProviderFactory.createDynamicConfigurationProvider(configName, extensionModel, configurationModel, resolverSet, connectionResolver, muleContext.getConfiguration().getDynamicConfigExpiration().getExpirationPolicy()) : configurationProviderFactory.createStaticConfigurationProvider(configName, extensionModel, configurationModel, resolverSet, connectionResolver);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create an implicit configuration '%s' for the extension '%s'", configurationModel.getName(), extensionModel.getName())), (Throwable)e);
            }
            return configurationProvider;
        });
    }

    private ConfigCreationWorkaroundUtils() {
    }

    private static class NullConnectionProviderResolver<C>
    implements ConnectionProviderValueResolver<C> {
        private NullConnectionProviderResolver() {
        }

        public Pair<ConnectionProvider<C>, ResolverSetResult> resolve(ValueResolvingContext context) {
            return new Pair(null, null);
        }

        public boolean isDynamic() {
            return false;
        }

        public Optional<ResolverSet> getResolverSet() {
            return Optional.empty();
        }
    }
}

