/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.configurations;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.framework.internal.DietMuleFrameworkConfigurations;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationsRefreshHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationsRefreshHandler.class);
    private final DietMuleFrameworkConfigurations baseMuleFrameworkConfigsManager;
    private final Supplier<Stream<ComponentAst>> configAsts;
    private final FrameworkDeployableArtifact refreshedFrameworkDeployableArtifact;

    public ConfigurationsRefreshHandler(DietMuleFrameworkConfigurations baseMuleFrameworkConfigsManager, Supplier<Stream<ComponentAst>> configAsts, FrameworkDeployableArtifact refreshedFrameworkDeployableArtifact) {
        this.baseMuleFrameworkConfigsManager = baseMuleFrameworkConfigsManager;
        this.configAsts = configAsts;
        this.refreshedFrameworkDeployableArtifact = refreshedFrameworkDeployableArtifact;
    }

    public void refreshConfigs() {
        Map refreshedFwkConfigs = this.refreshedFrameworkDeployableArtifact.getConfigurationsAsts().map(refreshedConfigs -> refreshedConfigs.stream().filter(c -> c.getComponentId().isPresent()).collect(Collectors.toMap(c -> (String)c.getComponentId().get(), UnaryOperator.identity()))).orElse(Collections.emptyMap());
        this.forEachConfigAstsCreatedBeforeRefresh(this.configAsts.get(), baseConfig -> {
            String configName = (String)baseConfig.getComponentId().get();
            ComponentAst refreshedConfig = (ComponentAst)refreshedFwkConfigs.get(configName);
            this.disposeConfigIfOutdated(configName, (ComponentAst)baseConfig, refreshedConfig);
            this.forEachConfigAstsCreatedBeforeRefresh(this.baseMuleFrameworkConfigsManager.getArtifactAstDependencyGraph().getRequiredComponents(configName).stream(), baseConfigDependency -> this.disposeConfigIfOutdated(configName, (ComponentAst)baseConfigDependency, refreshedConfig));
        });
    }

    private void forEachConfigAstsCreatedBeforeRefresh(Stream<ComponentAst> configAsts, Consumer<ComponentAst> action) {
        configAsts.filter(baseConfig -> baseConfig.getComponentId().map(this.baseMuleFrameworkConfigsManager::isConfigCreated).orElse(false)).forEach(action);
    }

    private void disposeConfigIfOutdated(String configName, ComponentAst baseConfigDependency, ComponentAst refreshedConfig) {
        if (refreshedConfig == null || !MuleAstUtils.areComponentsEquals((ComponentAst)baseConfigDependency, (ComponentAst)refreshedConfig)) {
            LOGGER.info("Disposing config `{}` that was removed/modified in the refresh.", (Object)configName);
            this.baseMuleFrameworkConfigsManager.disposeConfig(configName);
        } else {
            LOGGER.debug("Config `{}` was NOT removed/modified in the refresh, keeping it.", (Object)configName);
        }
    }
}

