/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder;

import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.ServiceConfigurer;
import com.mulesoft.mule.framework.api.builder.FrameworkApplicationConfigurer;
import com.mulesoft.mule.framework.api.builder.FrameworkDeployableArtifactConfigurer;
import com.mulesoft.mule.framework.api.builder.FrameworkDomainConfigurer;
import com.mulesoft.mule.framework.api.builder.FrameworkRefreshConfigurer;
import com.mulesoft.mule.framework.api.builder.PluginBuilder;
import com.mulesoft.mule.framework.api.connectivity.OCSConfigurer;
import com.mulesoft.mule.framework.api.dependency.DependencyResolver;
import com.mulesoft.mule.framework.api.exception.FrameworkBuildException;
import com.mulesoft.mule.framework.api.tooling.type.resolution.MetadataStorage;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.framework.internal.DietMuleFramework;
import org.mule.framework.internal.DietMuleFrameworkConfigurations;
import org.mule.framework.internal.DietMuleFrameworkStaticAnalysis;
import org.mule.framework.internal.DietMuleFrameworkTooling;
import org.mule.framework.internal.DietMuleFrameworkWithExtensionModels;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromPackagedProjectConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromPluginsConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplicationFromProjectSourcesConfigurer;
import org.mule.framework.internal.builder.application.FrameworkApplicationRefreshConfigurer;
import org.mule.framework.internal.builder.application.InternalFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.artifact.DefaultFrameworkRefreshConfigurer;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.configurations.ConfigurationsRefreshHandler;
import org.mule.framework.internal.builder.domain.AbstractFrameworkDomainConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.framework.internal.builder.domain.FrameworkDomainFromPackagedProjectConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomainFromProjectSourcesConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomainRefreshConfigurer;
import org.mule.framework.internal.builder.domain.InternalFrameworkDomainConfigurer;
import org.mule.framework.internal.builder.service.MuleFrameworkServiceConfigurerBuilder;
import org.mule.framework.internal.context.MuleFrameworkContextFactory;
import org.mule.framework.internal.dependency.LocalDependencyResolver;
import org.mule.framework.internal.service.ConfigurationPropertiesDelegator;
import org.mule.framework.internal.tooling.type.resolution.NullMetadataStorage;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactoryProvider;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.tools.api.classloader.AppClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DietMuleFrameworkBuilder
implements MuleFramework.Builder,
MuleFramework.BaseMuleFrameworkBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DietMuleFrameworkBuilder.class);
    private static final String ADD_ANNOTATIONS_TO_CONFIG_CLASS = "EXTENSION_LOADER_ADD_ANNOTATIONS_TO_CONFIG_CLASS";
    private static final MetadataStorage DEFAULT_METADATA_CACHE = new NullMetadataStorage();
    private static final MuleFramework.UsageMode DEFAULT_USAGE_MODE = MuleFramework.UsageMode.TOOLING;
    private final ArtifactClassLoader containerClassLoader;
    private final ArtifactClassLoaderResolver classLoaderResolver;
    private final MuleVersion muleVersion;
    private final List<URL> muleServices;
    private MavenConfiguration mavenConfiguration = null;
    private final Supplier<DependencyResolver> DEFAULT_DEPENDENCY_RESOLVER = new LazyValue(() -> this.mavenConfiguration != null ? DependencyResolver.defaultDependencyResolver((MavenConfiguration)this.mavenConfiguration) : DependencyResolver.defaultDependencyResolver());
    private Supplier<DependencyResolver> dependencyResolver = this.DEFAULT_DEPENDENCY_RESOLVER;
    private OCSConfigurer ocsConfigurer;
    private MuleFrameworkServiceConfigurerBuilder servicesConfigurerBuilder;
    private MetadataStorage metadataCache = DEFAULT_METADATA_CACHE;
    private final Map<String, Object> customParameters = new HashMap<String, Object>();
    private InternalFrameworkApplicationConfigurer frameworkApplicationConfigurer;
    private InternalFrameworkDomainConfigurer frameworkDomainConfigurer;
    private MuleFramework.UsageMode usageMode = DEFAULT_USAGE_MODE;
    private InternalMuleFramework baseMuleFramework;

    public DietMuleFrameworkBuilder(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderResolver classLoaderResolver, MuleVersion muleVersion, List<URL> muleServices, DependencyResolver dependencyResolver) {
        this.containerClassLoader = containerClassLoader;
        this.classLoaderResolver = classLoaderResolver;
        this.muleVersion = muleVersion;
        this.muleServices = muleServices;
        if (dependencyResolver != null) {
            this.dependencyResolver = () -> dependencyResolver;
        }
    }

    public MuleFramework.Builder fromApplicationProject(Path applicationPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromApplicationProject(applicationPath, applicationConfigurer -> {});
    }

    public MuleFramework.Builder fromApplicationProject(Path applicationPath, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        if (applicationPath == null) {
            throw new IllegalArgumentException("'applicationPath' cannot be null");
        }
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromProjectSourcesConfigurer(applicationPath));
        return this;
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedApplication(packagedApplicationPath, applicationConfigurer -> {});
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedApplication(packagedApplicationPath, applicationConfigurerConsumer, false);
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedApplication(packagedApplicationPath, applicationConfigurer -> {}, forceConfigsParse);
    }

    public MuleFramework.Builder fromPackagedApplication(Path packagedApplicationPath, Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        if (packagedApplicationPath == null) {
            throw new IllegalArgumentException("'packagedApplicationPath' cannot be null");
        }
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromPackagedProjectConfigurer(packagedApplicationPath, forceConfigsParse));
        return this;
    }

    public MuleFramework.Builder fromDomainProject(Path domainPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromDomainProject(domainPath, domainConfigurer -> {});
    }

    public MuleFramework.Builder fromDomainProject(Path domainPath, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        if (domainPath == null) {
            throw new IllegalArgumentException("'domainPath' cannot be null");
        }
        this.configureDomain(domainConfigurerConsumer, new FrameworkDomainFromProjectSourcesConfigurer(domainPath));
        return this;
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedDomain(packagedDomainPath, domainConfigurer -> {});
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedDomain(packagedDomainPath, domainConfigurerConsumer, false);
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        return this.fromPackagedDomain(packagedDomainPath, domainConfigurer -> {}, forceConfigsParse);
    }

    public MuleFramework.Builder fromPackagedDomain(Path packagedDomainPath, Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer, boolean forceConfigsParse) throws IllegalStateException, IllegalArgumentException {
        if (packagedDomainPath == null) {
            throw new IllegalArgumentException("'packagedDomainPath' cannot be null");
        }
        this.configureDomain(domainConfigurerConsumer, new FrameworkDomainFromPackagedProjectConfigurer(packagedDomainPath, forceConfigsParse));
        return this;
    }

    public MuleFramework.Builder fromPlugins(Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer) {
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromPluginsConfigurer());
        return this;
    }

    public MuleFramework.Builder fromPlugins(Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer, Path mavenRepositoryPath) {
        if (mavenRepositoryPath == null) {
            throw new IllegalArgumentException("'mavenRepositoryPath' cannot be null");
        }
        this.withDependencyResolver(new LocalDependencyResolver(mavenRepositoryPath));
        this.configureApplication(applicationConfigurerConsumer, new FrameworkApplicationFromPluginsConfigurer());
        return this;
    }

    public MuleFramework.Builder fromMuleFrameworkApplication(Path muleFrameworkApplicationPath) {
        if (muleFrameworkApplicationPath == null) {
            throw new IllegalArgumentException("'muleFrameworkApplicationPath' cannot be null");
        }
        if (!DietMuleFrameworkBuilder.getClassLoaderModelDescriptor(muleFrameworkApplicationPath.toFile()).exists()) {
            throw new IllegalArgumentException("'muleFrameworkApplicationPath' must point to a directory containing a 'classloader-model.json' file");
        }
        this.withDependencyResolver(new LocalDependencyResolver(muleFrameworkApplicationPath.resolve(Paths.get("repository", new String[0]))));
        this.configureApplication(this.getMuleFrameworkApplicationConfigurerConsumer(muleFrameworkApplicationPath), new FrameworkApplicationFromPluginsConfigurer());
        return this;
    }

    private Consumer<FrameworkApplicationConfigurer> getMuleFrameworkApplicationConfigurerConsumer(Path muleFrameworkApplicationPath) {
        AppClassLoaderModel appClassLoaderModel = AppClassLoaderModelJsonSerializer.deserialize((File)DietMuleFrameworkBuilder.getClassLoaderModelDescriptor(muleFrameworkApplicationPath.toFile()));
        Map additionalPluginDependencies = appClassLoaderModel.getAdditionalPluginDependencies().map(plugins -> plugins.stream().collect(Collectors.toMap(this::getPluginRepresentation, this::artifactsToArtifactCoordinates))).orElse(Collections.emptyMap());
        return builder -> {
            appClassLoaderModel.getDependencies().forEach(dependency -> {
                PluginBuilder pluginBuilder = builder.withPlugin(dependency.getArtifactCoordinates().getGroupId(), dependency.getArtifactCoordinates().getArtifactId(), dependency.getArtifactCoordinates().getVersion());
                additionalPluginDependencies.getOrDefault(this.getDependencyRepresentation((Artifact)dependency), Collections.emptyList()).forEach(additionalPluginDependency -> pluginBuilder.withAdditionalDependency(additionalPluginDependency.getGroupId(), additionalPluginDependency.getArtifactId(), additionalPluginDependency.getVersion(), additionalPluginDependency.getClassifier()));
                pluginBuilder.buildPlugin();
            });
            if (appClassLoaderModel.getResources() != null && appClassLoaderModel.getResources().length > 0) {
                builder.withResources(Arrays.stream(appClassLoaderModel.getResources()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
            }
        };
    }

    private String getDependencyRepresentation(Artifact dependency) {
        return dependency.getArtifactCoordinates().getGroupId() + ":" + dependency.getArtifactCoordinates().getArtifactId();
    }

    private List<ArtifactCoordinates> artifactsToArtifactCoordinates(Plugin plugin) {
        return plugin.getAdditionalDependencies().stream().map(Artifact::getArtifactCoordinates).collect(Collectors.toList());
    }

    private String getPluginRepresentation(Plugin plugin) {
        return plugin.getGroupId() + ":" + plugin.getArtifactId();
    }

    private static File getClassLoaderModelDescriptor(File artifactFile) {
        return new File(artifactFile, "classloader-model.json");
    }

    private void configureApplication(Consumer<FrameworkApplicationConfigurer> applicationConfigurerConsumer, AbstractFrameworkApplicationConfigurer applicationConfigurer) {
        if (applicationConfigurerConsumer == null) {
            throw new IllegalArgumentException("'applicationConfigurerConsumer' cannot be null");
        }
        if (this.frameworkApplicationConfigurer != null) {
            throw new IllegalStateException("'applicationConfigurer' is already set");
        }
        if (this.frameworkDomainConfigurer != null) {
            throw new IllegalStateException("'domainConfigurer' is already set");
        }
        this.frameworkApplicationConfigurer = applicationConfigurer;
        applicationConfigurerConsumer.accept(this.frameworkApplicationConfigurer);
    }

    private void configureDomain(Consumer<FrameworkDomainConfigurer> domainConfigurerConsumer, AbstractFrameworkDomainConfigurer domainConfigurer) {
        if (domainConfigurerConsumer == null) {
            throw new IllegalArgumentException("'domainConfigurerConsumer' cannot be null");
        }
        if (this.frameworkDomainConfigurer != null) {
            throw new IllegalStateException("'domainConfigurer' is already set");
        }
        if (this.frameworkApplicationConfigurer != null) {
            throw new IllegalStateException("'applicationConfigurer' is already set");
        }
        this.frameworkDomainConfigurer = domainConfigurer;
        domainConfigurerConsumer.accept(this.frameworkDomainConfigurer);
    }

    public MuleFramework.BaseMuleFrameworkBuilder fromBaseMuleFramework(MuleFramework baseMuleFramework, Consumer<FrameworkRefreshConfigurer> refreshConfigurer) throws IllegalStateException, IllegalArgumentException {
        if (this.frameworkApplicationConfigurer != null) {
            throw new IllegalStateException("'applicationConfigurer' is already set, it must be called after fromBaseMuleFramework");
        }
        if (this.frameworkDomainConfigurer != null) {
            throw new IllegalStateException("'domainConfigurer' is already set, it must be called after fromBaseMuleFramework");
        }
        if (baseMuleFramework == null) {
            throw new IllegalArgumentException("'baseMuleFramework' cannot be null");
        }
        if (refreshConfigurer == null) {
            throw new IllegalArgumentException("'refreshConfigurer' cannot be null");
        }
        this.baseMuleFramework = (InternalMuleFramework)baseMuleFramework;
        DefaultFrameworkRefreshConfigurer frameworkRefreshConfigurer = new DefaultFrameworkRefreshConfigurer();
        refreshConfigurer.accept(frameworkRefreshConfigurer);
        if (ArtifactType.APP.equals((Object)this.baseMuleFramework.getFrameworkDeployableArtifact().getArtifactType())) {
            if (this.baseMuleFramework.getFrameworkDeployableArtifact().isCreateConfigurations()) {
                this.configureApplication(FrameworkDeployableArtifactConfigurer::withConfigurations, new FrameworkApplicationRefreshConfigurer(this.baseMuleFramework.getFrameworkDeployableArtifact(), frameworkRefreshConfigurer));
            } else {
                this.configureApplication(configurer -> {}, new FrameworkApplicationRefreshConfigurer(this.baseMuleFramework.getFrameworkDeployableArtifact(), frameworkRefreshConfigurer));
            }
        } else if (ArtifactType.DOMAIN.equals((Object)this.baseMuleFramework.getFrameworkDeployableArtifact().getArtifactType())) {
            if (this.baseMuleFramework.getFrameworkDeployableArtifact().isCreateConfigurations()) {
                this.configureDomain(FrameworkDeployableArtifactConfigurer::withConfigurations, new FrameworkDomainRefreshConfigurer(this.baseMuleFramework.getFrameworkDeployableArtifact(), frameworkRefreshConfigurer));
            } else {
                this.configureDomain(configurer -> {}, new FrameworkDomainRefreshConfigurer(this.baseMuleFramework.getFrameworkDeployableArtifact(), frameworkRefreshConfigurer));
            }
        }
        return this;
    }

    public MuleFramework.Builder withDependencyResolver(DependencyResolver dependencyResolver) {
        if (dependencyResolver == null) {
            throw new IllegalArgumentException("'dependencyResolver' cannot be null");
        }
        if (this.dependencyResolver != this.DEFAULT_DEPENDENCY_RESOLVER) {
            throw new IllegalStateException("'dependencyResolver' is already set");
        }
        if (this.mavenConfiguration != null) {
            throw new IllegalStateException("'mavenConfiguration' is already set");
        }
        this.dependencyResolver = () -> dependencyResolver;
        return this;
    }

    public MuleFramework.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        if (mavenConfiguration == null) {
            throw new IllegalArgumentException("'mavenConfiguration' cannot be null");
        }
        if (this.mavenConfiguration != null) {
            throw new IllegalStateException("'mavenConfiguration' is already set");
        }
        if (this.dependencyResolver != this.DEFAULT_DEPENDENCY_RESOLVER) {
            throw new IllegalStateException("'dependencyResolver' is already set");
        }
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    public MuleFramework.Builder enableOCS(Consumer<OCSConfigurer> configurer) {
        if (this.ocsConfigurer != null) {
            throw new IllegalStateException("OCS has already been configured");
        }
        this.ocsConfigurer = new OCSConfigurer();
        configurer.accept(this.ocsConfigurer);
        return this;
    }

    public MuleFramework.Builder usageMode(MuleFramework.UsageMode usageMode) {
        if (this.usageMode != DEFAULT_USAGE_MODE) {
            throw new IllegalStateException("'usageMode' is already set");
        }
        this.usageMode = usageMode;
        return this;
    }

    public MuleFramework.Builder withCustomServicesConfigurer(Consumer<ServiceConfigurer> configurer) {
        if (this.servicesConfigurerBuilder != null) {
            throw new IllegalStateException("'customServicesConfigurerBuilder' is already set");
        }
        this.servicesConfigurerBuilder = new MuleFrameworkServiceConfigurerBuilder(ServiceClassLoaderFactoryProvider.serviceClassLoaderFactory(), this.containerClassLoader, this.muleVersion, this.muleServices);
        configurer.accept(this.servicesConfigurerBuilder);
        return this;
    }

    public MuleFramework.Builder withMetadataStorage(MetadataStorage metadataStorage) {
        this.metadataCache = metadataStorage;
        return this;
    }

    public MuleFramework.Builder addParameter(String key, Object value) {
        Preconditions.checkArgument((key != null && key.length() > 0 ? 1 : 0) != 0, (String)"key cannot be blank");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.customParameters.put(key, value);
        return this;
    }

    public MuleFramework.Builder addParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (String)"cannot add null parameters");
        parameters.forEach(this::addParameter);
        return this;
    }

    public MuleFramework build() {
        try {
            if (this.frameworkDomainConfigurer != null) {
                return this.buildForDomain();
            }
            return this.buildForApp();
        }
        catch (Exception e) {
            throw new FrameworkBuildException(e.getMessage(), (Throwable)e);
        }
    }

    private MuleFramework buildForDomain() {
        FrameworkDomain frameworkDomain = this.frameworkDomainConfigurer.configure(this.classLoaderResolver, this.getDeploymentPropertiesForArtifact(), this.mavenConfiguration);
        return this.buildForDeployableArtifact(frameworkDomain, () -> this.getExtensionModels(frameworkDomain.getClassLoader()));
    }

    private MuleFramework buildForApp() {
        if (this.frameworkApplicationConfigurer == null) {
            this.frameworkApplicationConfigurer = new FrameworkApplicationFromPluginsConfigurer();
        }
        FrameworkApplication frameworkApplication = this.frameworkApplicationConfigurer.configure(this.classLoaderResolver, this.dependencyResolver, this.getDeploymentPropertiesForArtifact(), this.mavenConfiguration);
        return this.buildForDeployableArtifact(frameworkApplication, () -> this.getExtensionModels(frameworkApplication.getClassLoader()));
    }

    private MuleFramework buildForDeployableArtifact(FrameworkDeployableArtifact frameworkDeployableArtifact, Supplier<Set<ExtensionModel>> extensionModelsSupplier) {
        try {
            Set<ExtensionModel> extensionModels = extensionModelsSupplier.get();
            if (this.frameworkApplicationConfigurer != null) {
                this.frameworkApplicationConfigurer.getDomainFramework().ifPresent(d -> d.getExtensionModels().forEach(extensionModels::add));
            }
            switch (this.usageMode) {
                case EXTENSION_MODELS: {
                    DietMuleFrameworkWithExtensionModels dietMuleFrameworkWithExtensionModels = new DietMuleFrameworkWithExtensionModels(frameworkDeployableArtifact, extensionModels);
                    return dietMuleFrameworkWithExtensionModels;
                }
                case ARTIFACT_AST: {
                    DietMuleFrameworkStaticAnalysis dietMuleFrameworkStaticAnalysis = this.getStaticAnalysisFramework(frameworkDeployableArtifact, extensionModels);
                    return dietMuleFrameworkStaticAnalysis;
                }
                case TOOLING: 
                case EXECUTABLE: {
                    InternalMuleFramework internalMuleFramework = this.getFullFledgedFramework(frameworkDeployableArtifact, extensionModels, this.frameworkApplicationConfigurer != null ? this.frameworkApplicationConfigurer.getDomainFramework() : Optional.empty());
                    return internalMuleFramework;
                }
            }
            throw new IllegalStateException("Unknown 'usageMode'");
        }
        finally {
            if (!(this.dependencyResolver instanceof LazyValue) || ((LazyValue)this.dependencyResolver).isComputed()) {
                LifecycleUtils.disposeIfNeeded((Object)this.dependencyResolver.get(), (Logger)LOGGER);
            }
        }
    }

    private DietMuleFrameworkStaticAnalysis getStaticAnalysisFramework(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels) {
        frameworkDeployableArtifact.setUp(extensionModels);
        return new DietMuleFrameworkStaticAnalysis(frameworkDeployableArtifact, extensionModels);
    }

    private InternalMuleFramework getFullFledgedFramework(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels, Optional<InternalMuleFramework> domainFwk) {
        ServiceManager serviceManager = this.getServiceManager();
        MuleContext muleContext = null;
        MuleDeployableArtifactClassLoader applicationClassLoader = frameworkDeployableArtifact.getClassLoader();
        try {
            boolean startMuleContext;
            LifecycleUtils.startIfNeeded((Object)serviceManager);
            if (this.baseMuleFramework != null) {
                this.baseMuleFramework.assertStarted();
                muleContext = this.baseMuleFramework.getMuleContext();
                muleContext.setExecutionClassLoader(applicationClassLoader.getParent());
                ((DietMuleFrameworkTooling)this.baseMuleFramework).markAsRefreshed();
                startMuleContext = false;
            } else {
                muleContext = this.createMuleContext(frameworkDeployableArtifact.getArtifactType(), serviceManager, frameworkDeployableArtifact.getWorkingDirectory(), extensionModels, (RegionClassLoader)applicationClassLoader.getParent());
                startMuleContext = true;
            }
            Registry registry = this.getRegistry(muleContext);
            ExpressionLanguageMetadataService expressionLanguageMetadataService = this.lookup(registry, ExpressionLanguageMetadataService.class);
            ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory = this.lookup(registry, ExtensionDesignTimeResolversFactory.class);
            frameworkDeployableArtifact.setUp(muleContext, extensionDesignTimeResolversFactory, expressionLanguageMetadataService, extensionModels);
            registry.lookupByType(ConfigurationProperties.class).filter(ConfigurationPropertiesDelegator.class::isInstance).map(ConfigurationPropertiesDelegator.class::cast).ifPresent(cpd -> cpd.setDelegate((ConfigurationProperties)frameworkDeployableArtifact.getConfigurationProperties()));
            Optional<DietMuleFrameworkConfigurations> configsManager = Optional.empty();
            if (frameworkDeployableArtifact.isCreateConfigurations()) {
                if (this.baseMuleFramework != null) {
                    new ConfigurationsRefreshHandler(((DietMuleFrameworkTooling)this.baseMuleFramework).getConfigsManager().get(), () -> this.baseMuleFramework.getConfigsAst(), frameworkDeployableArtifact).refreshConfigs();
                }
                configsManager = Optional.of(new DietMuleFrameworkConfigurations(frameworkDeployableArtifact));
            }
            MetadataStorage metadataStorage = this.metadataCache != DEFAULT_METADATA_CACHE || this.baseMuleFramework == null ? this.metadataCache : this.baseMuleFramework.getMetadataStorage();
            DietMuleFrameworkTooling mule = this.usageMode == MuleFramework.UsageMode.EXECUTABLE ? new DietMuleFramework(muleContext, startMuleContext, registry, serviceManager, extensionModels, frameworkDeployableArtifact, domainFwk, expressionLanguageMetadataService, metadataStorage, configsManager) : new DietMuleFrameworkTooling(muleContext, startMuleContext, registry, serviceManager, extensionModels, frameworkDeployableArtifact, domainFwk, expressionLanguageMetadataService, metadataStorage, configsManager);
            mule.start();
            return mule;
        }
        catch (MuleException e) {
            try {
                serviceManager.stop();
            }
            catch (MuleException e1) {
                e1.addSuppressed((Throwable)e);
                throw new MuleRuntimeException((Throwable)e1);
            }
            finally {
                LifecycleUtils.disposeIfNeeded(muleContext, (Logger)LOGGER);
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private ServiceManager getServiceManager() {
        if (this.baseMuleFramework == null) {
            if (this.servicesConfigurerBuilder == null) {
                this.servicesConfigurerBuilder = new MuleFrameworkServiceConfigurerBuilder(ServiceClassLoaderFactoryProvider.serviceClassLoaderFactory(), this.containerClassLoader, this.muleVersion, this.muleServices);
            }
            if (this.usageMode == MuleFramework.UsageMode.TOOLING) {
                this.servicesConfigurerBuilder.enableToolingServices();
            }
            return this.servicesConfigurerBuilder.getServiceManager(this.dependencyResolver.get());
        }
        return this.baseMuleFramework.getServiceManager();
    }

    private Registry getRegistry(MuleContext muleContext) throws MuleException {
        MuleFrameworkRegistry muleFrameworkRegistry = new MuleFrameworkRegistry();
        muleContext.getInjector().inject((Object)muleFrameworkRegistry);
        return muleFrameworkRegistry.getRegistry();
    }

    private Set<ExtensionModel> getExtensionModels(MuleDeployableArtifactClassLoader applicationClassLoader) {
        if (this.baseMuleFramework != null) {
            return this.baseMuleFramework.getExtensionModels();
        }
        ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager();
        try {
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
            ExtensionModelDiscoverer extensionModelDiscoverer = ExtensionModelDiscoverer.defaultExtensionModelDiscoverer((MuleDeployableArtifactClassLoader)applicationClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository);
            Set set = extensionModelDiscoverer.discoverPluginsExtensionModels(this.getExtensionDiscoveryRequest((DeployableArtifactDescriptor)applicationClassLoader.getArtifactDescriptor()));
            return set;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            try {
                LifecycleUtils.stopIfNeeded((Object)extensionModelLoaderRepository);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private MuleContext createMuleContext(ArtifactType artifactType, ServiceManager serviceManager, Optional<Path> workingDirectory, Set<ExtensionModel> extensionModels, RegionClassLoader executionClassLoader) {
        MuleFrameworkContextFactory factory = new MuleFrameworkContextFactory();
        try {
            return factory.createMuleContext(artifactType, serviceManager.getServices(), workingDirectory, extensionModels, (ClassLoader)executionClassLoader, this.usageMode == MuleFramework.UsageMode.EXECUTABLE);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create framework mule context"), (Throwable)e);
        }
    }

    private <T> T lookup(Registry registry, Class<T> clazz) {
        return registry.lookupByType(clazz).orElse(null);
    }

    private ExtensionDiscoveryRequest getExtensionDiscoveryRequest(DeployableArtifactDescriptor deployableArtifactDescriptor) {
        this.customParameters.putIfAbsent(ADD_ANNOTATIONS_TO_CONFIG_CLASS, false);
        ExtensionDiscoveryRequest.ExtensionDiscoveryRequestBuilder builder = ExtensionDiscoveryRequest.builder().setArtifactPlugins((Collection)deployableArtifactDescriptor.getPlugins()).setOCSEnabled(this.ocsConfigurer != null).setParallelDiscovery(true).addParameters(this.customParameters);
        if (this.customParameters.containsKey("extensionDiscoveryRequest.resolveMinMuleVersion")) {
            builder.setResolveMinMuleVersion(((Boolean)this.customParameters.get("extensionDiscoveryRequest.resolveMinMuleVersion")).booleanValue());
        }
        return builder.build();
    }

    private Map<String, String> getDeploymentPropertiesForArtifact() {
        return this.ocsConfigurer != null ? this.getOCSConfiguration(this.ocsConfigurer) : Collections.emptyMap();
    }

    private Map<String, String> getOCSConfiguration(OCSConfigurer ocsConfigurer) {
        Preconditions.checkArgument((ocsConfigurer.getAuthUrl() != null ? 1 : 0) != 0, (String)"The authUrl cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getServiceUrl() != null ? 1 : 0) != 0, (String)"The serviceUrl cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getClientId() != null ? 1 : 0) != 0, (String)"The clientId cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getClientSecret() != null ? 1 : 0) != 0, (String)"The clientSecret cannot be null in OCS configuration");
        Preconditions.checkArgument((ocsConfigurer.getOrgId() != null ? 1 : 0) != 0, (String)"The orgId cannot be null in OCS configuration");
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("ocs.service.url", ocsConfigurer.getServiceUrl());
        configuration.put("ocs.platform.authentication.url", ocsConfigurer.getAuthUrl());
        configuration.put("ocs.service.client.id", ocsConfigurer.getClientId());
        configuration.put("ocs.service.client.secret", ocsConfigurer.getClientSecret());
        configuration.put("csorganization.id", ocsConfigurer.getOrgId());
        if (ocsConfigurer.getPlatformAuthPath() != null) {
            configuration.put("ocs.platform.authentication.path", ocsConfigurer.getPlatformAuthPath());
        }
        if (ocsConfigurer.getApiVersion() != null) {
            configuration.put("ocs.api.version", ocsConfigurer.getApiVersion());
        }
        return Collections.unmodifiableMap(configuration);
    }

    private static class MuleFrameworkRegistry {
        @Inject
        Registry registry;

        private MuleFrameworkRegistry() {
        }

        public Registry getRegistry() {
            return this.registry;
        }
    }
}

