/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import com.mulesoft.mule.framework.api.DeployableProjectModel;
import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.dsl.xml.XmlDslInfo;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.framework.internal.dsl.xml.DefaultXmlDslInfo;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public abstract class AbstractMuleFramework
implements InternalMuleFramework {
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;
    private final Set<ExtensionModel> extensionModels;
    private final DslResolvingContext dslResolvingContext;

    public AbstractMuleFramework(FrameworkDeployableArtifact frameworkDeployableArtifact, Set<ExtensionModel> extensionModels) {
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.extensionModels = extensionModels;
        this.dslResolvingContext = DslResolvingContext.getDefault(extensionModels);
    }

    public Optional<ExtensionModel> getExtensionModel(String name) {
        return MuleFrameworkUtils.getExtensionModelOptional((MuleFramework)this, name);
    }

    public Optional<ExtensionModel> getExtensionModel(ArtifactCoordinates artifactCoordinates) {
        return MuleFrameworkUtils.getExtensionModelOptional((MuleFramework)this, artifactCoordinates);
    }

    public Set<ExtensionModel> getExtensionModels() {
        return this.extensionModels;
    }

    public Optional<DeployableProjectModel> getDeployableProjectModel() {
        return this.frameworkDeployableArtifact.getDeployableProjectModel();
    }

    public Optional<ArtifactAst> getArtifactAst() {
        return Optional.ofNullable(this.frameworkDeployableArtifact.getArtifactAst());
    }

    public Stream<ComponentAst> getConfigsAst() {
        return this.frameworkDeployableArtifact.getConfigurationsAsts().map(Collection::stream).orElse(Stream.empty());
    }

    public XmlDslInfo getXmlDslInfo() {
        return new DefaultXmlDslInfo(this, this.dslResolvingContext);
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.frameworkDeployableArtifact.getExecutionClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T onExecutionClassLoader(Callable<T> task) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getExecutionClassLoader());
        try {
            T t = task.call();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecutionClassLoader(Runnable task) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getExecutionClassLoader());
        try {
            task.run();
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public FrameworkDeployableArtifact getFrameworkDeployableArtifact() {
        return this.frameworkDeployableArtifact;
    }

    public void close() throws Exception {
        this.frameworkDeployableArtifact.dispose();
    }

    protected String getDeployableArtifactType() {
        if (this.frameworkDeployableArtifact instanceof FrameworkApplication) {
            return "application";
        }
        if (this.frameworkDeployableArtifact instanceof FrameworkDomain) {
            return "domain";
        }
        return "deployable artifact";
    }

    protected DslResolvingContext getDslResolvingContext() {
        return this.dslResolvingContext;
    }
}

