/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws.reconnect;

import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.ws.WebSocket;

public class OutboundWebSocketReconnectionHandler {
    private final HttpClient httpClient;
    private final HttpRequest request;
    private final HttpRequestOptions requestOptions;
    private final String socketId;
    private final WebSocketCallback callback;

    public OutboundWebSocketReconnectionHandler(HttpClient httpClient, HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback) {
        this.httpClient = httpClient;
        this.request = request;
        this.requestOptions = requestOptions;
        this.socketId = socketId;
        this.callback = callback;
    }

    public CompletableFuture<WebSocket> reconnect(OutboundWebSocket webSocket, RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        return retryPolicyTemplate.applyPolicy(() -> this.httpClient.openWebSocket(this.request, this.requestOptions, this.socketId, this.callback), t -> !webSocket.isClosed(), t -> {}, t -> {}, t -> WebSocketUtils.mapWsException(t, webSocket), scheduler);
    }
}

