/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.ws.DataFrameEmitter;
import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import com.mulesoft.service.http.impl.service.ws.FragmentHandlerProvider;
import com.mulesoft.service.http.impl.service.ws.PipedFragmentHandlerProvider;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;

public class InboundWebSocket
extends DefaultWebSocket
implements WebSocket {
    private final String id;
    private final WebSocketHandler resource;
    private final WebSocketRequest request;
    private final Set<String> groups = new HashSet<String>();
    private final FragmentHandlerProvider fragmentHandlerProvider;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public InboundWebSocket(String id, WebSocketHandler resource, WebSocketRequest request, ProtocolHandler protocolHandler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        super(protocolHandler, requestPacket, listeners);
        this.id = id;
        this.resource = resource;
        this.request = request;
        this.fragmentHandlerProvider = new PipedFragmentHandlerProvider(id);
    }

    public CompletableFuture<Void> send(InputStream content, MediaType mediaType) {
        try {
            DataFrameEmitter emitter = MediaTypeUtils.isStringRepresentable((MediaType)mediaType) ? this.textEmitter() : this.binaryEmitter();
            return WebSocketUtils.streamInDataFrames(content, emitter, t -> WebSocketUtils.mapWsException(t, this));
        }
        catch (Throwable t2) {
            return WebSocketUtils.failedFuture(WebSocketUtils.mapWsException(t2, this));
        }
    }

    public CompletableFuture<Void> sendFrame(byte[] frameBytes) {
        return WebSocketUtils.asVoid(this.sendRaw(frameBytes), t -> WebSocketUtils.mapWsException(t, this));
    }

    public byte[] toBinaryFrame(byte[] data, boolean last) {
        return this.toRawData(data, last);
    }

    public byte[] toTextFrame(String data, boolean last) {
        return this.toRawData(data, last);
    }

    public FragmentHandler getFragmentHandler(Consumer<FragmentHandler> newFragmentHandlerCallback) {
        return this.fragmentHandlerProvider.getFragmentHandler(newFragmentHandlerCallback);
    }

    private DataFrameEmitter textEmitter() {
        return new DataFrameEmitter(){

            @Override
            public CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last) {
                return WebSocketUtils.asVoid(InboundWebSocket.this.stream(last, new String(bytes, 0, len)), t -> WebSocketUtils.mapWsException(t, InboundWebSocket.this));
            }

            @Override
            public CompletableFuture<Void> send(byte[] bytes, int offset, int len) {
                return WebSocketUtils.asVoid(InboundWebSocket.this.send(new String(bytes, 0, len)), t -> WebSocketUtils.mapWsException(t, InboundWebSocket.this));
            }
        };
    }

    private DataFrameEmitter binaryEmitter() {
        return new DataFrameEmitter(){

            @Override
            public CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last) {
                return WebSocketUtils.asVoid(InboundWebSocket.this.stream(last, bytes, offset, len), t -> WebSocketUtils.mapWsException(t, InboundWebSocket.this));
            }

            @Override
            public CompletableFuture<Void> send(byte[] bytes, int offset, int len) {
                if (offset != 0 || len != bytes.length) {
                    byte[] aux = new byte[len];
                    System.arraycopy(bytes, offset, aux, 0, len);
                    bytes = aux;
                }
                return WebSocketUtils.asVoid(InboundWebSocket.this.send(bytes), t -> WebSocketUtils.mapWsException(t, InboundWebSocket.this));
            }
        };
    }

    public void close(int code, String reason) {
        this.closed.set(true);
        super.close(code, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroups() {
        Set<String> set = this.groups;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<String>(this.groups));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String group) {
        Set<String> set = this.groups;
        synchronized (set) {
            this.groups.add(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String group) {
        Set<String> set = this.groups;
        synchronized (set) {
            this.groups.remove(group);
        }
    }

    public boolean supportsReconnection() {
        return false;
    }

    public CompletableFuture<WebSocket> reconnect(RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        return WebSocketUtils.failedFuture(new UnsupportedOperationException());
    }

    public CompletableFuture<Void> close(WebSocketCloseCode code, String reason) {
        return WebSocketUtils.asVoid(this.completableClose(code.getProtocolCode(), reason));
    }

    public String getId() {
        return this.id;
    }

    public URI getUri() {
        return this.request.getRequestUri();
    }

    public WebSocket.WebSocketType getType() {
        return WebSocket.WebSocketType.INBOUND;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public WebSocketProtocol getProtocol() {
        return this.request.getScheme();
    }

    public WebSocketRequest getRequest() {
        return this.request;
    }

    public WebSocketHandler getResource() {
        return this.resource;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InboundWebSocket) {
            return this.id.equals(((InboundWebSocket)((Object)obj)).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "WebSocket Id: " + this.id + "\nType: " + String.valueOf(WebSocket.WebSocketType.INBOUND) + "\nURI: " + String.valueOf(this.getUri());
    }
}

