/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service;

import com.mulesoft.service.http.impl.grizzly.memory.manager.MuleGrizzlyHeapMemoryManager;
import com.mulesoft.service.http.impl.service.client.EEHttpClientConnectionManager;
import com.mulesoft.service.http.impl.service.server.EEHttpListenerConnectionManager;
import com.mulesoft.service.http.impl.service.ws.GrizzlyWebSocketBroadcaster;
import jakarta.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.ws.WebSocketBroadcaster;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.HttpClientConnectionManager;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EEHttpServiceImplementation
extends HttpServiceImplementation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EEHttpServiceImplementation.class);
    public static final String HTTP_SERVICE_GRIZZLY_MEMORY_MANAGEMENT = "http.service.grizzly.memory.management";
    @Inject
    private MemoryManagementService memoryManagementService;
    private ByteBufferProvider byteBufferProvider;

    public EEHttpServiceImplementation(SchedulerService schedulerService) {
        super(schedulerService);
    }

    protected HttpClientConnectionManager createClientConnectionManager() {
        return new EEHttpClientConnectionManager(this.schedulerService);
    }

    protected HttpListenerConnectionManager createListenerConnectionManager(SchedulerService schedulerService) {
        return new EEHttpListenerConnectionManager(schedulerService, SchedulerConfig.config());
    }

    public WebSocketBroadcaster newWebSocketBroadcaster() {
        return new GrizzlyWebSocketBroadcaster();
    }

    public String getName() {
        return "HTTP EE Service";
    }

    public void start() throws MuleException {
        MemoryManagementService memoryManagementServiceForInjectingByteBuffer = this.getMemoryManagementService();
        if (memoryManagementServiceForInjectingByteBuffer != null && this.byteBufferProvider == null) {
            this.byteBufferProvider = memoryManagementServiceForInjectingByteBuffer.getByteBufferProvider(HTTP_SERVICE_GRIZZLY_MEMORY_MANAGEMENT, ByteBufferType.HEAP);
            MuleGrizzlyHeapMemoryManager.setMemoryManagerByteBufferProvider(this.byteBufferProvider);
        } else {
            LOGGER.warn("Memory Management is null. This is not a managed EEHttpServiceImplementation. A default Byte Buffer Provider will be used by the Mule Memory Manager.");
        }
        super.start();
    }

    public void stop() throws MuleException {
        if (this.byteBufferProvider != null) {
            MemoryManagementService memoryManagementServiceForInjectingByteBuffer = this.getMemoryManagementService();
            memoryManagementServiceForInjectingByteBuffer.disposeByteBufferProvider(HTTP_SERVICE_GRIZZLY_MEMORY_MANAGEMENT);
            this.byteBufferProvider = null;
        }
        super.stop();
    }

    protected MemoryManagementService getMemoryManagementService() {
        return this.memoryManagementService;
    }
}

