/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;

public class NettyWebSocketFrame {
    private final TypedValue<InputStream> content;
    private final OutputStream sinkForContinuation;

    public NettyWebSocketFrame(WebSocketFrame webSocketFrame, WebSocketRequest originalRequest) throws IOException {
        if (webSocketFrame == null) {
            throw new IllegalArgumentException("Web socket frame can't be null");
        }
        byte[] contentBytes = NettyWebSocketFrame.getContentBytes(webSocketFrame);
        Pair<InputStream, OutputStream> streamEndpoints = NettyWebSocketFrame.createStreamEndpoints(contentBytes, webSocketFrame.isFinalFragment());
        MediaType defaultMediaType = this.getDefaultMediaType(webSocketFrame);
        this.content = new TypedValue((Object)((InputStream)streamEndpoints.getFirst()), DataType.builder().type(InputStream.class).mediaType(NettyWebSocketFrame.resolveMediaType(originalRequest, defaultMediaType)).build());
        this.sinkForContinuation = (OutputStream)streamEndpoints.getSecond();
    }

    public TypedValue<InputStream> getContent() {
        return this.content;
    }

    public Optional<OutputStream> getSinkForContinuation() {
        return Optional.ofNullable(this.sinkForContinuation);
    }

    private static Pair<InputStream, OutputStream> createStreamEndpoints(byte[] contentBytes, boolean isFinal) throws IOException {
        if (isFinal) {
            return new Pair((Object)new ByteArrayInputStream(contentBytes), null);
        }
        BlockingBidirectionalStream bidirectionalStream = new BlockingBidirectionalStream();
        bidirectionalStream.write(contentBytes, 0, contentBytes.length);
        return new Pair((Object)bidirectionalStream.getInputStream(), (Object)bidirectionalStream.getOutputStream());
    }

    private MediaType getDefaultMediaType(WebSocketFrame webSocketFrame) {
        if (webSocketFrame instanceof TextWebSocketFrame) {
            return MediaType.TEXT;
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            return MediaType.BINARY;
        }
        throw new IllegalArgumentException(String.format("Can't create an instance of '%s' from a '%s'", NettyWebSocketFrame.class, webSocketFrame.getClass()));
    }

    private static byte[] getContentBytes(WebSocketFrame webSocketFrame) {
        if (webSocketFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)webSocketFrame;
            return textWebSocketFrame.text().getBytes();
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            return ByteBufUtil.getBytes((ByteBuf)webSocketFrame.content());
        }
        throw new IllegalArgumentException(String.format("Can't create an instance of '%s' from a '%s'", NettyWebSocketFrame.class, webSocketFrame.getClass()));
    }

    private static MediaType resolveMediaType(WebSocketRequest request, MediaType defaultMediaType) {
        if (request == null) {
            return defaultMediaType;
        }
        MediaType resolved = request.getContentType();
        if (resolved == MediaType.ANY) {
            resolved = defaultMediaType;
        }
        return resolved;
    }
}

