/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import com.mulesoft.service.http.impl.netty.frame.InputStreamFramer;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

public class FramedPublisher
extends Flux<WebSocketFrame> {
    private final InputStream inputStream;
    private final int bufferSize;
    private final boolean isText;

    public FramedPublisher(InputStream inputStream, boolean isText) {
        this(inputStream, isText, 8192);
    }

    public FramedPublisher(InputStream inputStream, boolean isText, int bufferSize) {
        this.inputStream = inputStream;
        this.bufferSize = bufferSize;
        this.isText = isText;
    }

    public void subscribe(CoreSubscriber<? super WebSocketFrame> actual) {
        actual.onSubscribe((Subscription)new FramedPublisherSubscription(actual, this.inputStream, this.bufferSize, this.isText));
    }

    private static class FramedPublisherSubscription
    implements Subscription {
        private final CoreSubscriber<? super WebSocketFrame> subscriber;
        private final InputStreamFramer sender;

        FramedPublisherSubscription(CoreSubscriber<? super WebSocketFrame> subscriber, InputStream inputStream, int bufferSize, boolean isText) {
            this.subscriber = subscriber;
            this.sender = new InputStreamFramer(inputStream, new NotifyingSubscriberFrameConsumer(subscriber), isText, bufferSize);
        }

        public void request(long requestedFrames) {
            try {
                this.sender.requestFrames(requestedFrames);
            }
            catch (IOException e) {
                this.subscriber.onError((Throwable)e);
            }
        }

        public void cancel() {
            this.sender.cancel();
        }
    }

    private static class NotifyingSubscriberFrameConsumer
    implements InputStreamFramer.WebSocketFrameCallback {
        private final CoreSubscriber<? super WebSocketFrame> subscriber;

        public NotifyingSubscriberFrameConsumer(CoreSubscriber<? super WebSocketFrame> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onWebSocketFrame(WebSocketFrame frame) {
            this.subscriber.onNext((Object)frame);
        }

        @Override
        public void onStreamConsumed() {
            this.subscriber.onComplete();
        }
    }
}

