/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.NettyInboundWebSocket;
import com.mulesoft.service.http.impl.netty.frame.WebSocketFramesHandler;
import com.mulesoft.service.http.impl.service.client.ws.DefaultWebSocketMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.http.api.server.ws.WebSocketConnectionRejectedException;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketMessage;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;

public final class ForwardingToWsListenerHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final WebSocketHandler webSocketHandler;
    private final WebSocketRequest originalRequest;
    private final WebSocket inboundWebSocket;
    private final WebSocketFramesHandler framesHandler;

    public ForwardingToWsListenerHandler(WebSocketHandler webSocketHandler, WebSocketRequest request, ChannelHandlerContext ctx, LazyValue<ExecutorService> schedulerToHandleNonFinalFrames) throws WebSocketConnectionRejectedException {
        this.webSocketHandler = webSocketHandler;
        String socketId = this.webSocketHandler.getConnectionHandler().getSocketId(request);
        this.inboundWebSocket = new NettyInboundWebSocket(socketId, request, ctx, this.webSocketHandler);
        this.originalRequest = request;
        this.webSocketHandler.getConnectionHandler().onConnect(this.inboundWebSocket, request);
        this.framesHandler = this.getFramesHandler(schedulerToHandleNonFinalFrames);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.inboundWebSocket.close(WebSocketCloseCode.NORMAL_CLOSURE, "Timeout");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame webSocketFrame) throws IOException {
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)webSocketFrame;
            this.webSocketHandler.getConnectionHandler().onClose(this.inboundWebSocket, this.originalRequest, WebSocketCloseCode.fromProtocolCode((int)closeFrame.statusCode()), closeFrame.reasonText());
            this.framesHandler.cancel();
            return;
        }
        this.framesHandler.onFrame(webSocketFrame);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.framesHandler.cancel();
        ctx.fireChannelInactive();
    }

    private WebSocketFramesHandler getFramesHandler(LazyValue<ExecutorService> schedulerToHandleNonFinal) {
        return new WebSocketFramesHandler(schedulerToHandleNonFinal, firstFrame -> this.webSocketHandler.getMessageHandler().onMessage((WebSocketMessage)new DefaultWebSocketMessage(this.inboundWebSocket, firstFrame.getContent(), this.originalRequest)));
    }
}

