/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.processor;

import com.mulesoft.mule.runtime.core.internal.processor.TransformMessageProcessor;
import com.mulesoft.mule.runtime.core.internal.processor.TransformationTarget;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.exception.ResourceNotFoundException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public abstract class BaseTransformationTarget
extends AbstractComponent
implements TransformationTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformMessageProcessor.class);
    protected String resource;
    protected LazyValue<String> script = new LazyValue(this::loadExpression);
    private CompiledExpression compiledExpression;

    @Override
    public void initialize(ExpressionLanguage expressionLanguage) {
        this.compiledExpression = ExpressionLanguageUtils.compile((String)((String)this.script.get()), (ExpressionLanguage)expressionLanguage);
    }

    private String loadExpression() {
        if (this.script.isComputed()) {
            if (this.resource != null) {
                this.fail(String.format("Invalid configuration found for component [%s]: \n %s", this.getTargetName(), "Both [script] and [resource] parameters were provided, only one should be provided"));
            }
            return (String)this.script.get();
        }
        if (this.resource == null) {
            this.fail(String.format("Invalid configuration found for component [%s]: \n %s", this.getTargetName(), "No [script] nor [resource] parameters were provided, but one is required"));
        }
        return this.getResourceFrom(this.resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getResourceFrom(String resource) {
        String resourceFromStream = null;
        InputStream resourceAsStream = null;
        resourceAsStream = IOUtils.getInputStreamWithCacheControl((URL)ClassUtils.getResourceOrFail((String)resource, (boolean)true));
        resourceFromStream = org.apache.commons.io.IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
        if (resourceAsStream == null) return resourceFromStream;
        try {
            resourceAsStream.close();
            return resourceFromStream;
        }
        catch (IOException e) {
            if (!LOGGER.isDebugEnabled()) return resourceFromStream;
            LOGGER.debug(String.format("Error closing stream for transformation: %s", resource));
        }
        return resourceFromStream;
        catch (IOException | ResourceNotFoundException e) {
            try {
                if (resourceAsStream == null) {
                    try {
                        resourceAsStream = new FileInputStream(resource);
                        resourceFromStream = org.apache.commons.io.IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e2) {
                        this.fail(String.format("Invalid configuration found for parameter 'resource' in component [%s]: \n %s", this.getTargetName(), e.getMessage()));
                    }
                }
                if (resourceAsStream == null) return resourceFromStream;
            }
            catch (Throwable throwable) {
                if (resourceAsStream == null) throw throwable;
                try {
                    resourceAsStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (!LOGGER.isDebugEnabled()) throw throwable;
                    LOGGER.debug(String.format("Error closing stream for transformation: %s", resource));
                }
                throw throwable;
            }
            try {
                resourceAsStream.close();
                return resourceFromStream;
            }
            catch (IOException e3) {
                if (!LOGGER.isDebugEnabled()) return resourceFromStream;
                LOGGER.debug(String.format("Error closing stream for transformation: %s", resource));
            }
            return resourceFromStream;
        }
    }

    @Override
    public void setScript(String script) {
        this.script = new LazyValue((Object)script);
    }

    @Override
    public String getScript() {
        return (String)this.script.get();
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public String getExpression() {
        return (String)this.script.get();
    }

    @Override
    public CompiledExpression getCompiledExpression() {
        return this.compiledExpression;
    }

    private void fail(String message) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
    }
}

