/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.deserialize.type;

import com.mulesoft.connectivity.mule.persistence.deserialize.type.AnyTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.ArrayTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.BinaryTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.BooleanTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.DateTimeTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.DateTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.FunctionTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.IntersectionTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.NumberTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.ObjectTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.StringTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.TimeTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.TupleTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.TypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.UnionTypeDeserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;

public class MetadataTypeDeserializerProvider {
    private final Map<String, TypeDeserializer<?>> typeDeserializers = new HashMap();

    public MetadataTypeDeserializerProvider() {
        this.typeDeserializers.put("Any", new AnyTypeDeserializer());
        this.typeDeserializers.put("Array", new ArrayTypeDeserializer());
        this.typeDeserializers.put("Boolean", new BooleanTypeDeserializer());
        this.typeDeserializers.put("Binary", new BinaryTypeDeserializer());
        this.typeDeserializers.put("Date", new DateTypeDeserializer());
        this.typeDeserializers.put("DateTime", new DateTimeTypeDeserializer());
        this.typeDeserializers.put("Intersection", new IntersectionTypeDeserializer());
        this.typeDeserializers.put("Function", new FunctionTypeDeserializer());
        this.typeDeserializers.put("Object", new ObjectTypeDeserializer());
        this.typeDeserializers.put("Number", new NumberTypeDeserializer());
        this.typeDeserializers.put("String", new StringTypeDeserializer());
        this.typeDeserializers.put("Time", new TimeTypeDeserializer());
        this.typeDeserializers.put("Tuple", new TupleTypeDeserializer());
        this.typeDeserializers.put("Union", new UnionTypeDeserializer());
        this.typeDeserializers.put("Nothing", (typeObject, baseBuilder, typeLoader) -> baseBuilder.nothingType());
        this.typeDeserializers.put("Null", (typeObject, baseBuilder, typeLoader) -> baseBuilder.nullType());
        this.typeDeserializers.put("Void", (typeObject, baseBuilder, typeLoader) -> baseBuilder.voidType());
    }

    public Optional<TypeDeserializer<? extends MetadataType>> get(String typeName) {
        return Optional.ofNullable(this.typeDeserializers.get(typeName));
    }
}

