/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal;

import com.mulesoft.mule.runtime.cache.api.InvalidatableCachingStrategy;
import com.mulesoft.mule.runtime.cache.api.key.MuleEventKeyGenerator;
import com.mulesoft.mule.runtime.cache.internal.keygenerator.SHA256MuleEventKeyGenerator;
import jakarta.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;

public class InvalidateKeyMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private InvalidatableCachingStrategy cachingStrategy;
    private MuleEventKeyGenerator keyGenerator = new SHA256MuleEventKeyGenerator();
    @Inject
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.keyGenerator, (boolean)true, (MuleContext)this.muleContext);
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        String key = this.keyGenerator.generateKey(event);
        this.cachingStrategy.invalidate(key);
        return event;
    }

    public InvalidatableCachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public void setCachingStrategy(InvalidatableCachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
    }

    public MuleEventKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(MuleEventKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }
}

