/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.reporting;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SimpleLoggingTable {
    protected static final String NEW_LINE = String.format("%n", new Object[0]);
    private static final char SEPARATOR_CHAR = '*';
    private List<TableColumn> columns = new LinkedList<TableColumn>();
    private final List<String[]> data = new LinkedList<String[]>();
    private int width;

    public void addColumn(String title, int size) {
        this.columns.add(new TableColumn(title, size));
        this.width = this.calculateTableWidth();
    }

    public void addDataRow(String[] dataRow) {
        if (dataRow.length != this.columns.size()) {
            throw new IllegalArgumentException("Data does not contain enough elements");
        }
        this.data.add((String[])dataRow.clone());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.addHeaders(builder);
        this.addRows(builder);
        return builder.toString();
    }

    private void addHeaders(StringBuilder builder) {
        this.addSeparatorLine(builder);
        for (TableColumn column : this.columns) {
            builder.append(String.format("%c %s ", Character.valueOf('*'), this.formatHeaderValue(column.name, column.width)));
        }
        builder.append('*').append(NEW_LINE);
        this.addSeparatorLine(builder);
    }

    private void addRows(StringBuilder builder) {
        for (String[] row : this.data) {
            for (int i = 0; i < row.length; ++i) {
                builder.append(String.format("%c %s ", Character.valueOf('*'), this.formatValue(row[i], this.columns.get((int)i).width)));
            }
            builder.append('*').append(NEW_LINE);
        }
        this.addSeparatorLine(builder);
    }

    private void addSeparatorLine(StringBuilder builder) {
        builder.append(StringUtils.repeat((char)'*', (int)this.width));
        builder.append(NEW_LINE);
    }

    private int calculateTableWidth() {
        int result = 0;
        for (TableColumn column : this.columns) {
            result = result + column.width + 3;
        }
        return ++result;
    }

    private String formatValue(String value, int size) {
        String result = StringUtils.substring((String)value, (int)0, (int)size);
        result = StringUtils.rightPad((String)result, (int)size, (char)' ');
        return result;
    }

    private String formatHeaderValue(String value, int size) {
        String result = StringUtils.substring((String)value, (int)0, (int)size);
        result = StringUtils.center((String)String.format("- - + %s + - -", result), (int)size, (char)' ');
        return result;
    }

    private class TableColumn {
        protected final String name;
        protected final int width;

        public TableColumn(String name, int width) {
            this.name = name;
            this.width = width;
        }
    }
}

