/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixHeuristicMixedException;
import bitronix.tm.internal.BitronixHeuristicRollbackException;
import bitronix.tm.internal.BitronixRollbackException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.AbstractPhaseEngine;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.Decoder;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Committer
extends AbstractPhaseEngine {
    private static final Logger log = LoggerFactory.getLogger(Committer.class);
    private volatile boolean onePhase;
    private final List<XAResourceHolderState> interestedResources = Collections.synchronizedList(new ArrayList());
    private final List<XAResourceHolderState> committedResources = Collections.synchronizedList(new ArrayList());

    public Committer(Executor executor) {
        super(executor);
    }

    public void commit(BitronixTransaction transaction, List<XAResourceHolderState> interestedResources) throws HeuristicMixedException, HeuristicRollbackException, BitronixSystemException, BitronixRollbackException {
        XAResourceManager resourceManager = transaction.getResourceManager();
        if (resourceManager.size() == 0) {
            transaction.setStatus(8);
            transaction.setStatus(3);
            if (log.isDebugEnabled()) {
                log.debug("phase 2 commit succeeded with no interested resource");
            }
            return;
        }
        transaction.setStatus(8);
        this.interestedResources.clear();
        this.interestedResources.addAll(interestedResources);
        this.onePhase = resourceManager.size() == 1;
        try {
            this.executePhase(resourceManager, true);
        }
        catch (PhaseException ex) {
            this.logFailedResources(ex);
            if (this.onePhase) {
                transaction.setStatus(4);
                throw new BitronixRollbackException("transaction failed during 1PC commit of " + String.valueOf(transaction), ex);
            }
            transaction.setStatus(5);
            this.throwException("transaction failed during commit of " + String.valueOf(transaction), ex, interestedResources.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("phase 2 commit executed on resources " + Decoder.collectResourcesNames(this.committedResources));
        }
        HashSet<String> committedAndNotInterestedUniqueNames = new HashSet<String>();
        committedAndNotInterestedUniqueNames.addAll(Committer.collectResourcesUniqueNames(this.committedResources));
        List<XAResourceHolderState> notInterestedResources = Committer.collectNotInterestedResources(resourceManager.getAllResources(), interestedResources);
        committedAndNotInterestedUniqueNames.addAll(Committer.collectResourcesUniqueNames(notInterestedResources));
        if (log.isDebugEnabled()) {
            ArrayList<XAResourceHolderState> committedAndNotInterestedResources = new ArrayList<XAResourceHolderState>();
            committedAndNotInterestedResources.addAll(this.committedResources);
            committedAndNotInterestedResources.addAll(notInterestedResources);
            log.debug("phase 2 commit succeeded on resources " + Decoder.collectResourcesNames(committedAndNotInterestedResources));
        }
        transaction.setStatus(3, committedAndNotInterestedUniqueNames);
    }

    private void throwException(String message, PhaseException phaseException, int totalResourceCount) throws HeuristicMixedException, HeuristicRollbackException {
        List<Exception> exceptions = phaseException.getExceptions();
        List<XAResourceHolderState> resources = phaseException.getResourceStates();
        boolean hazard = false;
        ArrayList<XAResourceHolderState> heuristicResources = new ArrayList<XAResourceHolderState>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception ex = exceptions.get(i);
            XAResourceHolderState resourceHolder = resources.get(i);
            if (ex instanceof XAException) {
                XAException xaEx = (XAException)ex;
                switch (xaEx.errorCode) {
                    case 8: {
                        hazard = true;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        heuristicResources.add(resourceHolder);
                        break;
                    }
                    default: {
                        errorResources.add(resourceHolder);
                        break;
                    }
                }
                continue;
            }
            errorResources.add(resourceHolder);
        }
        if (!hazard && heuristicResources.size() == totalResourceCount) {
            throw new BitronixHeuristicRollbackException(message + ": all resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally rolled back", phaseException);
        }
        throw new BitronixHeuristicMixedException(message + ":" + (String)(errorResources.size() > 0 ? " resource(s) " + Decoder.collectResourcesNames(errorResources) + " threw unexpected exception" : "") + (errorResources.size() > 0 && heuristicResources.size() > 0 ? " and" : "") + (String)(heuristicResources.size() > 0 ? " resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally rolled back" + (hazard ? " (or hazard happened)" : "") : ""), phaseException);
    }

    @Override
    protected Job createJob(XAResourceHolderState resourceHolder) {
        return new CommitJob(resourceHolder);
    }

    @Override
    protected boolean isParticipating(XAResourceHolderState xaResourceHolderState) {
        for (XAResourceHolderState resourceHolderState : this.interestedResources) {
            if (xaResourceHolderState != resourceHolderState) continue;
            return true;
        }
        return false;
    }

    private final class CommitJob
    extends Job {
        public CommitJob(XAResourceHolderState resourceHolder) {
            super(resourceHolder);
        }

        @Override
        public XAException getXAException() {
            return this.xaException;
        }

        @Override
        public RuntimeException getRuntimeException() {
            return this.runtimeException;
        }

        @Override
        public void execute() {
            try {
                this.commitResource(this.getResource(), Committer.this.onePhase);
            }
            catch (RuntimeException ex) {
                this.runtimeException = ex;
            }
            catch (XAException ex) {
                this.xaException = ex;
            }
        }

        private void commitResource(XAResourceHolderState resourceHolder, boolean onePhase) throws XAException {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("committing resource " + String.valueOf(resourceHolder) + (onePhase ? " (with one-phase optimization)" : ""));
                }
                resourceHolder.getXAResource().commit(resourceHolder.getXid(), onePhase);
                Committer.this.committedResources.add(resourceHolder);
                if (log.isDebugEnabled()) {
                    log.debug("committed resource " + String.valueOf(resourceHolder));
                }
            }
            catch (XAException ex) {
                this.handleXAException(resourceHolder, ex, onePhase);
            }
        }

        private void handleXAException(XAResourceHolderState failedResourceHolder, XAException xaException, boolean onePhase) throws XAException {
            switch (xaException.errorCode) {
                case 7: {
                    this.forgetHeuristicCommit(failedResourceHolder);
                    return;
                }
                case -4: {
                    throw new BitronixXAException("unknown heuristic termination, global state of this transaction is unknown - guilty: " + String.valueOf(failedResourceHolder), 8, xaException);
                }
                case 5: 
                case 6: 
                case 8: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    log.error("heuristic rollback is incompatible with the global state of this transaction - guilty: " + String.valueOf(failedResourceHolder));
                    throw xaException;
                }
            }
            if (onePhase) {
                if (log.isDebugEnabled()) {
                    log.debug("XAException thrown in commit phase of 1PC optimization, rethrowing it");
                }
                throw xaException;
            }
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(xaException);
            log.warn("resource '" + failedResourceHolder.getUniqueName() + "' reported " + Decoder.decodeXAExceptionErrorCode(xaException) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails) + " when asked to commit transaction branch. Transaction is prepared and will commit via recovery service when resource availability allows.", (Throwable)xaException);
        }

        private void forgetHeuristicCommit(XAResourceHolderState resourceHolder) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("handling heuristic commit on resource " + String.valueOf(resourceHolder.getXAResource()));
                }
                resourceHolder.getXAResource().forget(resourceHolder.getXid());
                if (log.isDebugEnabled()) {
                    log.debug("forgotten heuristically committed resource " + String.valueOf(resourceHolder.getXAResource()));
                }
            }
            catch (XAException ex) {
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.error("cannot forget " + String.valueOf(resourceHolder.getXid()) + " assigned to " + String.valueOf(resourceHolder.getXAResource()) + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), (Throwable)ex);
            }
        }

        public String toString() {
            return "a CommitJob " + (Committer.this.onePhase ? "(one phase) " : "") + "with " + String.valueOf(this.getResource());
        }
    }
}

