/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.messaging.lrc;

import bitronix.tm.resource.messaging.lrc.LrcXAConnection;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.PropertyUtils;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAJMSContext;
import java.util.Properties;

public class LrcXAConnectionFactory
implements XAConnectionFactory {
    private volatile String connectionFactoryClassName;
    private volatile Properties properties = new Properties();

    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = connectionFactoryClassName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            Class clazz = ClassLoaderUtils.loadClass(this.connectionFactoryClassName);
            ConnectionFactory nonXaConnectionFactory = (ConnectionFactory)clazz.newInstance();
            PropertyUtils.setProperties(nonXaConnectionFactory, this.properties);
            return new LrcXAConnection(nonXaConnectionFactory.createConnection());
        }
        catch (Exception ex) {
            throw (JMSException)new JMSException("unable to connect to non-XA resource " + this.connectionFactoryClassName).initCause((Throwable)ex);
        }
    }

    public XAConnection createXAConnection(String user, String password) throws JMSException {
        try {
            Class clazz = ClassLoaderUtils.loadClass(this.connectionFactoryClassName);
            ConnectionFactory nonXaConnectionFactory = (ConnectionFactory)clazz.newInstance();
            PropertyUtils.setProperties(nonXaConnectionFactory, this.properties);
            return new LrcXAConnection(nonXaConnectionFactory.createConnection(user, password));
        }
        catch (Exception ex) {
            throw (JMSException)new JMSException("unable to connect to non-XA resource " + this.connectionFactoryClassName).initCause((Throwable)ex);
        }
    }

    public XAJMSContext createXAContext() {
        throw new RuntimeException("Method not supported");
    }

    public XAJMSContext createXAContext(String userName, String password) {
        throw new RuntimeException("Method not supported");
    }

    public String toString() {
        return "a JMS LrcXAConnectionFactory on " + this.connectionFactoryClassName + " with properties " + String.valueOf(this.properties);
    }
}

