/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.messaging;

import bitronix.tm.resource.messaging.MessagingPooledConnection;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;

public class MessagingConnectionHandle
implements Connection {
    private final XAConnection xaConnection;
    private final MessagingPooledConnection pooledConnection;
    private volatile boolean closed = false;

    public MessagingConnectionHandle(MessagingPooledConnection pooledConnection, XAConnection xaConnection) {
        this.pooledConnection = pooledConnection;
        this.xaConnection = xaConnection;
    }

    public XAConnection getXAConnection() throws JMSException {
        if (this.xaConnection == null) {
            throw new JMSException("XA connection handle has been closed");
        }
        return this.xaConnection;
    }

    public MessagingPooledConnection getPooledConnection() {
        return this.pooledConnection;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.pooledConnection.createSession(transacted, acknowledgeMode);
    }

    public Session createSession(int sessionMode) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public Session createSession() throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.pooledConnection.release();
    }

    public String toString() {
        return "a JmsConnectionHandle of " + String.valueOf(this.pooledConnection);
    }

    public String getClientID() throws JMSException {
        return this.getXAConnection().getClientID();
    }

    public void setClientID(String jndiName) throws JMSException {
        this.getXAConnection().setClientID(jndiName);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getXAConnection().getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getXAConnection().getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.getXAConnection().setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.getXAConnection().start();
    }

    public void stop() throws JMSException {
        this.getXAConnection().stop();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getXAConnection().createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.getXAConnection().createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new RuntimeException("Method not supported");
    }
}

