/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerWrapper
implements MessageConsumer {
    private final MessageConsumer messageConsumer;
    protected final DualSessionWrapper session;
    private final PoolingConnectionFactory poolingConnectionFactory;

    public MessageConsumerWrapper(MessageConsumer messageConsumer, DualSessionWrapper session, PoolingConnectionFactory poolingConnectionFactory) {
        this.messageConsumer = messageConsumer;
        this.session = session;
        this.poolingConnectionFactory = poolingConnectionFactory;
    }

    public MessageConsumer getMessageConsumer() {
        return this.messageConsumer;
    }

    protected void enlistResource() throws JMSException {
        if (this.poolingConnectionFactory.getAutomaticEnlistingEnabled()) {
            this.session.getSession();
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this.session);
            }
            catch (SystemException ex) {
                throw (JMSException)new JMSException("error enlisting " + String.valueOf(this)).initCause((Throwable)ex);
            }
            catch (RollbackException ex) {
                throw (JMSException)new JMSException("error enlisting " + String.valueOf(this)).initCause((Throwable)ex);
            }
        }
    }

    public String toString() {
        return "a MessageConsumerWrapper of " + String.valueOf(this.session);
    }

    public Message receive() throws JMSException {
        this.enlistResource();
        return this.getMessageConsumer().receive();
    }

    public Message receive(long timeout) throws JMSException {
        this.enlistResource();
        return this.getMessageConsumer().receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        this.enlistResource();
        return this.getMessageConsumer().receiveNoWait();
    }

    public void close() throws JMSException {
        this.getMessageConsumer().close();
    }

    public String getMessageSelector() throws JMSException {
        return this.getMessageConsumer().getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getMessageConsumer().getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.getMessageConsumer().setMessageListener(listener);
    }
}

