/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.internal.BitronixRollbackSystemException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.resource.common.AbstractXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jms.JmsPooledConnection;
import bitronix.tm.resource.jms.MessageConsumerWrapper;
import bitronix.tm.resource.jms.MessageProducerConsumerKey;
import bitronix.tm.resource.jms.MessageProducerWrapper;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import bitronix.tm.resource.jms.TopicSubscriberWrapper;
import bitronix.tm.utils.Decoder;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualSessionWrapper
extends AbstractXAResourceHolder
implements Session,
StateChangeListener {
    private static final Logger log = LoggerFactory.getLogger(DualSessionWrapper.class);
    private final JmsPooledConnection pooledConnection;
    private final boolean transacted;
    private final int acknowledgeMode;
    private XASession xaSession;
    private Session session;
    private XAResource xaResource;
    private MessageListener listener;
    private final Map<MessageProducerConsumerKey, MessageProducer> messageProducers = new HashMap<MessageProducerConsumerKey, MessageProducer>();
    private final Map<MessageProducerConsumerKey, MessageConsumer> messageConsumers = new HashMap<MessageProducerConsumerKey, MessageConsumer>();
    private final Map<MessageProducerConsumerKey, TopicSubscriberWrapper> topicSubscribers = new HashMap<MessageProducerConsumerKey, TopicSubscriberWrapper>();

    public DualSessionWrapper(JmsPooledConnection pooledConnection, boolean transacted, int acknowledgeMode) {
        this.pooledConnection = pooledConnection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        if (log.isDebugEnabled()) {
            log.debug("getting session handle from " + String.valueOf(pooledConnection));
        }
        this.setState(2);
        this.addStateChangeEventListener(this);
    }

    public PoolingConnectionFactory getPoolingConnectionFactory() {
        return this.pooledConnection.getPoolingConnectionFactory();
    }

    public Session getSession() throws JMSException {
        return this.getSession(false);
    }

    public Session getSession(boolean forceXa) throws JMSException {
        if (this.getState() == 0) {
            throw new IllegalStateException("session handle is closed");
        }
        if (forceXa) {
            if (log.isDebugEnabled()) {
                log.debug("choosing XA session (forced)");
            }
            return this.createXASession();
        }
        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
        if (currentTransaction != null) {
            if (log.isDebugEnabled()) {
                log.debug("choosing XA session");
            }
            return this.createXASession();
        }
        if (log.isDebugEnabled()) {
            log.debug("choosing non-XA session");
        }
        return this.createNonXASession();
    }

    private Session createNonXASession() throws JMSException {
        if (this.session == null) {
            this.session = this.pooledConnection.getXAConnection().createSession(this.transacted, this.acknowledgeMode);
            if (this.listener != null) {
                this.session.setMessageListener(this.listener);
                if (log.isDebugEnabled()) {
                    log.debug("get non-XA session registered message listener: " + String.valueOf(this.listener));
                }
            }
        }
        return this.session;
    }

    private Session createXASession() throws JMSException {
        if (this.xaSession == null) {
            this.xaSession = this.pooledConnection.getXAConnection().createXASession();
            if (this.listener != null) {
                this.xaSession.setMessageListener(this.listener);
                if (log.isDebugEnabled()) {
                    log.debug("get XA session registered message listener: " + String.valueOf(this.listener));
                }
            }
            this.xaResource = this.xaSession.getXAResource();
        }
        return this.xaSession.getSession();
    }

    public String toString() {
        return "a DualSessionWrapper in state " + Decoder.decodeXAStatefulHolderState(this.getState()) + " of " + String.valueOf(this.pooledConnection);
    }

    @Override
    public void close() throws JMSException {
        if (this.getState() != 2) {
            if (log.isDebugEnabled()) {
                log.debug("not closing already closed " + String.valueOf(this));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("closing " + String.valueOf(this));
        }
        try {
            TransactionContextHelper.delistFromCurrentTransaction(this);
        }
        catch (BitronixRollbackSystemException ex) {
            throw (JMSException)new TransactionRolledBackException("unilateral rollback of " + String.valueOf(this)).initCause((Throwable)((Object)ex));
        }
        catch (SystemException ex) {
            throw (JMSException)new JMSException("error delisting " + String.valueOf(this)).initCause((Throwable)ex);
        }
        finally {
            try {
                TransactionContextHelper.requeue(this, this.pooledConnection.getPoolingConnectionFactory());
            }
            catch (BitronixSystemException ex) {
                throw (JMSException)new JMSException("error requeuing " + String.valueOf(this)).initCause((Throwable)((Object)ex));
            }
        }
    }

    @Override
    public Date getLastReleaseDate() {
        return null;
    }

    @Override
    public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
        if (newState == 1) {
            this.setState(0);
        } else if (newState == 0) {
            if (log.isDebugEnabled()) {
                log.debug("session state changing to CLOSED, cleaning it up: " + String.valueOf(this));
            }
            if (this.xaSession != null) {
                try {
                    this.xaSession.close();
                }
                catch (JMSException ex) {
                    log.error("error closing XA session", (Throwable)ex);
                }
                this.xaSession = null;
                this.xaResource = null;
            }
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (JMSException ex) {
                    log.error("error closing session", (Throwable)ex);
                }
                this.session = null;
            }
            for (Map.Entry<MessageProducerConsumerKey, MessageProducer> entry : this.messageProducers.entrySet()) {
                MessageProducerWrapper messageProducerWrapper = (MessageProducerWrapper)entry.getValue();
                try {
                    messageProducerWrapper.close();
                }
                catch (JMSException ex) {
                    log.error("error closing message producer", (Throwable)ex);
                }
            }
            this.messageProducers.clear();
            for (Map.Entry<MessageProducerConsumerKey, MessageProducer> entry : this.messageConsumers.entrySet()) {
                MessageConsumerWrapper messageConsumerWrapper = (MessageConsumerWrapper)entry.getValue();
                try {
                    messageConsumerWrapper.close();
                }
                catch (JMSException ex) {
                    log.error("error closing message consumer", (Throwable)ex);
                }
            }
            this.messageConsumers.clear();
        }
    }

    @Override
    public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        MessageProducerWrapper messageProducer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination);
        if (log.isDebugEnabled()) {
            log.debug("looking for producer based on " + String.valueOf(key));
        }
        if ((messageProducer = (MessageProducerWrapper)this.messageProducers.get(key)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("found no producer based on " + String.valueOf(key) + ", creating it");
            }
            messageProducer = new MessageProducerWrapper(this.getSession().createProducer(destination), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (log.isDebugEnabled()) {
                    log.debug("caching producer via key " + String.valueOf(key));
                }
                this.messageProducers.put(key, messageProducer);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("found producer based on " + String.valueOf(key) + ", recycling it: " + String.valueOf(messageProducer));
        }
        return messageProducer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumerWrapper messageConsumer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination);
        if (log.isDebugEnabled()) {
            log.debug("looking for consumer based on " + String.valueOf(key));
        }
        if ((messageConsumer = (MessageConsumerWrapper)this.messageConsumers.get(key)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("found no consumer based on " + String.valueOf(key) + ", creating it");
            }
            messageConsumer = new MessageConsumerWrapper(this.getSession().createConsumer(destination), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (log.isDebugEnabled()) {
                    log.debug("caching consumer via key " + String.valueOf(key));
                }
                this.messageConsumers.put(key, messageConsumer);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("found consumer based on " + String.valueOf(key) + ", recycling it: " + String.valueOf(messageConsumer));
        }
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        MessageConsumerWrapper messageConsumer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination, messageSelector);
        if (log.isDebugEnabled()) {
            log.debug("looking for consumer based on " + String.valueOf(key));
        }
        if ((messageConsumer = (MessageConsumerWrapper)this.messageConsumers.get(key)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("found no consumer based on " + String.valueOf(key) + ", creating it");
            }
            messageConsumer = new MessageConsumerWrapper(this.getSession().createConsumer(destination, messageSelector), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (log.isDebugEnabled()) {
                    log.debug("caching consumer via key " + String.valueOf(key));
                }
                this.messageConsumers.put(key, messageConsumer);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("found consumer based on " + String.valueOf(key) + ", recycling it: " + String.valueOf(messageConsumer));
        }
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumerWrapper messageConsumer;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey(destination, messageSelector, noLocal);
        if (log.isDebugEnabled()) {
            log.debug("looking for consumer based on " + String.valueOf(key));
        }
        if ((messageConsumer = (MessageConsumerWrapper)this.messageConsumers.get(key)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("found no consumer based on " + String.valueOf(key) + ", creating it");
            }
            messageConsumer = new MessageConsumerWrapper(this.getSession().createConsumer(destination, messageSelector, noLocal), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (log.isDebugEnabled()) {
                    log.debug("caching consumer via key " + String.valueOf(key));
                }
                this.messageConsumers.put(key, messageConsumer);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("found consumer based on " + String.valueOf(key) + ", recycling it: " + String.valueOf(messageConsumer));
        }
        return messageConsumer;
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriberWrapper topicSubscriber;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey((Destination)topic);
        if (log.isDebugEnabled()) {
            log.debug("looking for durable subscriber based on " + String.valueOf(key));
        }
        if ((topicSubscriber = this.topicSubscribers.get(key)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("found no durable subscriber based on " + String.valueOf(key) + ", creating it");
            }
            topicSubscriber = new TopicSubscriberWrapper(this.getSession().createDurableSubscriber(topic, name), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (log.isDebugEnabled()) {
                    log.debug("caching durable subscriber via key " + String.valueOf(key));
                }
                this.topicSubscribers.put(key, topicSubscriber);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("found durable subscriber based on " + String.valueOf(key) + ", recycling it: " + String.valueOf(topicSubscriber));
        }
        return topicSubscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriberWrapper topicSubscriber;
        MessageProducerConsumerKey key = new MessageProducerConsumerKey((Destination)topic, messageSelector, noLocal);
        if (log.isDebugEnabled()) {
            log.debug("looking for durable subscriber based on " + String.valueOf(key));
        }
        if ((topicSubscriber = this.topicSubscribers.get(key)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("found no durable subscriber based on " + String.valueOf(key) + ", creating it");
            }
            topicSubscriber = new TopicSubscriberWrapper(this.getSession().createDurableSubscriber(topic, name, messageSelector, noLocal), this, this.pooledConnection.getPoolingConnectionFactory());
            if (this.pooledConnection.getPoolingConnectionFactory().getCacheProducersConsumers()) {
                if (log.isDebugEnabled()) {
                    log.debug("caching durable subscriber via key " + String.valueOf(key));
                }
                this.topicSubscribers.put(key, topicSubscriber);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("found durable subscriber based on " + String.valueOf(key) + ", recycling it: " + String.valueOf(topicSubscriber));
        }
        return topicSubscriber;
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        throw new RuntimeException("Method not supported");
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.getState() == 0) {
            throw new IllegalStateException("session handle is closed");
        }
        if (this.session != null) {
            this.session.setMessageListener(listener);
        }
        if (this.xaSession != null) {
            this.xaSession.setMessageListener(listener);
        }
        this.listener = listener;
    }

    public void run() {
        try {
            Session session = this.getSession(true);
            if (log.isDebugEnabled()) {
                log.debug("running XA session " + String.valueOf(session));
            }
            session.run();
        }
        catch (JMSException ex) {
            log.error("error getting session", (Throwable)ex);
        }
    }

    @Override
    public XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public ResourceBean getResourceBean() {
        return this.getPoolingConnectionFactory();
    }

    @Override
    public List<XAResourceHolder> getXAResourceHolders() {
        return Arrays.asList(this);
    }

    @Override
    public Object getConnectionHandle() throws Exception {
        return null;
    }

    public boolean getTransacted() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            return true;
        }
        return this.getSession().getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            return 0;
        }
        return this.getSession().getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            throw new TransactionInProgressException("cannot commit a resource enlisted in a global transaction");
        }
        this.getSession().commit();
    }

    public void rollback() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            throw new TransactionInProgressException("cannot rollback a resource enlisted in a global transaction");
        }
        this.getSession().rollback();
    }

    public void recover() throws JMSException {
        if (this.isParticipatingInActiveGlobalTransaction()) {
            throw new TransactionInProgressException("cannot recover a resource enlisted in a global transaction");
        }
        this.getSession().recover();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.enlistResource();
        return this.getSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.enlistResource();
        return this.getSession().createBrowser(queue, messageSelector);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getSession().createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.getSession().createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.getSession().createTopic(topicName);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.getSession().unsubscribe(name);
    }

    protected void enlistResource() throws JMSException {
        PoolingConnectionFactory poolingConnectionFactory = this.pooledConnection.getPoolingConnectionFactory();
        if (poolingConnectionFactory.getAutomaticEnlistingEnabled()) {
            this.getSession();
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this);
            }
            catch (SystemException ex) {
                throw (JMSException)new JMSException("error enlisting " + String.valueOf(this)).initCause((Throwable)ex);
            }
            catch (RollbackException ex) {
                throw (JMSException)new JMSException("error enlisting " + String.valueOf(this)).initCause((Throwable)ex);
            }
        }
    }
}

