/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.GaugeStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.HistogramStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.SumStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.SummaryStatelessMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.Metric;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

final class MetricStatelessMarshaler
implements StatelessMarshaler<MetricData> {
    static final MetricStatelessMarshaler INSTANCE = new MetricStatelessMarshaler();
    private static final Map<MetricDataType, StatelessMarshaler<MetricData>> METRIC_MARSHALERS = new EnumMap<MetricDataType, StatelessMarshaler<MetricData>>(MetricDataType.class);

    private MetricStatelessMarshaler() {
    }

    public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
        StatelessMarshaler<MetricData> metricMarshaler = METRIC_MARSHALERS.get(metric.getType());
        if (metricMarshaler == null) {
            return;
        }
        output.serializeStringWithContext(Metric.NAME, metric.getName(), context);
        output.serializeStringWithContext(Metric.DESCRIPTION, metric.getDescription(), context);
        output.serializeStringWithContext(Metric.UNIT, metric.getUnit(), context);
        metricMarshaler.writeTo(output, (Object)metric, context);
    }

    public int getBinarySerializedSize(MetricData metric, MarshalerContext context) {
        StatelessMarshaler<MetricData> metricMarshaler = METRIC_MARSHALERS.get(metric.getType());
        if (metricMarshaler == null) {
            return 0;
        }
        int size = 0;
        size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)Metric.NAME, (String)metric.getName(), (MarshalerContext)context);
        size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)Metric.DESCRIPTION, (String)metric.getDescription(), (MarshalerContext)context);
        size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)Metric.UNIT, (String)metric.getUnit(), (MarshalerContext)context);
        return size += metricMarshaler.getBinarySerializedSize((Object)metric, context);
    }

    static {
        METRIC_MARSHALERS.put(MetricDataType.LONG_GAUGE, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.GAUGE, (Object)metricData.getLongGaugeData(), (StatelessMarshaler)GaugeStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.GAUGE, (Object)metric.getLongGaugeData(), (StatelessMarshaler)GaugeStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.DOUBLE_GAUGE, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.GAUGE, (Object)metricData.getDoubleGaugeData(), (StatelessMarshaler)GaugeStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.GAUGE, (Object)metric.getDoubleGaugeData(), (StatelessMarshaler)GaugeStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.LONG_SUM, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.SUM, (Object)metricData.getLongSumData(), (StatelessMarshaler)SumStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.SUM, (Object)metric.getLongSumData(), (StatelessMarshaler)SumStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.DOUBLE_SUM, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.SUM, (Object)metricData.getDoubleSumData(), (StatelessMarshaler)SumStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.SUM, (Object)metric.getDoubleSumData(), (StatelessMarshaler)SumStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.SUMMARY, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.SUMMARY, (Object)metricData.getSummaryData(), (StatelessMarshaler)SummaryStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.SUMMARY, (Object)metric.getSummaryData(), (StatelessMarshaler)SummaryStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.HISTOGRAM, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.HISTOGRAM, (Object)metricData.getHistogramData(), (StatelessMarshaler)HistogramStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.HISTOGRAM, (Object)metric.getHistogramData(), (StatelessMarshaler)HistogramStatelessMarshaler.INSTANCE, context);
            }
        });
        METRIC_MARSHALERS.put(MetricDataType.EXPONENTIAL_HISTOGRAM, new StatelessMarshaler<MetricData>(){

            public int getBinarySerializedSize(MetricData metricData, MarshalerContext context) {
                return StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Metric.EXPONENTIAL_HISTOGRAM, (Object)metricData.getExponentialHistogramData(), (StatelessMarshaler)ExponentialHistogramStatelessMarshaler.INSTANCE, (MarshalerContext)context);
            }

            public void writeTo(Serializer output, MetricData metric, MarshalerContext context) throws IOException {
                output.serializeMessageWithContext(Metric.EXPONENTIAL_HISTOGRAM, (Object)metric.getExponentialHistogramData(), (StatelessMarshaler)ExponentialHistogramStatelessMarshaler.INSTANCE, context);
            }
        });
    }
}

