/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.BatchManager;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceStore;
import com.mulesoft.mule.runtime.module.batch.internal.ImmutableBatchJob;
import com.mulesoft.mule.runtime.module.batch.privileged.ImmutableBatchJobInstance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Iterator;
import org.mule.runtime.api.exception.MuleException;

public class DefaultBatchManager
implements BatchManager {
    @Inject
    @Named(value="batch.instance.store")
    private BatchJobInstanceStore jobInstanceStore;
    @Inject
    @Named(value="batch.engine")
    private BatchEngine batchEngine;

    @Override
    public Collection<BatchJob> getBatchJobs() {
        return ImmutableBatchJob.forCollection(this.batchEngine.getBatchJobs());
    }

    @Override
    public BatchJobInstance getJobInstance(String jobName, String jobInstanceId) throws MuleException {
        BatchJobInstanceAdapter jobInstance = this.fetchJobInstance(jobName, jobInstanceId, false);
        return jobInstance != null ? new ImmutableBatchJobInstance(jobInstance) : null;
    }

    @Override
    public Iterator<BatchJobInstance> getJobInstances(String jobName) {
        return new ImmutableBatchJobInstanceIterator(this.getJobInstanceStore().getJobInstances(jobName));
    }

    @Override
    public Iterator<BatchJobInstance> getExecutingInstances() throws Exception {
        return new ImmutableBatchJobInstanceIterator(this.getJobInstanceStore().getExecutingInstances().iterator());
    }

    @Override
    public void stop(String jobName, String jobInstanceId) throws MuleException {
        BatchJobInstanceAdapter jobInstance = this.fetchJobInstance(jobName, jobInstanceId);
        this.getBatchEngine().stopResumableExecution(jobInstance);
    }

    @Override
    public void resume(String jobName, String jobInstanceId) throws MuleException {
        BatchJobInstanceAdapter jobInstance = this.fetchJobInstance(jobName, jobInstanceId);
        this.getBatchEngine().resumeExecution(jobInstance);
    }

    @Override
    public void cancel(String jobName, String jobInstanceId) throws MuleException {
        BatchJobInstanceAdapter jobInstance = this.fetchJobInstance(jobName, jobInstanceId);
        this.getBatchEngine().cancel(jobInstance);
    }

    @Override
    public void cancelAllRunningInstances() throws MuleException {
        this.getBatchEngine().cancelAllRunningInstance();
    }

    @Override
    public void delete(String jobName, String jobInstanceId) throws MuleException {
        BatchJobInstanceAdapter jobInstance = this.fetchJobInstance(jobName, jobInstanceId);
        this.getJobInstanceStore().remove(jobInstance);
    }

    private BatchJobInstanceAdapter fetchJobInstance(String jobName, String jobInstanceId) {
        return this.fetchJobInstance(jobName, jobInstanceId, true);
    }

    private BatchJobInstanceAdapter fetchJobInstance(String jobName, String jobInstanceId, boolean throwsException) {
        BatchJobInstanceAdapter jobInstance = this.getJobInstanceStore().getJobInstance(jobName, jobInstanceId);
        if (jobInstance == null && throwsException) {
            throw new IllegalArgumentException(String.format("Could not find a BatchJobInstance with id %s for job %s", jobInstanceId, jobName));
        }
        return jobInstance;
    }

    private BatchEngine getBatchEngine() {
        return this.batchEngine;
    }

    private BatchJobInstanceStore getJobInstanceStore() {
        return this.jobInstanceStore;
    }

    private class ImmutableBatchJobInstanceIterator
    implements Iterator<BatchJobInstance> {
        private final Iterator<BatchJobInstance> decoratee;

        private ImmutableBatchJobInstanceIterator(Iterator<BatchJobInstance> decoratee) {
            this.decoratee = decoratee;
        }

        @Override
        public boolean hasNext() {
            return this.decoratee.hasNext();
        }

        @Override
        public BatchJobInstance next() {
            return new ImmutableBatchJobInstance(this.decoratee.next());
        }

        @Override
        public void remove() {
            this.decoratee.remove();
        }
    }
}

