/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.resource.common.XAPool;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;

public class PoolShrinkingTask
extends Task {
    private final XAPool xaPool;
    private final ClassLoader classLoader;

    public PoolShrinkingTask(XAPool xaPool, Date executionTime, TaskScheduler scheduler) {
        super(executionTime, scheduler);
        this.xaPool = xaPool;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object getObject() {
        return this.xaPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws TaskException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.xaPool.shrink();
            }
            catch (Exception ex) {
                throw new TaskException("error while trying to shrink " + String.valueOf(this.xaPool), ex);
            }
            finally {
                this.getTaskScheduler().schedulePoolShrinking(this.xaPool);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public String toString() {
        return "a PoolShrinkingTask scheduled for " + String.valueOf(this.getExecutionTime()) + " on " + String.valueOf(this.xaPool);
    }
}

