/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.loader.parser.ErrorModelParser;
import org.mule.runtime.extension.ic.internal.error.ConnectivityErrorModelParserFactory;
import org.mule.runtime.extension.ic.internal.error.DynamicErrorTypeDefinition;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityErrorModelParser;
import org.mule.runtime.extension.ic.internal.utils.StringUtils;

public class ErrorTypeDefinitionFactory {
    private ErrorTypeDefinitionFactory() {
    }

    public static ErrorTypeDefinition<?> createErrorTypeDefinition(String extensionName, String kind, Set<ErrorModel> errorModelSet) {
        if (StringUtils.isNullOrEmpty(kind)) {
            return MuleErrors.ANY;
        }
        ErrorTypeDefinition<?> errorTypeDefinition = ErrorTypeDefinitionFactory.createErrorTypeDefinitionFromCustomLogic(extensionName, kind);
        for (ErrorModel errorModel : errorModelSet) {
            if (!errorModel.getType().equals(errorTypeDefinition.getType())) continue;
            return errorTypeDefinition;
        }
        return ErrorTypeDefinitionFactory.convertToErrorTypeDefinition(ConnectivityErrorModelParserFactory.getDefaultErrorModelParser(kind, extensionName));
    }

    private static ErrorTypeDefinition<?> createErrorTypeDefinitionFromCustomLogic(String extensionName, String errorKind) {
        ConnectivityErrorModelParser errorModelParser = ConnectivityErrorModelParserFactory.createErrorModelParser(errorKind, extensionName);
        return ErrorTypeDefinitionFactory.convertToErrorTypeDefinition(errorModelParser);
    }

    private static ErrorTypeDefinition<?> convertToErrorTypeDefinition(ConnectivityErrorModelParser errorModelParser) {
        ErrorTypeDefinition<?> parentErrorType = null;
        Optional<ErrorModelParser> parentParserOptional = errorModelParser.getParent();
        if (parentParserOptional.isPresent()) {
            ConnectivityErrorModelParser parentParser = (ConnectivityErrorModelParser)parentParserOptional.get();
            parentErrorType = ErrorTypeDefinitionFactory.convertToErrorTypeDefinition(parentParser);
        }
        if (errorModelParser.isMuleError()) {
            return ErrorTypeDefinitionFactory.getMatchedMuleError(errorModelParser.getType(), parentErrorType);
        }
        return new DynamicErrorTypeDefinition(errorModelParser.getType(), parentErrorType);
    }

    private static ErrorTypeDefinition<?> getMatchedMuleError(String errorModelType, ErrorTypeDefinition<?> parentErrorType) {
        MuleErrors[] values;
        for (MuleErrors muleError : values = MuleErrors.values()) {
            if (!muleError.name().equals(errorModelType)) continue;
            return muleError;
        }
        return new DynamicErrorTypeDefinition(errorModelType, parentErrorType);
    }
}

